/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;

public class BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspectionBase
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("BeforeOrAfterWithIncorrectSignature" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspectionBase", "getID"));
        }
        return "BeforeOrAfterWithIncorrectSignature";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("before.class.or.after.class.is.public.static.void.no.arg.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("before.class.or.after.class.is.public.static.void.no.arg.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BeforeClassOrAfterClassIsPublicStaticVoidNoArgVisitor();
    }

    private static class BeforeClassOrAfterClassIsPublicStaticVoidNoArgVisitor
    extends BaseInspectionVisitor {
        private BeforeClassOrAfterClassIsPublicStaticVoidNoArgVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/junit/BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspectionBase$BeforeClassOrAfterClassIsPublicStaticVoidNoArgVisitor", "visitMethod"));
            }
            if (!TestUtils.isJUnit4BeforeClassOrAfterClassMethod(method2)) {
                return;
            }
            PsiType returnType = method2.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiClass targetClass = method2.getContainingClass();
            if (targetClass == null) {
                return;
            }
            PsiParameterList parameterList = method2.getParameterList();
            if (!(parameterList.getParametersCount() == 0 && returnType.equals(PsiType.VOID) && method2.hasModifierProperty("public") && method2.hasModifierProperty("static"))) {
                this.registerMethodError(method2, method2);
            }
        }
    }
}

