/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.actions.CleanupInspectionIntention;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringManager;
import com.intellij.refactoring.migration.MigrationManager;
import com.intellij.refactoring.migration.MigrationMap;
import com.intellij.refactoring.migration.MigrationProcessor;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.JUnit5AssertionsConverterInspection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnit5ConverterInspection
extends BaseInspection {
    private static final List<String> ruleAnnotations = Arrays.asList("org.junit.Rule", "org.junit.ClassRule");

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("junit5.converter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/JUnit5ConverterInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if ("#ref can be JUnit 5 test" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/JUnit5ConverterInspection", "buildErrorString"));
        }
        return "#ref can be JUnit 5 test";
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        if (!JavaVersionService.getInstance().isAtLeast((PsiElement)file2, JavaSdkVersion.JDK_1_8)) {
            return false;
        }
        if (JavaPsiFacade.getInstance((Project)file2.getProject()).findClass("org.junit.jupiter.api.Assertions", file2.getResolveScope()) == null) {
            return false;
        }
        return super.shouldInspect(file2);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MigrateToJUnit5();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            public void visitClass(PsiClass aClass) {
                TestFramework framework = TestFrameworks.detectFramework((PsiClass)aClass);
                if (framework == null || !"JUnit4".equals(framework.getName())) {
                    return;
                }
                if (!JUnit5ConverterInspection.canBeConvertedToJUnit5(aClass)) {
                    return;
                }
                this.registerClassError(aClass, new Object[0]);
            }
        };
    }

    protected static boolean canBeConvertedToJUnit5(PsiClass aClass) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"org.junit.runner.RunWith", (boolean)true)) {
            return false;
        }
        for (PsiField psiField : aClass.getAllFields()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiField, ruleAnnotations)) continue;
            return false;
        }
        for (PsiField psiField : aClass.getMethods()) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiField, ruleAnnotations)) {
                return false;
            }
            PsiAnnotation testAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiField, (boolean)true, (String[])new String[]{"org.junit.Test"});
            if (testAnnotation == null || testAnnotation.getParameterList().getAttributes().length <= 0) continue;
            return false;
        }
        return true;
    }

    private static class MyDescriptionBasedUsageInfo
    extends UsageInfo {
        private final ProblemDescriptor myDescriptor;

        public MyDescriptionBasedUsageInfo(ProblemDescriptor descriptor) {
            super(descriptor.getPsiElement());
            this.myDescriptor = descriptor;
        }
    }

    private static class MigrateToJUnit5
    extends InspectionGadgetsFix
    implements BatchQuickFix {
        private MigrateToJUnit5() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("junit5.converter.fix.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/JUnit5ConverterInspection$MigrateToJUnit5", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            MigrationManager manager;
            MigrationMap migrationMap;
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiClass.class);
            if (psiClass != null && (migrationMap = (manager = RefactoringManager.getInstance(project2).getMigrateManager()).findMigrationMap("JUnit (4.x -> 5.0)")) != null) {
                new MyJUnit5MigrationProcessor(project2, migrationMap, Collections.singleton(psiClass.getContainingFile())).run();
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project2, @NotNull CommonProblemDescriptor[] descriptors, @NotNull List psiElementsToIgnore, @Nullable Runnable refreshViews) {
            MigrationManager manager;
            MigrationMap migrationMap;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ig/junit/JUnit5ConverterInspection$MigrateToJUnit5", "applyFix"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/siyeh/ig/junit/JUnit5ConverterInspection$MigrateToJUnit5", "applyFix"));
            }
            if (psiElementsToIgnore == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElementsToIgnore", "com/siyeh/ig/junit/JUnit5ConverterInspection$MigrateToJUnit5", "applyFix"));
            }
            Set<PsiFile> files = Arrays.stream(descriptors).map(descriptor -> ((ProblemDescriptor)descriptor).getPsiElement()).filter(Objects::nonNull).map(element -> element.getContainingFile()).collect(Collectors.toSet());
            if (!files.isEmpty() && (migrationMap = (manager = RefactoringManager.getInstance(project2).getMigrateManager()).findMigrationMap("JUnit (4.x -> 5.0)")) != null) {
                new MyJUnit5MigrationProcessor(project2, migrationMap, files).run();
                if (refreshViews != null) {
                    refreshViews.run();
                }
            }
        }

        private static class MyJUnit5MigrationProcessor
        extends MigrationProcessor {
            private final Project myProject;
            private final Set<PsiFile> myFiles;

            public MyJUnit5MigrationProcessor(Project project2, MigrationMap migrationMap, Set<PsiFile> files) {
                super(project2, migrationMap, GlobalSearchScope.filesWithoutLibrariesScope((Project)project2, (Collection)ContainerUtil.map(files, file2 -> file2.getVirtualFile())));
                this.setPrepareSuccessfulSwingThreadCallback(EmptyRunnable.INSTANCE);
                this.myProject = project2;
                this.myFiles = files;
            }

            @Override
            protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
                if (refUsages == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/siyeh/ig/junit/JUnit5ConverterInspection$MigrateToJUnit5$MyJUnit5MigrationProcessor", "preprocessUsages"));
                }
                MultiMap conflicts = new MultiMap();
                for (PsiFile file2 : this.myFiles) {
                    for (PsiClass psiClass : ((PsiClassOwner)file2).getClasses()) {
                        HashSet inheritors = new HashSet();
                        ClassInheritorsSearch.search((PsiClass)psiClass).forEach(inheritor -> {
                            if (!JUnit5ConverterInspection.canBeConvertedToJUnit5(inheritor)) {
                                inheritors.add(inheritor);
                                return false;
                            }
                            return true;
                        });
                        if (inheritors.isEmpty()) continue;
                        conflicts.putValue((Object)psiClass, (Object)("Class " + RefactoringUIUtil.getDescription((PsiElement)psiClass, true) + " can't be converted to JUnit 5, cause there are incompatible inheritor(s): " + StringUtil.join(inheritors, aClass -> aClass.getQualifiedName(), (String)", ")));
                    }
                }
                this.setPreviewUsages(true);
                return this.showConflicts((MultiMap<PsiElement, String>)conflicts, (UsageInfo[])refUsages.get());
            }

            @Override
            @NotNull
            protected UsageInfo[] findUsages() {
                Object[] usages = super.findUsages();
                InspectionManager inspectionManager = InspectionManager.getInstance((Project)this.myProject);
                GlobalInspectionContext globalContext = inspectionManager.createNewGlobalContext(false);
                LocalInspectionToolWrapper assertionsConverter = new LocalInspectionToolWrapper((LocalInspectionTool)new JUnit5AssertionsConverterInspection("JUnit4"));
                Stream<MyDescriptionBasedUsageInfo> stream = this.myFiles.stream().flatMap(file2 -> InspectionEngine.runInspectionOnFile(file2, assertionsConverter, globalContext).stream());
                Object[] descriptors = (UsageInfo[])stream.map(descriptor -> new MyDescriptionBasedUsageInfo((ProblemDescriptor)descriptor)).toArray(UsageInfo[]::new);
                UsageInfo[] usageInfoArray = (UsageInfo[])ArrayUtil.mergeArrays((Object[])usages, (Object[])descriptors);
                if (usageInfoArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/JUnit5ConverterInspection$MigrateToJUnit5$MyJUnit5MigrationProcessor", "findUsages"));
                }
                return usageInfoArray;
            }

            @Override
            protected void performRefactoring(@NotNull UsageInfo[] usages) {
                if (usages == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/siyeh/ig/junit/JUnit5ConverterInspection$MigrateToJUnit5$MyJUnit5MigrationProcessor", "performRefactoring"));
                }
                ArrayList<UsageInfo> migrateUsages = new ArrayList<UsageInfo>();
                ArrayList<ProblemDescriptor> descriptions = new ArrayList<ProblemDescriptor>();
                for (UsageInfo usage : usages) {
                    if (usage instanceof MyDescriptionBasedUsageInfo) {
                        descriptions.add(((MyDescriptionBasedUsageInfo)usage).myDescriptor);
                        continue;
                    }
                    migrateUsages.add(usage);
                }
                super.performRefactoring(migrateUsages.toArray(new UsageInfo[migrateUsages.size()]));
                CleanupInspectionIntention.applyFixes(this.myProject, "Convert Assertions", descriptions, JUnit5AssertionsConverterInspection.ReplaceObsoleteAssertsFix.class);
            }
        }
    }
}

