/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.usageView.UsageInfo;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

class MakePublicStaticVoidFix
extends InspectionGadgetsFix {
    private final String myName;
    private final boolean myMakeStatic;

    public MakePublicStaticVoidFix(PsiMethod method2, boolean makeStatic) {
        this.myName = "Change signature of '" + PsiFormatUtil.formatMethod((PsiMethod)method2, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)267, (int)2) + "' to 'public " + (makeStatic ? "static " : "") + "void " + method2.getName() + "()'";
        this.myMakeStatic = makeStatic;
    }

    @Override
    protected void doFix(Project project2, ProblemDescriptor descriptor) {
        final PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class);
        if (method2 != null) {
            ChangeSignatureProcessor csp = new ChangeSignatureProcessor(project2, method2, false, "public", method2.getName(), (PsiType)PsiType.VOID, new ParameterInfoImpl[0]){

                @Override
                protected void performRefactoring(@NotNull UsageInfo[] usages) {
                    if (usages == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/siyeh/ig/junit/MakePublicStaticVoidFix$1", "performRefactoring"));
                    }
                    super.performRefactoring(usages);
                    PsiUtil.setModifierProperty((PsiModifierListOwner)method2, (String)"static", (boolean)MakePublicStaticVoidFix.this.myMakeStatic);
                }
            };
            csp.run();
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        if ("Fix modifiers" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/MakePublicStaticVoidFix", "getFamilyName"));
        }
        return "Fix modifiers";
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/MakePublicStaticVoidFix", "getName"));
        }
        return string;
    }
}

