/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;

public class TestMethodInProductCodeInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("test.method.in.product.code.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodInProductCodeInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("JUnitTestMethodInProductSource" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodInProductCodeInspection", "getID"));
        }
        return "JUnitTestMethodInProductSource";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("test.method.in.product.code.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodInProductCodeInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestCaseInProductCodeVisitor();
    }

    private static class TestCaseInProductCodeVisitor
    extends BaseInspectionVisitor {
        private TestCaseInProductCodeVisitor() {
        }

        public void visitMethod(PsiMethod method2) {
            PsiClass containingClass = method2.getContainingClass();
            if (TestUtils.isInTestSourceContent((PsiElement)containingClass) || !TestUtils.isAnnotatedTestMethod(method2)) {
                return;
            }
            this.registerMethodError(method2, new Object[0]);
        }
    }
}

