/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReplaceEmptyArrayToConstantFix
extends InspectionGadgetsFix {
    private final String myText;
    private final String myName;

    public ReplaceEmptyArrayToConstantFix(PsiClass aClass, PsiField field) {
        this.myText = aClass.getQualifiedName() + "." + field.getName();
        this.myName = InspectionGadgetsBundle.message("replace.with", aClass.getName() + "." + field.getName());
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/memory/ReplaceEmptyArrayToConstantFix", "getName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("constant.for.zero.length.array.quickfix.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/memory/ReplaceEmptyArrayToConstantFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected void doFix(Project project2, ProblemDescriptor descriptor) {
        PsiExpression newExp = JavaPsiFacade.getInstance((Project)project2).getElementFactory().createExpressionFromText(this.myText, descriptor.getPsiElement());
        PsiElement element = descriptor.getPsiElement().replace((PsiElement)newExp);
        JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(element);
    }
}

