/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import com.siyeh.ig.methodmetrics.ReturnPointCountVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class MultipleReturnPointsPerMethodInspection
extends MethodMetricInspection {
    public boolean ignoreGuardClauses = false;
    public boolean ignoreEqualsMethod = false;

    @NotNull
    public String getID() {
        if ("MethodWithMultipleReturnPoints" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/MultipleReturnPointsPerMethodInspection", "getID"));
        }
        return "MethodWithMultipleReturnPoints";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("multiple.return.points.per.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/MultipleReturnPointsPerMethodInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 1;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("return.point.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer returnPointCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("multiple.return.points.per.method.problem.descriptor", returnPointCount);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/MultipleReturnPointsPerMethodInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(InspectionGadgetsBundle.message("return.point.limit.option", new Object[0]));
        JFormattedTextField termLimitTextField = this.prepareNumberEditor("m_limit");
        CheckBox ignoreGuardClausesCheckBox = new CheckBox(InspectionGadgetsBundle.message("ignore.guard.clauses.option", new Object[0]), (InspectionProfileEntry)this, "ignoreGuardClauses");
        CheckBox ignoreEqualsMethodCheckBox = new CheckBox(InspectionGadgetsBundle.message("ignore.for.equals.methods.option", new Object[0]), (InspectionProfileEntry)this, "ignoreEqualsMethod");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 512;
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        panel2.add((Component)label, constraints);
        constraints.fill = 0;
        constraints.gridx = 1;
        panel2.add((Component)termLimitTextField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.weightx = 1.0;
        panel2.add((Component)ignoreGuardClausesCheckBox, constraints);
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        panel2.add((Component)ignoreEqualsMethodCheckBox, constraints);
        return panel2;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MultipleReturnPointsPerMethodVisitor();
    }

    private class MultipleReturnPointsPerMethodVisitor
    extends BaseInspectionVisitor {
        private MultipleReturnPointsPerMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/MultipleReturnPointsPerMethodInspection$MultipleReturnPointsPerMethodVisitor", "visitMethod"));
            }
            if (method2.getNameIdentifier() == null) {
                return;
            }
            if (MultipleReturnPointsPerMethodInspection.this.ignoreEqualsMethod && MethodUtils.isEquals(method2)) {
                return;
            }
            int returnPointCount = this.calculateReturnPointCount(method2);
            if (returnPointCount <= MultipleReturnPointsPerMethodInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method2, returnPointCount);
        }

        private int calculateReturnPointCount(PsiMethod method2) {
            ReturnPointCountVisitor visitor = new ReturnPointCountVisitor(MultipleReturnPointsPerMethodInspection.this.ignoreGuardClauses);
            method2.accept((PsiElementVisitor)visitor);
            int count = visitor.getCount();
            if (!this.mayFallThroughBottom(method2)) {
                return count;
            }
            PsiStatement lastStatement = ControlFlowUtils.getLastStatementInBlock(method2.getBody());
            if (ControlFlowUtils.statementMayCompleteNormally(lastStatement)) {
                return count + 1;
            }
            return count;
        }

        private boolean mayFallThroughBottom(PsiMethod method2) {
            if (method2.isConstructor()) {
                return true;
            }
            PsiType returnType = method2.getReturnType();
            return PsiType.VOID.equals((Object)returnType);
        }
    }
}

