/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.naming.ConventionInspection;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class NativeMethodNamingConventionInspectionBase
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 4;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("native.method.naming.convention.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/NativeMethodNamingConventionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    protected String getElementDescription() {
        return InspectionGadgetsBundle.message("native.method.naming.convention.element.description", new Object[0]);
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/NativeMethodNamingConventionInspectionBase$NamingConventionsVisitor", "visitMethod"));
            }
            super.visitMethod(method2);
            if (method2.isConstructor()) {
                return;
            }
            if (!method2.hasModifierProperty("native")) {
                return;
            }
            PsiIdentifier nameIdentifier = method2.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            String name = method2.getName();
            if (NativeMethodNamingConventionInspectionBase.this.isValid(name)) {
                return;
            }
            if (!this.isOnTheFly() && MethodUtils.hasSuper(method2)) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(method2)) {
                return;
            }
            this.registerMethodError(method2, name);
        }
    }
}

