/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.performance.MethodReferenceVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class MethodMayBeStaticInspectionBase
extends BaseInspection {
    protected static final String IGNORE_DEFAULT_METHODS_ATTR_NAME = "m_ignoreDefaultMethods";
    protected static final String ONLY_PRIVATE_OR_FINAL_ATTR_NAME = "m_onlyPrivateOrFinal";
    protected static final String IGNORE_EMPTY_METHODS_ATTR_NAME = "m_ignoreEmptyMethods";
    protected static final String REPLACE_QUALIFIER_ATTR_NAME = "m_replaceQualifier";
    public boolean m_onlyPrivateOrFinal = false;
    public boolean m_ignoreEmptyMethods = true;
    public boolean m_ignoreDefaultMethods = true;
    public boolean m_replaceQualifier = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.may.be.static.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/MethodMayBeStaticInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.may.be.static.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/MethodMayBeStaticInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCanBeStaticVisitor();
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/performance/MethodMayBeStaticInspectionBase", "writeSettings"));
        }
        node.addContent(new Element("option").setAttribute("name", ONLY_PRIVATE_OR_FINAL_ATTR_NAME).setAttribute("value", String.valueOf(this.m_onlyPrivateOrFinal)));
        node.addContent(new Element("option").setAttribute("name", IGNORE_EMPTY_METHODS_ATTR_NAME).setAttribute("value", String.valueOf(this.m_ignoreEmptyMethods)));
        if (!this.m_ignoreDefaultMethods) {
            node.addContent(new Element("option").setAttribute("name", IGNORE_DEFAULT_METHODS_ATTR_NAME).setAttribute("value", "false"));
        }
        if (!this.m_replaceQualifier) {
            node.addContent(new Element("option").setAttribute("name", REPLACE_QUALIFIER_ATTR_NAME).setAttribute("value", "false"));
        }
    }

    private class MethodCanBeStaticVisitor
    extends BaseInspectionVisitor {
        private MethodCanBeStaticVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            Condition[] addins;
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/performance/MethodMayBeStaticInspectionBase$MethodCanBeStaticVisitor", "visitMethod"));
            }
            super.visitMethod(method2);
            if (method2.hasModifierProperty("static") || method2.hasModifierProperty("abstract") || method2.hasModifierProperty("synchronized") || method2.hasModifierProperty("native")) {
                return;
            }
            if (method2.isConstructor() || method2.getNameIdentifier() == null) {
                return;
            }
            if (MethodMayBeStaticInspectionBase.this.m_ignoreDefaultMethods && method2.hasModifierProperty("default")) {
                return;
            }
            if (MethodMayBeStaticInspectionBase.this.m_ignoreEmptyMethods && MethodUtils.isEmpty(method2)) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)method2);
            if (containingClass == null) {
                return;
            }
            for (Condition addin : addins = (Condition[])InspectionManager.CANT_BE_STATIC_EXTENSION.getExtensions()) {
                if (!addin.value((Object)method2)) continue;
                return;
            }
            PsiElement scope = containingClass.getScope();
            if (!(scope instanceof PsiJavaFile || containingClass.hasModifierProperty("static") || containingClass.isInterface())) {
                return;
            }
            if (MethodMayBeStaticInspectionBase.this.m_onlyPrivateOrFinal && !method2.hasModifierProperty("final") && !method2.hasModifierProperty("private")) {
                return;
            }
            if (this.isExcluded(method2) || MethodUtils.hasSuper(method2) || MethodUtils.isOverridden(method2)) {
                return;
            }
            if (FindSuperElementsHelper.getSiblingInheritedViaSubClass(method2) != null) {
                return;
            }
            MethodReferenceVisitor visitor = new MethodReferenceVisitor((PsiMember)method2);
            method2.accept((PsiElementVisitor)visitor);
            if (!visitor.areReferencesStaticallyAccessible()) {
                return;
            }
            this.registerMethodError(method2, new Object[0]);
        }

        private boolean isExcluded(PsiMethod method2) {
            return SerializationUtils.isWriteObject(method2) || SerializationUtils.isReadObject(method2) || SerializationUtils.isWriteReplace(method2) || SerializationUtils.isReadResolve(method2);
        }
    }
}

