/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TailRecursionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("tail.recursion.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/TailRecursionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("tail.recursion.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/TailRecursionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethod containingMethod = (PsiMethod)infos[0];
        if (!TailRecursionInspection.mayBeReplacedByIterativeMethod(containingMethod)) {
            return null;
        }
        return new RemoveTailRecursionFix();
    }

    private static boolean mayBeReplacedByIterativeMethod(PsiMethod containingMethod) {
        PsiParameter[] parameters;
        if (containingMethod.isVarArgs()) {
            return false;
        }
        for (PsiParameter parameter : parameters = containingMethod.getParameterList().getParameters()) {
            if (!parameter.hasModifierProperty("final")) continue;
            return false;
        }
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TailRecursionVisitor();
    }

    private static class TailRecursionVisitor
    extends BaseInspectionVisitor {
        private TailRecursionVisitor() {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/performance/TailRecursionInspection$TailRecursionVisitor", "visitReturnStatement"));
            }
            super.visitReturnStatement(statement2);
            PsiExpression returnValue = ParenthesesUtils.stripParentheses(statement2.getReturnValue());
            if (!(returnValue instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression returnCall = (PsiMethodCallExpression)returnValue;
            PsiReferenceExpression methodExpression = returnCall.getMethodExpression();
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            if (containingMethod == null) {
                return;
            }
            JavaResolveResult resolveResult = returnCall.resolveMethodGenerics();
            if (!resolveResult.isValidResult() || !containingMethod.equals(resolveResult.getElement())) {
                return;
            }
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && MethodUtils.isOverridden(containingMethod)) {
                return;
            }
            this.registerMethodCallError(returnCall, containingMethod);
        }
    }

    private static class RemoveTailRecursionFix
    extends InspectionGadgetsFix {
        private RemoveTailRecursionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("tail.recursion.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/TailRecursionInspection$RemoveTailRecursionFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            boolean tailCallIsContainedInLoop;
            String thisVariableName;
            PsiElement tailCallToken = descriptor.getPsiElement();
            PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)tailCallToken, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            if (method2 == null) {
                return;
            }
            PsiCodeBlock body = method2.getBody();
            if (body == null) {
                return;
            }
            StringBuilder builder = new StringBuilder();
            builder.append('{');
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass == null) {
                return;
            }
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project2);
            if (RemoveTailRecursionFix.methodReturnsContainingClassType(method2, containingClass)) {
                builder.append(containingClass.getName());
                thisVariableName = styleManager.suggestUniqueVariableName("result", (PsiElement)method2, false);
                builder.append(' ').append(thisVariableName).append(" = this;");
            } else if (RemoveTailRecursionFix.methodContainsCallOnOtherInstance(method2)) {
                builder.append(containingClass.getName());
                thisVariableName = styleManager.suggestUniqueVariableName("other", (PsiElement)method2, false);
                builder.append(' ').append(thisVariableName).append(" = this;");
            } else {
                thisVariableName = null;
            }
            if (ControlFlowUtils.isInLoop(tailCallToken)) {
                tailCallIsContainedInLoop = true;
                builder.append(method2.getName()).append(':');
            } else {
                tailCallIsContainedInLoop = false;
            }
            builder.append("while(true)");
            RemoveTailRecursionFix.replaceTailCalls((PsiElement)body, method2, thisVariableName, tailCallIsContainedInLoop, builder);
            builder.append('}');
            PsiCodeBlock block = JavaPsiFacade.getElementFactory((Project)project2).createCodeBlockFromText(builder.toString(), (PsiElement)method2);
            body.replace((PsiElement)block);
            CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)method2);
        }

        private static boolean methodReturnsContainingClassType(PsiMethod method2, PsiClass containingClass) {
            if (containingClass == null) {
                return false;
            }
            if (method2.hasModifierProperty("static")) {
                return false;
            }
            PsiType returnType = method2.getReturnType();
            if (!(returnType instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)returnType;
            PsiClass aClass = classType.resolve();
            return containingClass.equals(aClass);
        }

        private static boolean methodContainsCallOnOtherInstance(PsiMethod method2) {
            if (method2.hasModifierProperty("static")) {
                return false;
            }
            PsiCodeBlock body = method2.getBody();
            if (body == null) {
                return false;
            }
            PsiClass aClass = method2.getContainingClass();
            MethodContainsCallOnOtherInstanceVisitor visitor = new MethodContainsCallOnOtherInstanceVisitor(aClass);
            body.accept((PsiElementVisitor)visitor);
            return visitor.containsCallOnOtherInstance();
        }

        private static void replaceTailCalls(PsiElement element, PsiMethod method2, @Nullable String thisVariableName, boolean tailCallIsContainedInLoop, @NonNls StringBuilder out) {
            if (RemoveTailRecursionFix.isImplicitCallOnThis(element, method2)) {
                if (thisVariableName != null) {
                    out.append(thisVariableName).append('.');
                }
                out.append(element.getText());
            } else if (element instanceof PsiThisExpression || element instanceof PsiSuperExpression) {
                if (thisVariableName == null) {
                    out.append(element.getText());
                } else {
                    out.append(thisVariableName);
                }
            } else if (RemoveTailRecursionFix.isTailCallReturn(element, method2)) {
                PsiReferenceExpression methodExpression;
                PsiExpression qualifier;
                PsiReturnStatement returnStatement = (PsiReturnStatement)element;
                PsiMethodCallExpression call = (PsiMethodCallExpression)ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
                assert (call != null);
                PsiExpression[] arguments = call.getArgumentList().getExpressions();
                PsiParameter[] parameters = method2.getParameterList().getParameters();
                boolean isInBlock = returnStatement.getParent() instanceof PsiCodeBlock;
                if (!isInBlock) {
                    out.append('{');
                }
                Graph<Integer> graph = RemoveTailRecursionFix.buildGraph(parameters, arguments);
                DFSTBuilder builder = new DFSTBuilder(graph);
                List sortedNodes = builder.getSortedNodes();
                HashSet<Integer> seen = new HashSet<Integer>();
                HashMap<PsiElement, String> replacements = new HashMap<PsiElement, String>();
                for (Integer index : sortedNodes) {
                    PsiReferenceExpression referenceExpression;
                    PsiParameter parameter = parameters[index];
                    String parameterName = parameter.getName();
                    assert (parameterName != null);
                    PsiExpression argument = ParenthesesUtils.stripParentheses(arguments[index]);
                    assert (argument != null);
                    if (argument instanceof PsiReferenceExpression && parameter.equals((referenceExpression = (PsiReferenceExpression)argument).resolve())) continue;
                    Iterator dependants = graph.getIn((Object)index);
                    boolean copy = false;
                    while (dependants.hasNext()) {
                        if (seen.contains(dependants.next())) continue;
                        copy = true;
                        break;
                    }
                    if (copy) {
                        String variableName = JavaCodeStyleManager.getInstance((Project)method2.getProject()).suggestUniqueVariableName(parameterName, element, false);
                        out.append(parameter.getType().getCanonicalText()).append(' ').append(variableName).append('=');
                        out.append(parameterName).append(';');
                        replacements.put((PsiElement)parameter, variableName);
                    }
                    out.append(parameterName).append('=');
                    RemoveTailRecursionFix.buildText((PsiElement)argument, replacements, out);
                    out.append(';');
                    seen.add(index);
                }
                if (thisVariableName != null && (qualifier = (methodExpression = call.getMethodExpression()).getQualifierExpression()) != null) {
                    out.append(thisVariableName).append('=');
                    RemoveTailRecursionFix.replaceTailCalls((PsiElement)qualifier, method2, thisVariableName, tailCallIsContainedInLoop, out);
                    out.append(';');
                }
                PsiCodeBlock body = method2.getBody();
                assert (body != null);
                if (!ControlFlowUtils.blockCompletesWithStatement(body, (PsiStatement)returnStatement)) {
                    if (tailCallIsContainedInLoop) {
                        out.append("continue ").append(method2.getName()).append(';');
                    } else {
                        out.append("continue;");
                    }
                }
                if (!isInBlock) {
                    out.append('}');
                }
            } else {
                PsiElement[] children2 = element.getChildren();
                if (children2.length == 0) {
                    out.append(element.getText());
                } else {
                    for (PsiElement child : children2) {
                        RemoveTailRecursionFix.replaceTailCalls(child, method2, thisVariableName, tailCallIsContainedInLoop, out);
                    }
                }
            }
        }

        private static void buildText(PsiElement element, Map<PsiElement, String> replacements, StringBuilder out) {
            if (element instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiElement target = referenceExpression.resolve();
                String replacement = replacements.get(target);
                out.append(replacement != null ? replacement : element.getText());
                return;
            }
            PsiElement[] children2 = element.getChildren();
            if (children2.length > 0) {
                for (PsiElement child : children2) {
                    RemoveTailRecursionFix.buildText(child, replacements, out);
                }
            } else {
                out.append(element.getText());
            }
        }

        private static Graph<Integer> buildGraph(final PsiParameter[] parameters, final PsiExpression[] arguments) {
            InboundSemiGraph<Integer> graph = new InboundSemiGraph<Integer>(){

                public Collection<Integer> getNodes() {
                    ArrayList<Integer> result2 = new ArrayList<Integer>();
                    for (int i2 = 0; i2 < parameters.length; ++i2) {
                        result2.add(i2);
                    }
                    return result2;
                }

                public Iterator<Integer> getIn(Integer n) {
                    ArrayList<Integer> result2 = new ArrayList<Integer>();
                    PsiParameter target = parameters[n];
                    int length = arguments.length;
                    for (int i2 = 0; i2 < length; ++i2) {
                        if (i2 == n || !VariableAccessUtils.variableIsUsed((PsiVariable)target, (PsiElement)arguments[i2])) continue;
                        result2.add(i2);
                    }
                    return result2.iterator();
                }
            };
            return GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)graph));
        }

        private static boolean isImplicitCallOnThis(PsiElement element, PsiMethod containingMethod) {
            if (containingMethod.hasModifierProperty("static")) {
                return false;
            }
            if (element instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                return qualifierExpression == null;
            }
            if (element instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiElement parent = referenceExpression.getParent();
                if (parent instanceof PsiMethodCallExpression) {
                    return false;
                }
                PsiExpression qualifier = referenceExpression.getQualifierExpression();
                if (qualifier != null) {
                    return false;
                }
                PsiElement target = referenceExpression.resolve();
                return target instanceof PsiField;
            }
            return false;
        }

        private static boolean isTailCallReturn(PsiElement element, PsiMethod containingMethod) {
            if (!(element instanceof PsiReturnStatement)) {
                return false;
            }
            PsiReturnStatement returnStatement = (PsiReturnStatement)element;
            PsiExpression returnValue = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
            if (!(returnValue instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)returnValue;
            PsiMethod method2 = call.resolveMethod();
            return containingMethod.equals(method2);
        }

        private static class MethodContainsCallOnOtherInstanceVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private boolean containsCallOnOtherInstance;
            private final PsiClass aClass;

            MethodContainsCallOnOtherInstanceVisitor(PsiClass aClass) {
                this.aClass = aClass;
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                if (this.containsCallOnOtherInstance) {
                    return;
                }
                super.visitMethodCallExpression(expression);
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (qualifier == null || qualifier instanceof PsiThisExpression) {
                    return;
                }
                PsiMethod method2 = expression.resolveMethod();
                if (method2 == null) {
                    return;
                }
                PsiClass containingClass = method2.getContainingClass();
                if (this.aClass.equals(containingClass)) {
                    this.containsCallOnOtherInstance = true;
                }
            }

            boolean containsCallOnOtherInstance() {
                return this.containsCallOnOtherInstance;
            }
        }
    }
}

