/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class ConstructionUtils {
    private static final Set<String> GUAVA_UTILITY_CLASSES = ContainerUtil.set((Object[])new String[]{"com.google.common.collect.Maps", "com.google.common.collect.Lists", "com.google.common.collect.Sets"});
    private static final CallMatcher ENUM_SET_NONE_OF = CallMatcher.staticCall("java.util.EnumSet", "noneOf").parameterCount(1);

    @Contract(value="null -> false")
    public static boolean isEmptyStringBuilderInitializer(PsiExpression initializer) {
        return "\"\"".equals(ConstructionUtils.getStringBuilderInitializerText(initializer));
    }

    @Contract(value="null -> null")
    public static String getStringBuilderInitializerText(PsiExpression construction) {
        if (!((construction = PsiUtil.skipParenthesizedExprDown((PsiExpression)construction)) instanceof PsiNewExpression)) {
            return null;
        }
        PsiNewExpression newExpression = (PsiNewExpression)construction;
        PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
        if (classReference == null) {
            return null;
        }
        PsiElement target = classReference.resolve();
        if (!(target instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)target;
        String qualifiedName = aClass.getQualifiedName();
        if (!"java.lang.StringBuilder".equals(qualifiedName) && !"java.lang.StringBuffer".equals(qualifiedName)) {
            return null;
        }
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length == 0) {
            return "\"\"";
        }
        if (arguments.length != 1) {
            return null;
        }
        PsiExpression argument = arguments[0];
        PsiType argumentType = argument.getType();
        if (PsiType.INT.equals((Object)argumentType)) {
            return "\"\"";
        }
        return argument.getText();
    }

    @Contract(value="null -> false")
    public static boolean isEmptyCollectionInitializer(PsiExpression expression) {
        PsiExpressionList argumentList;
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiNewExpression && (argumentList = ((PsiNewExpression)expression).getArgumentList()) != null && argumentList.getExpressions().length == 0) {
            PsiType type = expression.getType();
            return InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Collection") || InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map");
        }
        if (expression instanceof PsiMethodCallExpression) {
            String qualifiedName;
            PsiClass aClass;
            PsiMethod method2;
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            String name = call.getMethodExpression().getReferenceName();
            PsiExpressionList argumentList2 = call.getArgumentList();
            if (name != null && name.startsWith("new") && argumentList2.getExpressions().length == 0 && (method2 = call.resolveMethod()) != null && method2.getParameterList().getParametersCount() == 0 && (aClass = method2.getContainingClass()) != null && GUAVA_UTILITY_CLASSES.contains(qualifiedName = aClass.getQualifiedName())) {
                return true;
            }
        }
        return ConstructionUtils.isCustomizedEmptyCollectionInitializer(expression);
    }

    @Contract(value="null -> false")
    public static boolean isCustomizedEmptyCollectionInitializer(PsiExpression expression) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiNewExpression) {
            PsiExpressionList argumentList = ((PsiNewExpression)expression).getArgumentList();
            if (argumentList == null || argumentList.getExpressions().length == 0) {
                return false;
            }
            PsiMethod constructor = ((PsiNewExpression)expression).resolveConstructor();
            if (constructor == null) {
                return false;
            }
            PsiClass aClass = constructor.getContainingClass();
            if (aClass == null || aClass.getQualifiedName() == null || !aClass.getQualifiedName().startsWith("java.util.")) {
                return false;
            }
            Predicate<PsiType> allowedParameterType = t -> t instanceof PsiPrimitiveType || InheritanceUtil.isInheritor((PsiType)t, (String)"java.lang.Class");
            return Stream.of(constructor.getParameterList().getParameters()).map(PsiVariable::getType).allMatch(allowedParameterType);
        }
        if (expression instanceof PsiMethodCallExpression) {
            String qualifiedName;
            PsiClass aClass;
            PsiMethod method2;
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            if (ENUM_SET_NONE_OF.test(call)) {
                return true;
            }
            String name = call.getMethodExpression().getReferenceName();
            PsiExpressionList argumentList = call.getArgumentList();
            if (name != null && name.startsWith("new") && argumentList.getExpressions().length > 0 && (method2 = call.resolveMethod()) != null && method2.getParameterList().getParametersCount() > 0 && (aClass = method2.getContainingClass()) != null && GUAVA_UTILITY_CLASSES.contains(qualifiedName = aClass.getQualifiedName())) {
                return Stream.of(method2.getParameterList().getParameters()).allMatch(p -> p.getType() instanceof PsiPrimitiveType);
            }
        }
        return false;
    }

    public static boolean isEmptyArrayInitializer(@Nullable PsiExpression expression) {
        if (!((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiNewExpression)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)expression;
        PsiExpression[] dimensions = newExpression.getArrayDimensions();
        if (dimensions.length == 0) {
            PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
            if (arrayInitializer == null) {
                return false;
            }
            PsiExpression[] initializers = arrayInitializer.getInitializers();
            return initializers.length == 0;
        }
        for (PsiExpression dimension : dimensions) {
            String dimensionText = dimension.getText();
            if ("0".equals(dimensionText)) continue;
            return false;
        }
        return true;
    }
}

