/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import one.util.streamex.StreamEx;

public class FunctionalExpressionUtils {
    public static boolean isFunctionalReferenceTo(PsiExpression expression, String className, PsiType returnType, String methodName, PsiType ... parameterTypes) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expression;
            if (!methodName.equals(methodRef.getReferenceName())) {
                return false;
            }
            PsiMethod method2 = (PsiMethod)ObjectUtils.tryCast((Object)methodRef.resolve(), PsiMethod.class);
            PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)methodRef.getQualifier(), PsiReferenceExpression.class);
            return ref != null && method2 != null && MethodUtils.methodMatches(method2, className, returnType, methodName, parameterTypes) && ref.isReferenceTo((PsiElement)method2.getContainingClass());
        }
        if (expression instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)expression;
            PsiExpression body = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody()));
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)body, PsiMethodCallExpression.class);
            if (call == null || !MethodCallUtils.isCallToMethod(call, className, returnType, methodName, parameterTypes)) {
                return false;
            }
            Object[] parameters = lambda2.getParameterList().getParameters();
            Object[] args = call.getArgumentList().getExpressions();
            PsiMethod method3 = call.resolveMethod();
            if (method3 != null && !method3.hasModifierProperty("static")) {
                args = (PsiExpression[])ArrayUtil.prepend((Object)call.getMethodExpression().getQualifierExpression(), (Object[])args);
            }
            if (parameters.length != args.length || StreamEx.zip((Object[])args, (Object[])parameters, ExpressionUtils::isReferenceTo).has((Object)false)) {
                return false;
            }
            return MethodCallUtils.isCallToMethod(call, className, returnType, methodName, parameterTypes);
        }
        return false;
    }
}

