/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import org.jetbrains.annotations.NotNull;

class RecursionVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean recursive;
    private final PsiMethod method;
    private final String methodName;

    RecursionVisitor(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/RecursionVisitor", "<init>"));
        }
        this.method = method2;
        this.methodName = method2.getName();
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/RecursionVisitor", "visitElement"));
        }
        if (!this.recursive) {
            super.visitElement(element);
        }
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/psiutils/RecursionVisitor", "visitMethodCallExpression"));
        }
        if (this.recursive) {
            return;
        }
        super.visitMethodCallExpression(call);
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String calledMethodName = methodExpression.getReferenceName();
        if (!this.methodName.equals(calledMethodName)) {
            return;
        }
        PsiMethod calledMethod = call.resolveMethod();
        if (!this.method.equals(calledMethod)) {
            return;
        }
        if (this.method.hasModifierProperty("static") || this.method.hasModifierProperty("private")) {
            this.recursive = true;
            return;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null || qualifier instanceof PsiThisExpression) {
            this.recursive = true;
        }
    }

    public boolean isRecursive() {
        return this.recursive;
    }
}

