/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.resources.ResourceInspection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JDBCResourceInspection
extends ResourceInspection {
    private static final String[] creationMethodClassName = new String[]{"java.sql.Driver", "java.sql.DriverManager", "javax.sql.DataSource", "java.sql.Connection", "java.sql.Connection", "java.sql.Connection", "java.sql.Statement", "java.sql.Statement", "java.sql.Statement"};
    @NonNls
    private static final String[] creationMethodName = new String[]{"connect", "getConnection", "getConnection", "createStatement", "prepareStatement", "prepareCall", "executeQuery", "getResultSet", "getGeneratedKeys"};
    private static final Set<String> creationMethodNameSet = new HashSet<String>(9);

    @NotNull
    public String getID() {
        if ("JDBCResourceOpenedButNotSafelyClosed" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/resources/JDBCResourceInspection", "getID"));
        }
        return "JDBCResourceOpenedButNotSafelyClosed";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("jdbc.resource.opened.not.closed.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/resources/JDBCResourceInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected boolean isResourceCreation(PsiExpression expression) {
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (name == null || !creationMethodNameSet.contains(name)) {
            return false;
        }
        PsiMethod method2 = methodCallExpression.resolveMethod();
        if (method2 == null) {
            return false;
        }
        for (int i2 = 0; i2 < creationMethodName.length; ++i2) {
            String expectedClassName;
            PsiClass containingClass;
            if (!name.equals(creationMethodName[i2]) || !InheritanceUtil.isInheritor((PsiClass)(containingClass = method2.getContainingClass()), (boolean)false, (String)(expectedClassName = creationMethodClassName[i2]))) continue;
            return true;
        }
        return false;
    }

    static {
        ContainerUtil.addAll(creationMethodNameSet, (Object[])creationMethodName);
    }
}

