/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ChangeModifierFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class ReadResolveAndWriteReplaceProtectedInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("readresolve.writereplace.protected.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/ReadResolveAndWriteReplaceProtectedInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("readresolve.writereplace.protected.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/ReadResolveAndWriteReplaceProtectedInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReadResolveWriteReplaceProtectedVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ChangeModifierFix("protected");
    }

    private static class ReadResolveWriteReplaceProtectedVisitor
    extends BaseInspectionVisitor {
        private ReadResolveWriteReplaceProtectedVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/serialization/ReadResolveAndWriteReplaceProtectedInspection$ReadResolveWriteReplaceProtectedVisitor", "visitMethod"));
            }
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (method2.hasModifierProperty("protected")) {
                return;
            }
            if (aClass.hasModifierProperty("final") && method2.hasModifierProperty("private")) {
                return;
            }
            if (!SerializationUtils.isReadResolve(method2) && !SerializationUtils.isWriteReplace(method2)) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerMethodError(method2, new Object[0]);
        }
    }
}

