/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SharedThreadLocalRandomInspectionBase
extends BaseInspection {
    protected final MethodMatcher myMethodMatcher = new MethodMatcher(false, "ignoreArgumentToMethods").add("java.math.BigInteger", ".*").add("java.util.Collections", "shuffle").finishDefault();

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("shared.thread.local.random.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SharedThreadLocalRandomInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("shared.thread.local.random.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SharedThreadLocalRandomInspectionBase", "buildErrorString"));
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/threading/SharedThreadLocalRandomInspectionBase", "readSettings"));
        }
        super.readSettings(element);
        this.myMethodMatcher.readSettings(element);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/threading/SharedThreadLocalRandomInspectionBase", "writeSettings"));
        }
        super.writeSettings(element);
        this.myMethodMatcher.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SharedThreadLocalRandomVisitor();
    }

    private class SharedThreadLocalRandomVisitor
    extends BaseInspectionVisitor {
        private SharedThreadLocalRandomVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"current".equals(name)) {
                return;
            }
            PsiMethod method2 = expression.resolveMethod();
            if (method2 == null) {
                return;
            }
            PsiClass aClass = method2.getContainingClass();
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.concurrent.ThreadLocalRandom")) {
                return;
            }
            if (this.isArgumentToMethodCall((PsiExpression)expression)) {
                this.registerMethodCallError(expression, new Object[0]);
            } else {
                PsiVariable variable = this.assignedToVariable(expression);
                if (variable instanceof PsiField) {
                    this.registerMethodCallError(expression, new Object[0]);
                } else if (variable instanceof PsiLocalVariable) {
                    PsiCodeBlock context = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
                    boolean passed = VariableAccessUtils.variableIsPassedAsMethodArgument(variable, (PsiElement)context, (Processor<PsiCall>)((Processor)SharedThreadLocalRandomInspectionBase.this.myMethodMatcher::matches));
                    if (passed || VariableAccessUtils.variableIsUsedInInnerClass(variable, (PsiElement)context)) {
                        this.registerMethodCallError(expression, new Object[0]);
                    }
                }
            }
        }

        private boolean isArgumentToMethodCall(PsiExpression expression) {
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression);
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            return !SharedThreadLocalRandomInspectionBase.this.myMethodMatcher.matches((PsiCall)methodCallExpression);
        }

        private PsiVariable assignedToVariable(PsiMethodCallExpression expression) {
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expression, (Class[])new Class[]{PsiParenthesizedExpression.class});
            if (parent instanceof PsiVariable) {
                return (PsiVariable)parent;
            }
            if (!(parent instanceof PsiAssignmentExpression)) {
                return null;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (!PsiTreeUtil.isAncestor((PsiElement)rhs, (PsiElement)expression, (boolean)false)) {
                return null;
            }
            PsiExpression lhs = ParenthesesUtils.stripParentheses(assignmentExpression.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return null;
            }
            return (PsiVariable)target;
        }
    }
}

