/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class UnconditionalWaitInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unconditional.wait.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/UnconditionalWaitInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unconditional.wait.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/UnconditionalWaitInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnconditionalWaitVisitor();
    }

    private static class UnconditionalWaitVisitor
    extends BaseInspectionVisitor {
        private UnconditionalWaitVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/threading/UnconditionalWaitInspection$UnconditionalWaitVisitor", "visitMethod"));
            }
            super.visitMethod(method2);
            if (!method2.hasModifierProperty("synchronized")) {
                return;
            }
            PsiCodeBlock body = method2.getBody();
            if (body != null) {
                this.checkBody(body);
            }
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/UnconditionalWaitInspection$UnconditionalWaitVisitor", "visitSynchronizedStatement"));
            }
            super.visitSynchronizedStatement(statement2);
            PsiCodeBlock body = statement2.getBody();
            if (body != null) {
                this.checkBody(body);
            }
        }

        private void checkBody(PsiCodeBlock body) {
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return;
            }
            for (PsiStatement statement2 : statements) {
                PsiType parameterType;
                PsiParameterList parameterList;
                int numParams;
                PsiMethod method2;
                PsiMethodCallExpression methodCallExpression;
                PsiReferenceExpression methodExpression;
                String methodName;
                PsiExpression firstExpression;
                if (UnconditionalWaitVisitor.isConditional(statement2)) {
                    return;
                }
                if (!(statement2 instanceof PsiExpressionStatement) || !((firstExpression = ((PsiExpressionStatement)statement2).getExpression()) instanceof PsiMethodCallExpression) || !"wait".equals(methodName = (methodExpression = (methodCallExpression = (PsiMethodCallExpression)firstExpression).getMethodExpression()).getReferenceName()) || (method2 = methodCallExpression.resolveMethod()) == null || (numParams = (parameterList = method2.getParameterList()).getParametersCount()) > 2) continue;
                PsiParameter[] parameters = parameterList.getParameters();
                if (numParams > 0 && !(parameterType = parameters[0].getType()).equals(PsiType.LONG) || numParams > 1 && !(parameterType = parameters[1].getType()).equals(PsiType.INT)) continue;
                this.registerMethodCallError(methodCallExpression, new Object[0]);
            }
        }

        private static boolean isConditional(PsiStatement statement2) {
            return statement2 instanceof PsiIfStatement;
        }
    }
}

