/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodOverloadsParentMethodInspectionBase
extends BaseInspection {
    public boolean reportIncompatibleParameters = false;

    @NotNull
    public String getID() {
        if ("MethodOverloadsMethodOfSuperclass" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/MethodOverloadsParentMethodInspectionBase", "getID"));
        }
        return "MethodOverloadsMethodOfSuperclass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.overloads.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/MethodOverloadsParentMethodInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.overloads.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/MethodOverloadsParentMethodInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("method.overloads.report.incompatible.option", new Object[0]), (InspectionProfileEntry)this, "reportIncompatibleParameters");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodOverloadsParentMethodVisitor();
    }

    private class MethodOverloadsParentMethodVisitor
    extends BaseInspectionVisitor {
        private MethodOverloadsParentMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/visibility/MethodOverloadsParentMethodInspectionBase$MethodOverloadsParentMethodVisitor", "visitMethod"));
            }
            if (method2.hasModifierProperty("private") || method2.hasModifierProperty("static")) {
                return;
            }
            if (method2.getNameIdentifier() == null || method2.isConstructor()) {
                return;
            }
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (MethodUtils.hasSuper(method2)) {
                return;
            }
            HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>();
            this.processSupers(method2, aClass, aClass, visitedClasses);
        }

        private boolean processSupers(PsiMethod method2, PsiClass psiClass, PsiClass initialClass, Set<PsiClass> visitedClasses) {
            if (!visitedClasses.add(psiClass)) {
                return false;
            }
            if (initialClass != psiClass && this.methodOverloads(method2, psiClass)) {
                this.registerMethodError(method2, new Object[0]);
                return true;
            }
            if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)method2)) {
                for (PsiClass superClass : psiClass.getSupers()) {
                    if (!this.processSupers(method2, superClass, initialClass, visitedClasses)) continue;
                    return true;
                }
            } else {
                PsiClass superClass = psiClass.getSuperClass();
                if (superClass != null) {
                    return this.processSupers(method2, superClass, initialClass, visitedClasses);
                }
            }
            return false;
        }

        private boolean methodOverloads(PsiMethod method2, PsiClass ancestorClass) {
            PsiMethod[] methods;
            String methodName = method2.getName();
            PsiParameterList parameterList = method2.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            for (PsiMethod testMethod : methods = ancestorClass.findMethodsByName(methodName, false)) {
                PsiParameterList testParameterList;
                PsiParameter[] testParameters;
                if (testMethod.hasModifierProperty("private") || testMethod.hasModifierProperty("static") || testMethod.hasModifierProperty("abstract") || this.isOverriddenInClass(testMethod, method2.getContainingClass()) || (testParameters = (testParameterList = testMethod.getParameterList()).getParameters()).length != parameters.length || !MethodOverloadsParentMethodInspectionBase.this.reportIncompatibleParameters && !this.parametersAreCompatible(parameters, testParameters)) continue;
                return true;
            }
            return false;
        }

        private boolean isOverriddenInClass(PsiMethod method2, PsiClass aClass) {
            return aClass.findMethodsBySignature(method2, false).length > 0;
        }

        private boolean parametersAreCompatible(PsiParameter[] parameters, PsiParameter[] testParameters) {
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                PsiParameter testParameter;
                PsiType testParameterType;
                PsiParameter parameter = parameters[i2];
                PsiType parameterType = parameter.getType();
                if (parameterType.isAssignableFrom(testParameterType = (testParameter = testParameters[i2]).getType()) || testParameterType.isAssignableFrom(parameterType)) continue;
                return false;
            }
            return true;
        }
    }
}

