/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.chartostring;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.siyeh.ipp.base.PsiElementPredicate;

class StringToCharPredicate
implements PsiElementPredicate {
    StringToCharPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression expression = (PsiLiteralExpression)element;
        PsiType type = expression.getType();
        if (type == null) {
            return false;
        }
        String typeText = type.getCanonicalText();
        if (!"java.lang.String".equals(typeText)) {
            return false;
        }
        String value = (String)expression.getValue();
        if (value == null || value.length() != 1) {
            return false;
        }
        return StringToCharPredicate.isInConcatenationContext(element);
    }

    private static boolean isInConcatenationContext(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression parentExpression = (PsiPolyadicExpression)parent;
            PsiType parentType = parentExpression.getType();
            if (parentType == null) {
                return false;
            }
            String parentTypeText = parentType.getCanonicalText();
            if (!"java.lang.String".equals(parentTypeText)) {
                return false;
            }
            if (parentExpression.getOperationTokenType() != JavaTokenType.PLUS) {
                return false;
            }
            Object[] operands = parentExpression.getOperands();
            int index = ArrayUtil.indexOf((Object[])operands, (Object)element);
            if (index > 0) {
                for (int i2 = 0; i2 < index && i2 < operands.length; ++i2) {
                    PsiType type = operands[i2].getType();
                    if (type == null || !type.equalsToText("java.lang.String")) continue;
                    return true;
                }
            } else if (index == 0) {
                PsiType type = operands[index + 1].getType();
                return type != null && type.equalsToText("java.lang.String");
            }
            return false;
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression parentExpression = (PsiAssignmentExpression)parent;
            IElementType tokenType = parentExpression.getOperationTokenType();
            if (!JavaTokenType.PLUSEQ.equals(tokenType)) {
                return false;
            }
            PsiType parentType = parentExpression.getType();
            if (parentType == null) {
                return false;
            }
            String parentTypeText = parentType.getCanonicalText();
            return "java.lang.String".equals(parentTypeText);
        }
        if (parent instanceof PsiExpressionList) {
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            PsiType type = qualifierExpression == null ? methodExpression.getType() : qualifierExpression.getType();
            if (type == null) {
                return false;
            }
            String className = type.getCanonicalText();
            if ("java.lang.StringBuffer".equals(className) || "java.lang.StringBuilder".equals(className)) {
                String methodName = methodExpression.getReferenceName();
                if (!"append".equals(methodName) && !"insert".equals(methodName)) {
                    return false;
                }
                PsiElement method2 = methodExpression.resolve();
                return method2 != null;
            }
            if ("java.lang.String".equals(className)) {
                String methodName = methodExpression.getReferenceName();
                if (!("indexOf".equals(methodName) || "lastIndexOf".equals(methodName) || "replace".equals(methodName))) {
                    return false;
                }
                PsiElement method3 = methodExpression.resolve();
                return method3 != null;
            }
            return false;
        }
        return false;
    }
}

