/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.fqnames;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ig.style.UnnecessaryFullyQualifiedNameInspection;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.fqnames.FullyQualifiedNamePredicate;
import com.siyeh.ipp.psiutils.HighlightUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ReplaceFullyQualifiedNameWithImportIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        FullyQualifiedNamePredicate fullyQualifiedNamePredicate = new FullyQualifiedNamePredicate();
        if (fullyQualifiedNamePredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/fqnames/ReplaceFullyQualifiedNameWithImportIntention", "getElementPredicate"));
        }
        return fullyQualifiedNamePredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/fqnames/ReplaceFullyQualifiedNameWithImportIntention", "processIntention"));
        }
        PsiJavaCodeReferenceElement reference = (PsiJavaCodeReferenceElement)element;
        PsiElement target = reference.resolve();
        if (!(target instanceof PsiClass)) {
            PsiElement parent = reference.getParent();
            while (parent instanceof PsiJavaCodeReferenceElement && !((target = (reference = (PsiJavaCodeReferenceElement)parent).resolve()) instanceof PsiClass)) {
                parent = parent.getParent();
            }
        }
        if (!(target instanceof PsiClass)) {
            return;
        }
        PsiClass aClass = (PsiClass)target;
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        PsiJavaFile file2 = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiJavaFile.class);
        if (file2 == null) {
            return;
        }
        ImportUtils.addImportIfNeeded(aClass, (PsiElement)reference);
        String fullyQualifiedText = reference.getText();
        UnnecessaryFullyQualifiedNameInspection.QualificationRemover qualificationRemover = new UnnecessaryFullyQualifiedNameInspection.QualificationRemover(fullyQualifiedText);
        file2.accept((PsiElementVisitor)qualificationRemover);
        Collection<PsiElement> shortenedElements = qualificationRemover.getShortenedElements();
        int elementCount = shortenedElements.size();
        String text = elementCount == 1 ? IntentionPowerPackBundle.message("1.fully.qualified.name.status.bar.escape.highlighting.message", new Object[0]) : IntentionPowerPackBundle.message("multiple.fully.qualified.names.status.bar.escape.highlighting.message", elementCount);
        HighlightUtil.highlightElements(shortenedElements, text);
    }
}

