/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.Intention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConvertNumberIntentionBase
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        boolean negated;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/integer/ConvertNumberIntentionBase", "processIntention"));
        }
        PsiExpression expression = (PsiExpression)element;
        Number value = (Number)ExpressionUtils.computeConstantExpression(expression);
        if (value == null) {
            return;
        }
        PsiType type = expression.getType();
        String resultString = this.convertValue(value, type, negated = ExpressionUtils.isNegative(expression));
        if (resultString == null) {
            return;
        }
        if (negated) {
            PsiReplacementUtil.replaceExpression((PsiExpression)expression.getParent(), resultString);
        } else {
            PsiReplacementUtil.replaceExpression(expression, resultString);
        }
    }

    @Nullable
    protected abstract String convertValue(Number var1, PsiType var2, boolean var3);
}

