/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.intellij.images.editor.actions.SetBackgroundImageDialog;
import org.intellij.images.fileTypes.ImageFileTypeManager;

public class SetBackgroundImageAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        Project project2 = e.getProject();
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean image = file2 != null && ImageFileTypeManager.getInstance().isImage(file2);
        boolean visible = !ActionPlaces.isPopupPlace((String)e.getPlace()) || image;
        e.getPresentation().setEnabled(project2 != null);
        e.getPresentation().setVisible(visible);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean image = file2 != null && ImageFileTypeManager.getInstance().isImage(file2);
        SetBackgroundImageDialog dialog2 = new SetBackgroundImageDialog(project2, image ? file2.getPath() : null);
        dialog2.showAndGet();
    }
}

