/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.net.NetKt;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.NetService;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.io.NettyKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0014J\u001e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H$J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0004J4\u0010\u0018\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0004R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/builtInWebServer/SingleConnectionNetService;", "Lorg/jetbrains/builtInWebServer/NetService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "port", "", "processChannel", "Ljava/util/concurrent/atomic/AtomicReference;", "Lio/netty/channel/Channel;", "getProcessChannel", "()Ljava/util/concurrent/atomic/AtomicReference;", "addCloseListener", "", "it", "closeProcessConnections", "configureBootstrap", "errorOutputConsumer", "Lcom/intellij/util/Consumer;", "", "connectAgain", "Lorg/jetbrains/concurrency/Promise;", "connectToProcess", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/intellij/execution/process/OSProcessHandler;", "processHandler", "built-in-server"})
public abstract class SingleConnectionNetService
extends NetService {
    @NotNull
    private final AtomicReference<Channel> processChannel;
    private volatile int port;
    private volatile Bootstrap bootstrap;

    @NotNull
    protected final AtomicReference<Channel> getProcessChannel() {
        return this.processChannel;
    }

    protected abstract void configureBootstrap(@NotNull Bootstrap var1, @NotNull Consumer<String> var2);

    @Override
    protected final void connectToProcess(@NotNull AsyncPromise<OSProcessHandler> promise2, int port, @NotNull OSProcessHandler processHandler2, @NotNull Consumer<String> errorOutputConsumer) {
        block2: {
            Channel channel;
            Intrinsics.checkParameterIsNotNull(promise2, (String)"promise");
            Intrinsics.checkParameterIsNotNull((Object)processHandler2, (String)"processHandler");
            Intrinsics.checkParameterIsNotNull(errorOutputConsumer, (String)"errorOutputConsumer");
            Bootstrap bootstrap = NettyKt.oioClientBootstrap();
            this.configureBootstrap(bootstrap, errorOutputConsumer);
            this.bootstrap = bootstrap;
            this.port = port;
            Channel channel2 = com.intellij.util.io.NettyKt.connect$default(bootstrap, NetKt.loopbackSocketAddress(port), promise2, 0, null, 12, null);
            if (channel2 == null) break block2;
            Channel it = channel = channel2;
            AsyncPromise<OSProcessHandler> $receiver$iv = promise2;
            try {
                this.processChannel.set(it);
                this.addCloseListener(it);
                promise2.setResult((Object)processHandler2);
            }
            catch (Throwable e$iv) {
                $receiver$iv.setError(e$iv);
            }
        }
    }

    @NotNull
    protected final Promise<Channel> connectAgain() {
        AsyncPromise promise2;
        block4: {
            Channel channel;
            Channel channel2 = this.processChannel.get();
            if (channel2 != null) {
                return Promises.resolvedPromise((Object)channel2);
            }
            promise2 = new AsyncPromise();
            Bootstrap bootstrap = this.bootstrap;
            if (bootstrap == null) {
                Intrinsics.throwNpe();
            }
            Channel channel3 = com.intellij.util.io.NettyKt.connect$default(bootstrap, NetKt.loopbackSocketAddress(this.port), promise2, 0, null, 12, null);
            if (channel3 == null) break block4;
            Channel it = channel = channel3;
            AsyncPromise $receiver$iv = promise2;
            try {
                this.processChannel.set(it);
                this.addCloseListener(it);
                promise2.setResult((Object)it);
            }
            catch (Throwable e$iv) {
                $receiver$iv.setError(e$iv);
            }
        }
        return (Promise)promise2;
    }

    private final void addCloseListener(Channel it) {
        ChannelFuture $receiver$iv = it.closeFuture();
        $receiver$iv.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(this){
            final /* synthetic */ SingleConnectionNetService this$0;
            {
                this.this$0 = singleConnectionNetService;
            }

            public final void operationComplete(ChannelFuture it) {
                ChannelFuture channelFuture = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it");
                ChannelFuture it2 = channelFuture;
                Channel channel = it2.channel();
                this.this$0.getProcessChannel().compareAndSet(channel, null);
                com.intellij.util.io.NettyKt.shutdownIfOio(channel.eventLoop());
            }
        });
    }

    @Override
    protected void closeProcessConnections() {
        block0: {
            Channel channel;
            Channel channel2 = this.processChannel.getAndSet(null);
            if (channel2 == null) break block0;
            Channel it = channel = channel2;
            com.intellij.util.io.NettyKt.closeAndShutdownEventLoop(it);
        }
    }

    public SingleConnectionNetService(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2, null, 2, null);
        this.processChannel = new AtomicReference();
        this.port = -1;
    }
}

