/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.Url;
import com.intellij.util.UrlImpl;
import com.intellij.util.Urls;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a@\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\b\b\u0002\u0010\n\u001a\u00020\u0006\u001a;\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\fH\u0086\b\u001a\u001e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006\u001a*\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u0006\u001a&\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006\u00a8\u0006\u0012"}, d2={"SourceResolver", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "rawSources", "", "", "trimFileScheme", "", "baseUrl", "Lcom/intellij/util/Url;", "sourceContents", "baseUrlIsFile", "urlCanonicalizer", "Lkotlin/Function1;", "canonicalizePath", "url", "canonicalizeUrl", "doCanonicalize", "asLocalFileIfAbsoluteAndExists", "script-debugger-backend"})
public final class SourceResolverKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SourceResolver SourceResolver(@NotNull List<String> rawSources, @Nullable List<String> sourceContents, @NotNull Function1<? super String, ? extends Url> urlCanonicalizer) {
        Url[] urlArray;
        void size$iv;
        SourceResolver sourceResolver;
        Intrinsics.checkParameterIsNotNull(rawSources, (String)"rawSources");
        Intrinsics.checkParameterIsNotNull(urlCanonicalizer, (String)"urlCanonicalizer");
        int n = rawSources.size();
        List<String> list = rawSources;
        SourceResolver sourceResolver2 = sourceResolver;
        SourceResolver sourceResolver3 = sourceResolver;
        Url[] result$iv = new Url[size$iv];
        boolean bl = false;
        void var7_9 = size$iv - true;
        if (bl <= var7_9) {
            void i$iv;
            do {
                void it;
                Url url;
                void var8_10 = ++i$iv;
                void var15_12 = i$iv;
                urlArray = result$iv;
                urlArray[var15_12] = url = (Url)urlCanonicalizer.invoke((Object)rawSources.get((int)it));
            } while (i$iv != var7_9);
        }
        urlArray = result$iv;
        sourceResolver2(list, urlArray, sourceContents);
        return sourceResolver3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SourceResolver SourceResolver(@NotNull List<String> rawSources, boolean trimFileScheme, @Nullable Url baseUrl, @Nullable List<String> sourceContents, boolean baseUrlIsFile) {
        Url[] urlArray;
        void size$iv$iv;
        SourceResolver sourceResolver;
        Intrinsics.checkParameterIsNotNull(rawSources, (String)"rawSources");
        int n = rawSources.size();
        List<String> list = rawSources;
        SourceResolver sourceResolver2 = sourceResolver;
        SourceResolver sourceResolver3 = sourceResolver;
        Url[] result$iv$iv = new Url[size$iv$iv];
        boolean bl = false;
        void var11_11 = size$iv$iv - true;
        if (bl <= var11_11) {
            void i$iv$iv;
            do {
                Url url;
                void it$iv;
                void var12_12 = ++i$iv$iv;
                void var13_13 = i$iv$iv;
                urlArray = result$iv$iv;
                String it = rawSources.get((int)it$iv);
                urlArray[var13_13] = url = SourceResolverKt.canonicalizeUrl(it, baseUrl, trimFileScheme, baseUrlIsFile);
            } while (i$iv$iv != var11_11);
        }
        urlArray = result$iv$iv;
        sourceResolver2(list, urlArray, sourceContents);
        return sourceResolver3;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ SourceResolver SourceResolver$default(List list, boolean bl, Url url, List list2, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        return SourceResolverKt.SourceResolver(list, bl, url, list2, bl2);
    }

    @NotNull
    public static final String canonicalizePath(@NotNull String url, @NotNull Url baseUrl, boolean baseUrlIsFile) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        String path = url;
        if (!FileUtil.isAbsolute((String)url)) {
            String basePath = baseUrl.getPath();
            if (baseUrlIsFile) {
                int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)basePath, (char)'/', (int)0, (boolean)false, (int)6, null);
                StringBuilder pathBuilder = new StringBuilder();
                if (lastSlashIndex == -1) {
                    pathBuilder.append('/');
                } else {
                    pathBuilder.append(basePath, 0, lastSlashIndex + 1);
                }
                String string = pathBuilder.append(url).toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pathBuilder.append(url).toString()");
                path = string;
            } else {
                path = basePath + "/" + url;
            }
        }
        String string = FileUtil.toCanonicalPath((String)path, (char)'/');
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.toCanonicalPath(path, '/')");
        return string;
    }

    @NotNull
    public static final Url canonicalizeUrl(@NotNull String url, @Nullable Url baseUrl, boolean trimFileScheme, boolean baseUrlIsFile) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (trimFileScheme && StringsKt.startsWith$default((String)url, (String)"file://", (boolean)false, (int)2, null)) {
            String string = VfsUtilCore.toIdeaUrl((String)url, (boolean)true);
            int n = "file://".length();
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            Url url2 = Urls.newLocalFileUrl(FileUtil.toCanonicalPath((String)string3, (char)'/'));
            Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"Urls.newLocalFileUrl(Fil\u2026COL_PREFIX.length), '/'))");
            return url2;
        }
        if (baseUrl == null || StringsKt.contains$default((CharSequence)url, (CharSequence)"://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"data:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"blob:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"javascript:", (boolean)false, (int)2, null)) {
            Url url3 = Urls.parseEncoded(url);
            if (url3 == null) {
                url3 = new UrlImpl(url);
            }
            return url3;
        }
        return SourceResolverKt.doCanonicalize(url, baseUrl, baseUrlIsFile, true);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Url canonicalizeUrl$default(String string, Url url, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return SourceResolverKt.canonicalizeUrl(string, url, bl, bl2);
    }

    @NotNull
    public static final Url doCanonicalize(@NotNull String url, @NotNull Url baseUrl, boolean baseUrlIsFile, boolean asLocalFileIfAbsoluteAndExists) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        String path = SourceResolverKt.canonicalizePath(url, baseUrl, baseUrlIsFile);
        if (baseUrl.getScheme() == null && baseUrl.isInLocalFileSystem() || asLocalFileIfAbsoluteAndExists && SourceResolver.Companion.isAbsolute(path) && new File(path).exists()) {
            Url url2 = Urls.newLocalFileUrl(path);
            Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"Urls.newLocalFileUrl(path)");
            return url2;
        }
        return new UrlImpl(baseUrl.getScheme(), baseUrl.getAuthority(), path, null);
    }
}

