/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.FileResponsesKt;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ0\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/io/FileResponses;", "", "()V", "checkCache", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "channel", "Lio/netty/channel/Channel;", "lastModified", "", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "getContentType", "", "path", "prepareSend", "Lio/netty/handler/codec/http/HttpResponse;", "filename", "sendFile", "", "file", "Ljava/nio/file/Path;", "platform-impl"})
public final class FileResponses {
    public static final FileResponses INSTANCE;

    @NotNull
    public final String getContentType(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String string = FileResponsesKt.access$getFILE_MIMETYPE_MAP$p().getContentType(path);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FILE_MIMETYPE_MAP.getContentType(path)");
        return string;
    }

    private final boolean checkCache(HttpRequest request, Channel channel, long lastModified, HttpHeaders extraHeaders) {
        Long ifModified = request.headers().getTimeMillis((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE);
        if (ifModified != null && Intrinsics.compare((long)ifModified, (long)lastModified) >= 0) {
            Responses.send$default(HttpResponseStatus.NOT_MODIFIED, channel, request, null, extraHeaders, 4, null);
            return true;
        }
        return false;
    }

    @Nullable
    public final HttpResponse prepareSend(@NotNull HttpRequest request, @NotNull Channel channel, long lastModified, @NotNull String filename, @NotNull HttpHeaders extraHeaders) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        Intrinsics.checkParameterIsNotNull((Object)extraHeaders, (String)"extraHeaders");
        if (this.checkCache(request, channel, lastModified, extraHeaders)) {
            return null;
        }
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)this.getContentType(filename));
        Responses.addCommonHeaders((HttpResponse)response);
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"private, must-revalidate");
        response.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)new Date(lastModified));
        response.headers().add(extraHeaders);
        return (HttpResponse)response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendFile(@NotNull HttpRequest request, @NotNull Channel channel, @NotNull Path file2, @NotNull HttpHeaders extraHeaders) {
        RandomAccessFile raf;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)extraHeaders, (String)"extraHeaders");
        HttpResponse httpResponse = this.prepareSend(request, channel, Files.getLastModifiedTime(file2, new LinkOption[0]).toMillis(), ((Object)file2.getFileName()).toString(), extraHeaders);
        if (httpResponse == null) {
            return;
        }
        HttpResponse response = httpResponse;
        boolean keepAlive = Responses.addKeepAliveIfNeed(response, request);
        boolean fileWillBeClosed = false;
        try {
            raf = new RandomAccessFile(file2.toFile(), "r");
        }
        catch (FileNotFoundException ignored) {
            Responses.send$default(HttpResponseStatus.NOT_FOUND, channel, request, null, null, 12, null);
            return;
        }
        try {
            long fileLength = raf.length();
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)fileLength);
            channel.write((Object)response);
            if (request.method() != HttpMethod.HEAD) {
                if (channel.pipeline().get(SslHandler.class) == null) {
                    channel.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength));
                } else {
                    channel.write((Object)new ChunkedFile(raf));
                }
            }
            fileWillBeClosed = true;
        }
        finally {
            if (!fileWillBeClosed) {
                raf.close();
            }
        }
        ChannelFuture future2 = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!keepAlive) {
            future2.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public static /* bridge */ /* synthetic */ void sendFile$default(FileResponses fileResponses, HttpRequest httpRequest, Channel channel, Path path, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 8) != 0) {
            EmptyHttpHeaders emptyHttpHeaders = EmptyHttpHeaders.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)emptyHttpHeaders, (String)"EmptyHttpHeaders.INSTANCE");
            httpHeaders = (HttpHeaders)emptyHttpHeaders;
        }
        fileResponses.sendFile(httpRequest, channel, path, httpHeaders);
    }

    private FileResponses() {
        INSTANCE = this;
    }

    static {
        new FileResponses();
    }
}

