/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.config;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.config.InsertAtCaretStrategy;
import org.jetbrains.java.generate.config.InsertNewMethodStrategy;
import org.jetbrains.java.generate.psi.PsiAdapter;

public class InsertAfterEqualsHashCodeStrategy
implements InsertNewMethodStrategy {
    private static final InsertAfterEqualsHashCodeStrategy instance = new InsertAfterEqualsHashCodeStrategy();

    private InsertAfterEqualsHashCodeStrategy() {
    }

    public static InsertAfterEqualsHashCodeStrategy getInstance() {
        return instance;
    }

    @Override
    public PsiMethod insertNewMethod(PsiClass clazz, @NotNull PsiMethod newMethod, Editor editor) {
        if (newMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMethod", "org/jetbrains/java/generate/config/InsertAfterEqualsHashCodeStrategy", "insertNewMethod"));
        }
        PsiMethod methodHashCode = PsiAdapter.findHashCodeMethod(clazz);
        PsiMethod methodEquals = PsiAdapter.findEqualsMethod(clazz);
        PsiMethod method2 = methodEquals != null && methodHashCode != null ? (methodEquals.getTextOffset() > methodHashCode.getTextOffset() ? methodEquals : methodHashCode) : (methodHashCode != null ? methodHashCode : methodEquals);
        newMethod = method2 != null ? (PsiMethod)clazz.addAfter((PsiElement)newMethod, (PsiElement)method2) : InsertAtCaretStrategy.getInstance().insertNewMethod(clazz, newMethod, editor);
        return newMethod;
    }

    public String toString() {
        return "After equals/hashCode";
    }
}

