/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.element;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.java.generate.element.AbstractElement;
import org.jetbrains.java.generate.element.Element;
import org.jetbrains.java.generate.element.ElementFactory;
import org.jetbrains.java.generate.element.FieldElement;
import org.jetbrains.java.generate.element.MethodElement;

public class ElementUtils {
    private ElementUtils() {
    }

    public static List<FieldElement> getOnlyAsFieldElements(Collection<? extends PsiMember> members, Collection<? extends PsiMember> selectedNotNullMembers, boolean useAccessors) {
        ArrayList<FieldElement> fieldElementList = new ArrayList<FieldElement>();
        for (PsiMember psiMember : members) {
            if (!(psiMember instanceof PsiField)) continue;
            PsiField field = (PsiField)psiMember;
            FieldElement fe = ElementFactory.newFieldElement(field, useAccessors);
            if (selectedNotNullMembers.contains(psiMember)) {
                fe.setNotNull(true);
            }
            fieldElementList.add(fe);
        }
        return fieldElementList;
    }

    public static List<MethodElement> getOnlyAsMethodElements(Collection<? extends PsiMember> members) {
        ArrayList<MethodElement> methodElementList = new ArrayList<MethodElement>();
        for (PsiMember psiMember : members) {
            if (!(psiMember instanceof PsiMethod)) continue;
            PsiMethod method2 = (PsiMethod)psiMember;
            MethodElement me = ElementFactory.newMethodElement(method2);
            methodElementList.add(me);
        }
        return methodElementList;
    }

    public static List<Element> getOnlyAsFieldAndMethodElements(Collection<? extends PsiMember> members, Collection<? extends PsiMember> selectedNotNullMembers, boolean useAccessors) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        for (PsiMember psiMember : members) {
            AbstractElement element = null;
            if (psiMember instanceof PsiField) {
                element = ElementFactory.newFieldElement((PsiField)psiMember, useAccessors);
            } else if (psiMember instanceof PsiMethod) {
                element = ElementFactory.newMethodElement((PsiMethod)psiMember);
            }
            if (element == null) continue;
            if (selectedNotNullMembers.contains(psiMember)) {
                element.setNotNull(true);
            }
            elementList.add(element);
        }
        return elementList;
    }
}

