/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jsonProtocol;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.JsonReaders;
import org.jetbrains.jsonProtocol.ObjectFactory;

final class MapFactory<T>
extends ObjectFactory<Map<String, T>> {
    private final ObjectFactory<T> valueFactory;

    public MapFactory(@NotNull ObjectFactory<T> valueFactory) {
        if (valueFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueFactory", "org/jetbrains/jsonProtocol/MapFactory", "<init>"));
        }
        this.valueFactory = valueFactory;
    }

    @Override
    public Map<String, T> read(JsonReaderEx reader) {
        return JsonReaders.readMap(reader, this.valueFactory);
    }
}

