/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URL;
import java.util.StringTokenizer;
import org.apache.xmlrpc.ServerInputStream;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcTransport;
import org.apache.xmlrpc.util.HttpUtil;

class LiteXmlRpcTransport
implements XmlRpcTransport {
    String hostname;
    String host;
    protected String auth = null;
    int port;
    String uri;
    Socket socket = null;
    BufferedOutputStream output;
    BufferedInputStream input;
    boolean keepalive;
    byte[] buffer;

    public LiteXmlRpcTransport(URL uRL) {
        this.hostname = uRL.getHost();
        this.port = uRL.getPort();
        if (this.port < 1) {
            this.port = 80;
        }
        this.uri = uRL.getFile();
        if (this.uri == null || "".equals(this.uri)) {
            this.uri = "/";
        }
        this.host = this.port == 80 ? this.hostname : this.hostname + ":" + this.port;
    }

    @Override
    public InputStream sendXmlRpc(byte[] byArray) throws IOException {
        try {
            if (this.socket == null) {
                this.initConnection();
            }
            InputStream inputStream = null;
            try {
                inputStream = this.sendRequest(byArray);
            }
            catch (IOException iOException) {
                if (this.keepalive) {
                    this.closeConnection();
                    this.initConnection();
                    inputStream = this.sendRequest(byArray);
                }
                throw iOException;
            }
            return inputStream;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            String string;
            if (XmlRpc.debug) {
                exception.printStackTrace();
            }
            if ((string = exception.getMessage()) == null || string.length() == 0) {
                string = exception.toString();
            }
            throw new IOException(string);
        }
    }

    protected void initConnection() throws IOException {
        int n = 0;
        this.socket = null;
        while (this.socket == null) {
            try {
                this.socket = new Socket(this.hostname, this.port);
            }
            catch (ConnectException connectException) {
                if (n >= 3) {
                    throw connectException;
                }
                ++n;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.output = new BufferedOutputStream(this.socket.getOutputStream());
        this.input = new BufferedInputStream(this.socket.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection() {
        try {
            this.socket.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.socket = null;
        }
    }

    public InputStream sendRequest(byte[] byArray) throws IOException {
        this.output.write(("POST " + this.uri + " HTTP/1.0\r\n").getBytes());
        this.output.write("User-Agent: Apache XML-RPC 2.0\r\n".getBytes());
        this.output.write(("Host: " + this.host + "\r\n").getBytes());
        if (XmlRpc.getKeepAlive()) {
            this.output.write("Connection: Keep-Alive\r\n".getBytes());
        }
        this.output.write("Content-Type: text/xml\r\n".getBytes());
        if (this.auth != null) {
            this.output.write(("Authorization: Basic " + this.auth + "\r\n").getBytes());
        }
        this.output.write(("Content-Length: " + byArray.length).getBytes());
        this.output.write("\r\n\r\n".getBytes());
        this.output.write(byArray);
        this.output.flush();
        String string = this.readLine();
        if (XmlRpc.debug) {
            System.out.println(string);
        }
        int n = -1;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken("\n\r");
            boolean bl = this.keepalive = XmlRpc.getKeepAlive() && "HTTP/1.1".equals(string2);
            if (!"200".equals(string3)) {
                throw new IOException("Unexpected Response from Server: " + string4);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Server returned invalid Response.");
        }
        do {
            if ((string = this.readLine()) == null) continue;
            if (XmlRpc.debug) {
                System.out.println(string);
            }
            if ((string = string.toLowerCase()).startsWith("content-length:")) {
                n = Integer.parseInt(string.substring(15).trim());
            }
            if (!string.startsWith("connection:")) continue;
            boolean bl = this.keepalive = XmlRpc.getKeepAlive() && string.indexOf("keep-alive") > -1;
        } while (string != null && !string.equals(""));
        return new ServerInputStream(this.input, n);
    }

    public void setBasicAuthentication(String string, String string2) {
        this.auth = HttpUtil.encodeBasicAuthentication(string, string2);
    }

    @Override
    public void endClientRequest() {
        if (!this.keepalive) {
            this.closeConnection();
        }
    }

    private String readLine() throws IOException {
        int n;
        if (this.buffer == null) {
            this.buffer = new byte[2048];
        }
        int n2 = 0;
        while ((n = this.input.read()) >= 0 && n != 10) {
            if (n != 13) {
                this.buffer[n2++] = (byte)n;
            }
            if (n2 < this.buffer.length) continue;
            throw new IOException("HTTP Header too long");
        }
        return new String(this.buffer, 0, n2);
    }

    protected void finalize() throws Throwable {
        this.closeConnection();
    }
}

