/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.listeners;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

class MutableTestExecutionSummary
implements TestExecutionSummary {
    private static final String TAB = "  ";
    private static final String DOUBLE_TAB = "    ";
    final AtomicLong containersFound = new AtomicLong();
    final AtomicLong containersStarted = new AtomicLong();
    final AtomicLong containersSkipped = new AtomicLong();
    final AtomicLong containersAborted = new AtomicLong();
    final AtomicLong containersSucceeded = new AtomicLong();
    final AtomicLong containersFailed = new AtomicLong();
    final AtomicLong testsFound = new AtomicLong();
    final AtomicLong testsStarted = new AtomicLong();
    final AtomicLong testsSkipped = new AtomicLong();
    final AtomicLong testsAborted = new AtomicLong();
    final AtomicLong testsSucceeded = new AtomicLong();
    final AtomicLong testsFailed = new AtomicLong();
    private final TestPlan testPlan;
    private final List<TestExecutionSummary.Failure> failures = new ArrayList<TestExecutionSummary.Failure>();
    private final long timeStarted;
    long timeFinished;

    MutableTestExecutionSummary(TestPlan testPlan) {
        this.testPlan = testPlan;
        this.containersFound.set(testPlan.countTestIdentifiers(TestIdentifier::isContainer));
        this.testsFound.set(testPlan.countTestIdentifiers(TestIdentifier::isTest));
        this.timeStarted = System.currentTimeMillis();
    }

    void addFailure(TestIdentifier testIdentifier, Throwable throwable) {
        this.failures.add(new DefaultFailure(testIdentifier, throwable));
    }

    @Override
    public long getTimeStarted() {
        return this.timeStarted;
    }

    @Override
    public long getTimeFinished() {
        return this.timeFinished;
    }

    @Override
    public long getTotalFailureCount() {
        return this.getTestsFailedCount() + this.getContainersFailedCount();
    }

    @Override
    public long getContainersFoundCount() {
        return this.containersFound.get();
    }

    @Override
    public long getContainersStartedCount() {
        return this.containersStarted.get();
    }

    @Override
    public long getContainersSkippedCount() {
        return this.containersSkipped.get();
    }

    @Override
    public long getContainersAbortedCount() {
        return this.containersAborted.get();
    }

    @Override
    public long getContainersSucceededCount() {
        return this.containersSucceeded.get();
    }

    @Override
    public long getContainersFailedCount() {
        return this.containersFailed.get();
    }

    @Override
    public long getTestsFoundCount() {
        return this.testsFound.get();
    }

    @Override
    public long getTestsStartedCount() {
        return this.testsStarted.get();
    }

    @Override
    public long getTestsSkippedCount() {
        return this.testsSkipped.get();
    }

    @Override
    public long getTestsAbortedCount() {
        return this.testsAborted.get();
    }

    @Override
    public long getTestsSucceededCount() {
        return this.testsSucceeded.get();
    }

    @Override
    public long getTestsFailedCount() {
        return this.testsFailed.get();
    }

    @Override
    public void printTo(PrintWriter writer) {
        writer.println(String.format("%nTest run finished after %d ms%n[%10d containers found      ]%n[%10d containers skipped    ]%n[%10d containers started    ]%n[%10d containers aborted    ]%n[%10d containers successful ]%n[%10d containers failed     ]%n[%10d tests found           ]%n[%10d tests skipped         ]%n[%10d tests started         ]%n[%10d tests aborted         ]%n[%10d tests successful      ]%n[%10d tests failed          ]%n", this.timeFinished - this.timeStarted, this.getContainersFoundCount(), this.getContainersSkippedCount(), this.getContainersStartedCount(), this.getContainersAbortedCount(), this.getContainersSucceededCount(), this.getContainersFailedCount(), this.getTestsFoundCount(), this.getTestsSkippedCount(), this.getTestsStartedCount(), this.getTestsAbortedCount(), this.getTestsSucceededCount(), this.getTestsFailedCount()));
        writer.flush();
    }

    @Override
    public void printFailuresTo(PrintWriter writer) {
        if (this.getTotalFailureCount() > 0L) {
            writer.println();
            writer.println(String.format("Failures (%d):", this.getTotalFailureCount()));
            this.failures.forEach(failure -> {
                writer.println(TAB + this.describeTest(failure.getTestIdentifier()));
                failure.getTestIdentifier().getSource().ifPresent(source -> writer.println(DOUBLE_TAB + source));
                writer.println(String.format("%s=> %s", DOUBLE_TAB, failure.getException()));
            });
            writer.flush();
        }
    }

    @Override
    public List<TestExecutionSummary.Failure> getFailures() {
        return Collections.unmodifiableList(this.failures);
    }

    private String describeTest(TestIdentifier testIdentifier) {
        ArrayList<String> descriptionParts = new ArrayList<String>();
        this.collectTestDescription(Optional.of(testIdentifier), descriptionParts);
        return descriptionParts.stream().collect(Collectors.joining(":"));
    }

    private void collectTestDescription(Optional<TestIdentifier> optionalIdentifier, List<String> descriptionParts) {
        optionalIdentifier.ifPresent(testIdentifier -> {
            descriptionParts.add(0, testIdentifier.getDisplayName());
            this.collectTestDescription(this.testPlan.getParent((TestIdentifier)testIdentifier), descriptionParts);
        });
    }

    private static class DefaultFailure
    implements TestExecutionSummary.Failure {
        private final TestIdentifier testIdentifier;
        private final Throwable exception;

        DefaultFailure(TestIdentifier testIdentifier, Throwable exception) {
            this.testIdentifier = testIdentifier;
            this.exception = exception;
        }

        @Override
        public TestIdentifier getTestIdentifier() {
            return this.testIdentifier;
        }

        @Override
        public Throwable getException() {
            return this.exception;
        }
    }
}

