/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.rt.execution.junit.ComparisonFailureData;
import com.intellij.rt.execution.testFrameworks.AbstractExpectedPatterns;
import java.util.ArrayList;
import java.util.List;

public class ExpectedPatterns
extends AbstractExpectedPatterns {
    private static final List PATTERNS = new ArrayList();
    private static final String[] PATTERN_STRINGS = new String[]{"\nexpected: is \"(.*)\"\n\\s*got: \"(.*)\"\n", "\nexpected: is \"(.*)\"\n\\s*but: was \"(.*)\"", "\nexpected: (.*)\n\\s*got: (.*)", ".*?\\s*expected same:<(.*)> was not:<(.*)>", ".*?\\s*expected:<(.*?)> but was:<(.*?)>", "\nexpected: \"(.*)\"\n\\s*but: was \"(.*)\"", "\\s*expected: (.*)\\s*but: was (.*)", ".*?\\s*expected: (.*)\\s*but was: (.*)"};
    private static final String MESSAGE_LENGTH_FOR_PATTERN_MATCHING = "idea.junit.message.length.threshold";
    private static final String JUNIT_FRAMEWORK_COMPARISON_NAME = (class$junit$framework$ComparisonFailure == null ? (class$junit$framework$ComparisonFailure = ExpectedPatterns.class$("junit.framework.ComparisonFailure")) : class$junit$framework$ComparisonFailure).getName();
    private static final String ORG_JUNIT_COMPARISON_NAME = "org.junit.ComparisonFailure";
    static /* synthetic */ Class class$junit$framework$ComparisonFailure;

    public static ComparisonFailureData createExceptionNotification(String message) {
        return ExpectedPatterns.createExceptionNotification((String)message, (List)PATTERNS);
    }

    public static ComparisonFailureData createExceptionNotification(Throwable assertion) {
        if (ExpectedPatterns.isComparisonFailure(assertion)) {
            return ComparisonFailureData.create((Throwable)assertion);
        }
        try {
            Throwable cause = assertion.getCause();
            if (ExpectedPatterns.isComparisonFailure(cause)) {
                return ComparisonFailureData.create((Throwable)cause);
            }
        }
        catch (Throwable cause) {
            // empty catch block
        }
        String message = assertion.getMessage();
        if (message != null && ExpectedPatterns.acceptedByThreshold(message.length())) {
            try {
                return ExpectedPatterns.createExceptionNotification(message);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isComparisonFailure(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        return ExpectedPatterns.isComparisonFailure(throwable.getClass());
    }

    private static boolean isComparisonFailure(Class aClass) {
        if (aClass == null) {
            return false;
        }
        String throwableClassName = aClass.getName();
        if (throwableClassName.equals(JUNIT_FRAMEWORK_COMPARISON_NAME) || throwableClassName.equals(ORG_JUNIT_COMPARISON_NAME)) {
            return true;
        }
        return ExpectedPatterns.isComparisonFailure(aClass.getSuperclass());
    }

    private static boolean acceptedByThreshold(int messageLength) {
        int threshold = 10000;
        try {
            String property = System.getProperty(MESSAGE_LENGTH_FOR_PATTERN_MATCHING);
            if (property != null) {
                try {
                    threshold = Integer.parseInt(property);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return messageLength < threshold;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ExpectedPatterns.registerPatterns((String[])PATTERN_STRINGS, (List)PATTERNS);
    }
}

