/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2;

import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2.GridSnapshotItem;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.util.GridBounds;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class GridSnapshot {
    private final Map<FXOMObject, GridSnapshotItem> items = new HashMap<FXOMObject, GridSnapshotItem>();

    public GridSnapshot(Collection<FXOMObject> fxomObjects) {
        assert (fxomObjects != null);
        assert (!fxomObjects.isEmpty());
        for (FXOMObject fxomObject : fxomObjects) {
            assert (!this.items.containsKey(fxomObject));
            this.items.put(fxomObject, new GridSnapshotItem(fxomObject));
        }
    }

    public GridSnapshot(Collection<FXOMObject> fxomObjects, int columnCount) {
        assert (fxomObjects != null);
        assert (!fxomObjects.isEmpty());
        assert (columnCount >= 1);
        int columnIndex = 0;
        int rowIndex = 0;
        for (FXOMObject fxomObject : fxomObjects) {
            this.items.put(fxomObject, new GridSnapshotItem(fxomObject, columnIndex, rowIndex));
            if (++columnIndex < columnCount) continue;
            columnIndex = 0;
            ++rowIndex;
        }
    }

    public int getColumnIndex(FXOMObject fxomObject) {
        assert (fxomObject != null);
        assert (this.items.containsKey(fxomObject));
        return this.items.get(fxomObject).getColumnIndex();
    }

    public int getRowIndex(FXOMObject fxomObject) {
        assert (fxomObject != null);
        assert (this.items.containsKey(fxomObject));
        return this.items.get(fxomObject).getRowIndex();
    }

    public GridBounds getBounds() {
        GridBounds result = null;
        for (Map.Entry<FXOMObject, GridSnapshotItem> e : this.items.entrySet()) {
            if (result == null) {
                result = e.getValue().getBounds();
                continue;
            }
            result = result.union(e.getValue().getBounds());
        }
        assert (result != null);
        return result;
    }
}

