/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.util.Set;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.HBox;

public class BooleanEditor
extends PropertyEditor {
    private final CheckBox checkBox = new CheckBox();
    private final HBox activeZone;

    public BooleanEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
        this.checkBox.disableProperty().bind((ObservableValue)this.disableProperty());
        EventHandler onActionListener = event -> this.userUpdateValueProperty(this.getValue());
        this.checkBox.setOnAction(onActionListener);
        this.setCommitListener(onActionListener);
        this.activeZone = new HBox();
        this.activeZone.setAlignment(Pos.CENTER_LEFT);
        EditorUtils.makeWidthStretchable((Node)this.activeZone);
        this.activeZone.getChildren().add((Object)this.checkBox);
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.activeZone);
    }

    @Override
    public Object getValue() {
        return this.checkBox.isSelected();
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        assert (value instanceof Boolean);
        this.checkBox.setSelected(((Boolean)value).booleanValue());
    }

    @Override
    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super.reset(propMeta, selectedClasses);
        this.checkBox.setIndeterminate(false);
    }

    @Override
    protected void valueIsIndeterminate() {
        BooleanEditor.handleIndeterminate((Node)this.checkBox);
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(() -> this.checkBox.requestFocus());
    }
}

