/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven;

import com.oracle.javafx.scenebuilder.app.AppPlatform;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.preset.MavenPresets;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.repository.Repository;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.version.Version;

public class MavenRepositorySystem {
    private RepositorySystem system;
    private DefaultRepositorySystemSession session;
    private LocalRepository localRepo;
    private VersionRangeResult rangeResult;
    private final boolean onlyReleases;
    private BasicRepositoryConnectorFactory basicRepositoryConnectorFactory;

    public MavenRepositorySystem(boolean onlyReleases) {
        this.onlyReleases = onlyReleases;
        this.initRepositorySystem();
    }

    private void initRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                throw new RuntimeException(I18N.getString((String)"maven.dialog.creation.failed"), exception);
            }
        });
        this.basicRepositoryConnectorFactory = new BasicRepositoryConnectorFactory();
        this.basicRepositoryConnectorFactory.initService((ServiceLocator)locator);
        this.system = (RepositorySystem)locator.getService(RepositorySystem.class);
        this.session = MavenRepositorySystemUtils.newSession();
        this.localRepo = new LocalRepository(new File(AppPlatform.getUserM2Repository()));
        this.session.setLocalRepositoryManager(this.system.newLocalRepositoryManager((RepositorySystemSession)this.session, this.localRepo));
        this.session.setTransferListener((TransferListener)new AbstractTransferListener(){

            public void transferSucceeded(TransferEvent event) {
            }

            public void transferFailed(TransferEvent event) {
            }
        });
        this.session.setRepositoryListener((RepositoryListener)new AbstractRepositoryListener(){

            public void artifactResolved(RepositoryEvent event) {
            }
        });
    }

    public RepositorySystem getRepositorySystem() {
        return this.system;
    }

    public DefaultRepositorySystemSession getRepositorySession() {
        return this.session;
    }

    public List<RemoteRepository> getRepositories() {
        List<RemoteRepository> list = MavenPresets.getPresetRepositories().stream().filter(r -> !this.onlyReleases || this.onlyReleases && !r.getId().toUpperCase(Locale.ROOT).contains("SNAPSHOT")).map(this::createRepository).collect(Collectors.toList());
        list.addAll(PreferencesController.getSingleton().getRepositoryPreferences().getRepositories().stream().filter(r -> !this.onlyReleases || this.onlyReleases && !r.getId().toUpperCase(Locale.ROOT).contains("SNAPSHOT")).map(this::createRepository).collect(Collectors.toList()));
        return list;
    }

    public RemoteRepository getRemoteRepository(Version version) {
        if (this.rangeResult == null || version == null) {
            return null;
        }
        return this.getRepositories().stream().filter(r -> r.getId().equals(this.rangeResult.getRepository(version).getId())).findFirst().orElse(new RemoteRepository.Builder("Local", "default", this.session.getLocalRepository().getBasedir().getAbsolutePath()).build());
    }

    public RemoteRepository getRemoteRepository(String name) {
        return this.getRepositories().stream().filter(r -> r.getId().equals(name)).findFirst().orElse(new RemoteRepository.Builder("Local", "default", this.session.getLocalRepository().getBasedir().getAbsolutePath()).build());
    }

    public List<Version> findVersions(Artifact artifact) {
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(artifact);
        rangeRequest.setRepositories(this.getRepositories());
        try {
            this.rangeResult = this.system.resolveVersionRange((RepositorySystemSession)this.session, rangeRequest);
            this.cleanMetadata(artifact);
            return this.rangeResult.getVersions();
        }
        catch (VersionRangeResolutionException versionRangeResolutionException) {
            return new ArrayList<Version>();
        }
    }

    public Version findLatestVersion(Artifact artifact) {
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(artifact);
        rangeRequest.setRepositories(this.getRepositories());
        try {
            this.rangeResult = this.system.resolveVersionRange((RepositorySystemSession)this.session, rangeRequest);
            this.cleanMetadata(artifact);
            return this.rangeResult.getVersions().stream().filter(v -> !v.toString().toLowerCase(Locale.ROOT).contains("snapshot")).sorted((v1, v2) -> v2.compareTo(v1)).findFirst().orElse(null);
        }
        catch (VersionRangeResolutionException versionRangeResolutionException) {
            return null;
        }
    }

    private void cleanMetadata(Artifact artifact) {
        String path = this.localRepo.getBasedir().getAbsolutePath() + File.separator + artifact.getGroupId().replaceAll("\\.", Matcher.quoteReplacement(File.separator)) + File.separator + artifact.getArtifactId() + File.separator;
        DefaultMetadata metadata = new DefaultMetadata("maven-metadata.xml", Metadata.Nature.RELEASE);
        this.getRepositories().stream().map(r -> this.session.getLocalRepositoryManager().getPathForRemoteMetadata((Metadata)metadata, r, "")).forEach(s -> {
            File file = new File(path + s);
            if (file.exists()) {
                try {
                    Files.delete(file.toPath());
                    Files.delete(new File(path + s + ".sha1").toPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public String resolveArtifacts(RemoteRepository remoteRepository, Artifact ... artifact) {
        LocalRepository localTmpRepo = new LocalRepository(AppPlatform.getTempM2Repository());
        this.session.setLocalRepositoryManager(this.system.newLocalRepositoryManager((RepositorySystemSession)this.session, localTmpRepo));
        List artifacts = Stream.of(artifact).map(a -> {
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact(a);
            artifactRequest.setRepositories(remoteRepository == null ? this.getRepositories() : Arrays.asList(remoteRepository));
            return artifactRequest;
        }).map(ar -> {
            try {
                ArtifactResult result = this.system.resolveArtifact((RepositorySystemSession)this.session, ar);
                return result.getArtifact();
            }
            catch (ArtifactResolutionException artifactResolutionException) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        this.session.setLocalRepositoryManager(this.system.newLocalRepositoryManager((RepositorySystemSession)this.session, this.localRepo));
        List sha1Files = null;
        if (artifacts != null && !artifacts.isEmpty()) {
            sha1Files = artifacts.stream().filter(a -> a.getFile() != null).map(a -> new File(a.getFile().getAbsolutePath().concat(".sha1"))).collect(Collectors.toList());
            InstallRequest installRequest = new InstallRequest();
            installRequest.setArtifacts(artifacts);
            try {
                this.system.install((RepositorySystemSession)this.session, installRequest);
            }
            catch (InstallationException installationException) {
                // empty catch block
            }
        }
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(artifact[0]);
        String absolutePath = "";
        try {
            File jarFile = this.system.resolveArtifact((RepositorySystemSession)this.session, artifactRequest).getArtifact().getFile();
            absolutePath = jarFile.getAbsolutePath();
            if (sha1Files != null) {
                sha1Files.stream().forEach(f -> {
                    try {
                        FileUtils.copyFile((File)f, (File)new File(jarFile.getParent() + File.separator + f.getName()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
        }
        catch (ArtifactResolutionException artifactResolutionException) {
            // empty catch block
        }
        try {
            FileUtils.deleteDirectory((String)AppPlatform.getTempM2Repository());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return absolutePath;
    }

    public String resolveDependencies(RemoteRepository remoteRepository, Artifact artifact) {
        DependencyFilter classpathFlter = DependencyFilterUtils.classpathFilter((String[])new String[]{"compile"});
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(artifact, "compile"));
        collectRequest.setRepositories(remoteRepository == null ? this.getRepositories() : Arrays.asList(remoteRepository));
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, classpathFlter);
        try {
            List artifactResults = this.system.resolveDependencies((RepositorySystemSession)this.session, dependencyRequest).getArtifactResults();
            return artifactResults.stream().skip(1L).map(a -> a.getArtifact().getFile().getAbsolutePath()).collect(Collectors.joining(":"));
        }
        catch (DependencyResolutionException dependencyResolutionException) {
            return "";
        }
    }

    private RemoteRepository createRepository(Repository repository) {
        Authentication auth = null;
        if (repository.getUser() != null && !repository.getUser().isEmpty() && repository.getPassword() != null && !repository.getPassword().isEmpty()) {
            auth = new AuthenticationBuilder().addUsername(repository.getUser()).addPassword(repository.getPassword()).build();
        }
        RemoteRepository repo = new RemoteRepository.Builder(repository.getId(), repository.getType(), repository.getURL()).setSnapshotPolicy(this.onlyReleases ? new RepositoryPolicy(false, null, null) : new RepositoryPolicy()).setAuthentication(auth).build();
        return repo;
    }

    public String validateRepository(Repository repository) {
        block2: {
            RemoteRepository remoteRepository = this.createRepository(repository);
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact((Artifact)new DefaultArtifact("test:test:1.0"));
            artifactRequest.setRepositories(Arrays.asList(remoteRepository));
            try {
                this.system.resolveArtifact((RepositorySystemSession)this.session, artifactRequest);
            }
            catch (ArtifactResolutionException ex) {
                String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
                if (rootCauseMessage == null || rootCauseMessage.contains("ArtifactNotFoundException")) break block2;
                return rootCauseMessage;
            }
        }
        return "";
    }
}

