/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.list.ColumnConstraintsListPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.list.RowConstraintsListPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import java.util.List;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.GridPane;

class FXOMNormalizer {
    private static final PropertyName expandedPaneName = new PropertyName("expandedPane");
    private final FXOMDocument fxomDocument;
    private int changeCount;
    private static final ColumnConstraintsListPropertyMetadata columnConstraintsMeta = new ColumnConstraintsListPropertyMetadata();
    private static final RowConstraintsListPropertyMetadata rowConstraintsMeta = new RowConstraintsListPropertyMetadata();

    public FXOMNormalizer(FXOMDocument fxomDocument) {
        this.fxomDocument = fxomDocument;
    }

    public void normalize() {
        this.changeCount = 0;
        this.normalizeExpandedPaneProperties();
        this.normalizeGridPanes();
        if (this.changeCount >= 1) {
            this.fxomDocument.refreshSceneGraph();
        }
    }

    public void normalizeExpandedPaneProperties() {
        List<FXOMProperty> expandedPaneProperties = this.fxomDocument.getFxomRoot().collectProperties(expandedPaneName);
        for (FXOMProperty p : expandedPaneProperties) {
            if (p instanceof FXOMPropertyC) {
                FXOMPropertyC pc = (FXOMPropertyC)p;
                assert (!pc.getValues().isEmpty());
                FXOMObject v0 = pc.getValues().get(0);
                if (v0 instanceof FXOMInstance) {
                    this.normalizeExpandedPaneProperty(pc);
                } else {
                    assert (v0 instanceof FXOMIntrinsic);
                    p.removeFromParentInstance();
                }
            } else {
                assert (p instanceof FXOMPropertyT);
                FXOMPropertyT pt = (FXOMPropertyT)p;
                assert (pt.getValue().equals("$null"));
                p.removeFromParentInstance();
            }
            ++this.changeCount;
        }
    }

    private void normalizeExpandedPaneProperty(FXOMPropertyC p) {
        assert (p != null);
        FXOMInstance parentInstance = p.getParentInstance();
        assert (parentInstance != null);
        FXOMObject titledPane = p.getValues().get(0);
        assert (titledPane.getSceneGraphObject() instanceof TitledPane);
        assert (titledPane.getFxId() != null);
        FXOMObject fxomRoot = p.getFxomDocument().getFxomRoot();
        List<FXOMIntrinsic> references = fxomRoot.collectReferences(titledPane.getFxId());
        assert (references.size() == 1);
        FXOMIntrinsic reference = references.get(0);
        assert (reference.getSource().equals(titledPane.getFxId()));
        assert (reference.getParentObject() == parentInstance);
        int referenceIndex = reference.getIndexInParentProperty();
        p.removeFromParentInstance();
        titledPane.removeFromParentProperty();
        titledPane.addToParentProperty(referenceIndex, reference.getParentProperty());
        reference.removeFromParentProperty();
    }

    private void normalizeGridPanes() {
        FXOMObject fxomRoot = this.fxomDocument.getFxomRoot();
        for (FXOMObject fxomGridPane : fxomRoot.collectObjectWithSceneGraphObjectClass(GridPane.class)) {
            this.normalizeGridPane(fxomGridPane);
            ++this.changeCount;
        }
    }

    private void normalizeGridPane(FXOMObject fxomGridPane) {
        assert (fxomGridPane instanceof FXOMInstance);
        assert (fxomGridPane.getSceneGraphObject() instanceof GridPane);
        GridPane gridPane = (GridPane)fxomGridPane.getSceneGraphObject();
        int columnCount = Deprecation.getGridPaneColumnCount(gridPane);
        int rowCount = Deprecation.getGridPaneRowCount(gridPane);
        columnConstraintsMeta.unpack((FXOMInstance)fxomGridPane, columnCount);
        rowConstraintsMeta.unpack((FXOMInstance)fxomGridPane, rowCount);
    }
}

