/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.property.value;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.Objects;

public abstract class SingleValuePropertyMetadata<T>
extends ValuePropertyMetadata {
    private final Class<T> valueClass;
    private final T defaultValue;

    public SingleValuePropertyMetadata(PropertyName name, Class<T> valueClass, boolean readWrite, T defaultValue, InspectorPath inspectorPath) {
        super(name, readWrite, inspectorPath);
        this.defaultValue = defaultValue;
        this.valueClass = valueClass;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getValue(FXOMInstance fxomInstance) {
        T result;
        if (this.isReadWrite()) {
            FXOMProperty fxomProperty = fxomInstance.getProperties().get(this.getName());
            if (fxomProperty == null) {
                result = this.defaultValue;
            } else if (fxomProperty instanceof FXOMPropertyT) {
                FXOMPropertyT fxomPropertyT = (FXOMPropertyT)fxomProperty;
                PrefixedValue pv = new PrefixedValue(fxomPropertyT.getValue());
                result = pv.isBindingExpression() ? this.getDefaultValue() : this.makeValueFromProperty(fxomPropertyT);
            } else if (fxomProperty instanceof FXOMPropertyC) {
                FXOMPropertyC fxomPropertyC = (FXOMPropertyC)fxomProperty;
                assert (!fxomPropertyC.getValues().isEmpty());
                FXOMObject firstValue = fxomPropertyC.getValues().get(0);
                result = firstValue instanceof FXOMInstance ? this.makeValueFromFxomInstance((FXOMInstance)firstValue) : this.getDefaultValue();
            } else {
                assert (false);
                result = this.defaultValue;
            }
        } else {
            result = this.valueClass.cast(this.getName().getValue(fxomInstance.getSceneGraphObject()));
        }
        return result;
    }

    public void setValue(FXOMInstance fxomInstance, T value) {
        assert (this.isReadWrite());
        FXOMProperty fxomProperty = fxomInstance.getProperties().get(this.getName());
        if (Objects.equals(value, this.getDefaultValueObject())) {
            if (fxomProperty != null) {
                fxomProperty.removeFromParentInstance();
            }
        } else {
            FXOMProperty newProperty;
            FXOMDocument fxomDocument = fxomInstance.getFxomDocument();
            if (this.canMakeStringFromValue(value)) {
                String valueString = this.makeStringFromValue(value);
                newProperty = new FXOMPropertyT(fxomDocument, this.getName(), valueString);
            } else {
                FXOMInstance valueInstance = this.makeFxomInstanceFromValue(value, fxomDocument);
                newProperty = new FXOMPropertyC(fxomDocument, this.getName(), valueInstance);
            }
            FXOMNodes.updateProperty(fxomInstance, newProperty);
        }
    }

    public abstract T makeValueFromString(String var1);

    public abstract T makeValueFromFxomInstance(FXOMInstance var1);

    public abstract boolean canMakeStringFromValue(T var1);

    public abstract String makeStringFromValue(T var1);

    public abstract FXOMInstance makeFxomInstanceFromValue(T var1, FXOMDocument var2);

    public T makeValueFromProperty(FXOMPropertyT fxomProperty) {
        return this.makeValueFromString(fxomProperty.getValue());
    }

    public Class<? extends T> getValueClass() {
        return this.valueClass;
    }

    @Override
    public Object getDefaultValueObject() {
        return this.defaultValue;
    }

    @Override
    public Object getValueObject(FXOMInstance fxomInstance) {
        return this.getValue(fxomInstance);
    }

    @Override
    public void setValueObject(FXOMInstance fxomInstance, Object valueObject) {
        this.setValue(fxomInstance, this.valueClass.cast(valueObject));
    }
}

