/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;

public class URLUtils {
    public static boolean equals(URL url1, URL url2) {
        boolean result;
        if (url1 == url2) {
            result = true;
        } else if (url1 == null || url2 == null) {
            result = false;
        } else {
            try {
                URI uri1 = url1.toURI();
                URI uri2 = url2.toURI();
                result = uri1.equals(uri2);
            }
            catch (URISyntaxException x) {
                result = false;
            }
        }
        return result;
    }

    public static File getFile(URI uri) {
        File result;
        assert (uri != null);
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.toLowerCase(Locale.ROOT).equals("file")) {
            result = null;
        } else {
            try {
                result = new File(uri);
            }
            catch (IllegalArgumentException x) {
                result = null;
            }
        }
        return result;
    }

    public static File getFile(String urlString) throws URISyntaxException {
        return URLUtils.getFile(new URI(urlString));
    }

    public static File getFile(URL url) throws URISyntaxException {
        return URLUtils.getFile(url.toURI());
    }
}

