/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.layoutlib.api.IResourceValue;
import com.android.layoutlib.api.IStyleResourceValue;
import com.android.resources.ResourceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class StyleResourceValue
extends ResourceValue
implements IStyleResourceValue {
    private String mParentStyle = null;
    private final Map<ItemResourceValue.Attribute, ItemResourceValue> mItems = new HashMap<ItemResourceValue.Attribute, ItemResourceValue>();

    public StyleResourceValue(ResourceType type, String name, boolean isFramework) {
        this(type, name, isFramework, null);
    }

    public StyleResourceValue(ResourceType type, String name, boolean isFramework, String libraryName) {
        super(type, name, isFramework, libraryName);
    }

    public StyleResourceValue(ResourceType type, String name, String parentStyle, boolean isFramework) {
        this(type, name, parentStyle, isFramework, null);
    }

    public StyleResourceValue(ResourceType type, String name, String parentStyle, boolean isFramework, String libraryName) {
        super(type, name, isFramework, libraryName);
        this.mParentStyle = parentStyle;
    }

    @Override
    public String getParentStyle() {
        return this.mParentStyle;
    }

    @Deprecated
    public ResourceValue findValue(String name) {
        return this.getItem(name, this.isFramework());
    }

    @Deprecated
    public ResourceValue findValue(String name, boolean isFrameworkAttr) {
        return this.getItem(name, isFrameworkAttr);
    }

    public ItemResourceValue getItem(String name, boolean isFrameworkAttr) {
        return this.mItems.get(new ItemResourceValue.Attribute(name, isFrameworkAttr));
    }

    @Deprecated
    public void addValue(ResourceValue value, boolean isFrameworkAttr, String libraryName) {
        this.addItem(ItemResourceValue.fromResourceValue(value, isFrameworkAttr, libraryName));
    }

    public void addItem(ItemResourceValue value) {
        this.mItems.put(value.getAttribute(), value);
    }

    @Override
    public void replaceWith(ResourceValue value) {
        assert (value instanceof StyleResourceValue) : value.getClass() + " is not StyleResourceValue";
        super.replaceWith(value);
        if (value instanceof StyleResourceValue) {
            this.mItems.clear();
            this.mItems.putAll(((StyleResourceValue)value).mItems);
        }
    }

    @Override
    @Deprecated
    public IResourceValue findItem(String name) {
        return this.mItems.get(new ItemResourceValue.Attribute(name, true));
    }

    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (ItemResourceValue.Attribute item : this.mItems.keySet()) {
            String name = item.mName;
            if (item.mIsFrameworkAttr) {
                name = "android:" + name;
            }
            names.add(name);
        }
        return names;
    }

    public Collection<ItemResourceValue> getValues() {
        return this.mItems.values();
    }
}

