/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import com.google.common.io.ByteStreams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.BaseDexBuffer;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.raw.HeaderItem;
import org.jf.dexlib2.dexbacked.util.FixedSizeSet;
import org.jf.dexlib2.iface.DexFile;
import org.jf.util.ExceptionWithContext;

public class DexBackedDexFile
extends BaseDexBuffer
implements DexFile {
    private final Opcodes opcodes;
    private final int stringCount;
    private final int stringStartOffset;
    private final int typeCount;
    private final int typeStartOffset;
    private final int protoCount;
    private final int protoStartOffset;
    private final int fieldCount;
    private final int fieldStartOffset;
    private final int methodCount;
    private final int methodStartOffset;
    private final int classCount;
    private final int classStartOffset;

    private DexBackedDexFile(Opcodes opcodes, @Nonnull byte[] buf, int offset, boolean verifyMagic) {
        super(buf);
        this.opcodes = opcodes;
        if (verifyMagic) {
            DexBackedDexFile.verifyMagicAndByteOrder(buf, offset);
        }
        this.stringCount = this.readSmallUint(56);
        this.stringStartOffset = this.readSmallUint(60);
        this.typeCount = this.readSmallUint(64);
        this.typeStartOffset = this.readSmallUint(68);
        this.protoCount = this.readSmallUint(72);
        this.protoStartOffset = this.readSmallUint(76);
        this.fieldCount = this.readSmallUint(80);
        this.fieldStartOffset = this.readSmallUint(84);
        this.methodCount = this.readSmallUint(88);
        this.methodStartOffset = this.readSmallUint(92);
        this.classCount = this.readSmallUint(96);
        this.classStartOffset = this.readSmallUint(100);
    }

    public DexBackedDexFile(@Nonnull Opcodes opcodes, @Nonnull BaseDexBuffer buf) {
        this(opcodes, buf.buf);
    }

    public DexBackedDexFile(@Nonnull Opcodes opcodes, @Nonnull byte[] buf, int offset) {
        this(opcodes, buf, offset, false);
    }

    public DexBackedDexFile(@Nonnull Opcodes opcodes, @Nonnull byte[] buf) {
        this(opcodes, buf, 0, true);
    }

    public static DexBackedDexFile fromInputStream(@Nonnull Opcodes opcodes, @Nonnull InputStream is) throws IOException {
        if (!is.markSupported()) {
            throw new IllegalArgumentException("InputStream must support mark");
        }
        is.mark(44);
        byte[] partialHeader = new byte[44];
        try {
            ByteStreams.readFully((InputStream)is, (byte[])partialHeader);
        }
        catch (EOFException ex) {
            throw new NotADexFile("File is too short");
        }
        finally {
            is.reset();
        }
        DexBackedDexFile.verifyMagicAndByteOrder(partialHeader, 0);
        byte[] buf = ByteStreams.toByteArray((InputStream)is);
        return new DexBackedDexFile(opcodes, buf, 0, false);
    }

    public Opcodes getOpcodes() {
        return this.opcodes;
    }

    public boolean isOdexFile() {
        return false;
    }

    @Nonnull
    public Set<? extends DexBackedClassDef> getClasses() {
        return new FixedSizeSet<DexBackedClassDef>(){

            @Override
            @Nonnull
            public DexBackedClassDef readItem(int index) {
                return new DexBackedClassDef(DexBackedDexFile.this, DexBackedDexFile.this.getClassDefItemOffset(index));
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.classCount;
            }
        };
    }

    private static void verifyMagicAndByteOrder(@Nonnull byte[] buf, int offset) {
        if (!HeaderItem.verifyMagic(buf, offset)) {
            StringBuilder sb = new StringBuilder("Invalid magic value:");
            for (int i = 0; i < 8; ++i) {
                sb.append(String.format(" %02x", buf[i]));
            }
            throw new NotADexFile(sb.toString());
        }
        int endian = HeaderItem.getEndian(buf, offset);
        if (endian == 2018915346) {
            throw new ExceptionWithContext("Big endian dex files are not currently supported", new Object[0]);
        }
        if (endian != 305419896) {
            throw new ExceptionWithContext("Invalid endian tag: 0x%x", new Object[]{endian});
        }
    }

    public int getStringIdItemOffset(int stringIndex) {
        if (stringIndex < 0 || stringIndex >= this.stringCount) {
            throw new InvalidItemIndex(stringIndex, "String index out of bounds: %d", stringIndex);
        }
        return this.stringStartOffset + stringIndex * 4;
    }

    public int getTypeIdItemOffset(int typeIndex) {
        if (typeIndex < 0 || typeIndex >= this.typeCount) {
            throw new InvalidItemIndex(typeIndex, "Type index out of bounds: %d", typeIndex);
        }
        return this.typeStartOffset + typeIndex * 4;
    }

    public int getFieldIdItemOffset(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.fieldCount) {
            throw new InvalidItemIndex(fieldIndex, "Field index out of bounds: %d", fieldIndex);
        }
        return this.fieldStartOffset + fieldIndex * 8;
    }

    public int getMethodIdItemOffset(int methodIndex) {
        if (methodIndex < 0 || methodIndex >= this.methodCount) {
            throw new InvalidItemIndex(methodIndex, "Method index out of bounds: %d", methodIndex);
        }
        return this.methodStartOffset + methodIndex * 8;
    }

    public int getProtoIdItemOffset(int protoIndex) {
        if (protoIndex < 0 || protoIndex >= this.protoCount) {
            throw new InvalidItemIndex(protoIndex, "Proto index out of bounds: %d", protoIndex);
        }
        return this.protoStartOffset + protoIndex * 12;
    }

    public int getClassDefItemOffset(int classIndex) {
        if (classIndex < 0 || classIndex >= this.classCount) {
            throw new InvalidItemIndex(classIndex, "Class index out of bounds: %d", classIndex);
        }
        return this.classStartOffset + classIndex * 32;
    }

    public int getClassCount() {
        return this.classCount;
    }

    public int getStringCount() {
        return this.stringCount;
    }

    public int getTypeCount() {
        return this.typeCount;
    }

    public int getProtoCount() {
        return this.protoCount;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public int getMethodCount() {
        return this.methodCount;
    }

    @Nonnull
    public String getString(int stringIndex) {
        int stringOffset = this.getStringIdItemOffset(stringIndex);
        int stringDataOffset = this.readSmallUint(stringOffset);
        DexReader reader = this.readerAt(stringDataOffset);
        int utf16Length = reader.readSmallUleb128();
        return reader.readString(utf16Length);
    }

    @Nullable
    public String getOptionalString(int stringIndex) {
        if (stringIndex == -1) {
            return null;
        }
        return this.getString(stringIndex);
    }

    @Nonnull
    public String getType(int typeIndex) {
        int typeOffset = this.getTypeIdItemOffset(typeIndex);
        int stringIndex = this.readSmallUint(typeOffset);
        return this.getString(stringIndex);
    }

    @Nullable
    public String getOptionalType(int typeIndex) {
        if (typeIndex == -1) {
            return null;
        }
        return this.getType(typeIndex);
    }

    @Override
    @Nonnull
    public DexReader readerAt(int offset) {
        return new DexReader(this, offset);
    }

    public static class InvalidItemIndex
    extends ExceptionWithContext {
        private final int itemIndex;

        public InvalidItemIndex(int itemIndex) {
            super("", new Object[0]);
            this.itemIndex = itemIndex;
        }

        public InvalidItemIndex(int itemIndex, String message, Object ... formatArgs) {
            super(message, formatArgs);
            this.itemIndex = itemIndex;
        }

        public int getInvalidIndex() {
            return this.itemIndex;
        }
    }

    public static class NotADexFile
    extends RuntimeException {
        public NotADexFile() {
        }

        public NotADexFile(Throwable cause) {
            super(cause);
        }

        public NotADexFile(String message) {
            super(message);
        }

        public NotADexFile(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

