/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Adler32;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.base.BaseAnnotation;
import org.jf.dexlib2.base.BaseAnnotationElement;
import org.jf.dexlib2.builder.MutableMethodImplementation;
import org.jf.dexlib2.builder.instruction.BuilderInstruction31c;
import org.jf.dexlib2.dexbacked.raw.HeaderItem;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.TryBlock;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.debug.LineNumber;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.OneRegisterInstruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.formats.ArrayPayload;
import org.jf.dexlib2.iface.instruction.formats.Instruction10t;
import org.jf.dexlib2.iface.instruction.formats.Instruction10x;
import org.jf.dexlib2.iface.instruction.formats.Instruction11n;
import org.jf.dexlib2.iface.instruction.formats.Instruction11x;
import org.jf.dexlib2.iface.instruction.formats.Instruction12x;
import org.jf.dexlib2.iface.instruction.formats.Instruction20bc;
import org.jf.dexlib2.iface.instruction.formats.Instruction20t;
import org.jf.dexlib2.iface.instruction.formats.Instruction21c;
import org.jf.dexlib2.iface.instruction.formats.Instruction21ih;
import org.jf.dexlib2.iface.instruction.formats.Instruction21lh;
import org.jf.dexlib2.iface.instruction.formats.Instruction21s;
import org.jf.dexlib2.iface.instruction.formats.Instruction21t;
import org.jf.dexlib2.iface.instruction.formats.Instruction22b;
import org.jf.dexlib2.iface.instruction.formats.Instruction22c;
import org.jf.dexlib2.iface.instruction.formats.Instruction22s;
import org.jf.dexlib2.iface.instruction.formats.Instruction22t;
import org.jf.dexlib2.iface.instruction.formats.Instruction22x;
import org.jf.dexlib2.iface.instruction.formats.Instruction23x;
import org.jf.dexlib2.iface.instruction.formats.Instruction25x;
import org.jf.dexlib2.iface.instruction.formats.Instruction30t;
import org.jf.dexlib2.iface.instruction.formats.Instruction31c;
import org.jf.dexlib2.iface.instruction.formats.Instruction31i;
import org.jf.dexlib2.iface.instruction.formats.Instruction31t;
import org.jf.dexlib2.iface.instruction.formats.Instruction32x;
import org.jf.dexlib2.iface.instruction.formats.Instruction35c;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rc;
import org.jf.dexlib2.iface.instruction.formats.Instruction51l;
import org.jf.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import org.jf.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.util.InstructionUtil;
import org.jf.dexlib2.util.MethodUtil;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.dexlib2.writer.AnnotationSection;
import org.jf.dexlib2.writer.AnnotationSetSection;
import org.jf.dexlib2.writer.ClassSection;
import org.jf.dexlib2.writer.DebugWriter;
import org.jf.dexlib2.writer.DexDataWriter;
import org.jf.dexlib2.writer.EncodedValueWriter;
import org.jf.dexlib2.writer.FieldSection;
import org.jf.dexlib2.writer.InstructionWriter;
import org.jf.dexlib2.writer.MethodSection;
import org.jf.dexlib2.writer.ProtoSection;
import org.jf.dexlib2.writer.StringSection;
import org.jf.dexlib2.writer.TypeListSection;
import org.jf.dexlib2.writer.TypeSection;
import org.jf.dexlib2.writer.io.DeferredOutputStream;
import org.jf.dexlib2.writer.io.DeferredOutputStreamFactory;
import org.jf.dexlib2.writer.io.DexDataStore;
import org.jf.dexlib2.writer.io.MemoryDeferredOutputStream;
import org.jf.dexlib2.writer.util.TryListBuilder;
import org.jf.util.CollectionUtils;
import org.jf.util.ExceptionWithContext;

public abstract class DexWriter<StringKey extends CharSequence, StringRef extends StringReference, TypeKey extends CharSequence, TypeRef extends TypeReference, ProtoKey extends Comparable<ProtoKey>, FieldRefKey extends FieldReference, MethodRefKey extends MethodReference, ClassKey extends Comparable<? super ClassKey>, AnnotationKey extends Annotation, AnnotationSetKey, TypeListKey, FieldKey, MethodKey, EncodedValue, AnnotationElement extends AnnotationElement> {
    public static final int NO_INDEX = -1;
    public static final int NO_OFFSET = 0;
    protected final int api;
    protected int stringIndexSectionOffset = 0;
    protected int typeSectionOffset = 0;
    protected int protoSectionOffset = 0;
    protected int fieldSectionOffset = 0;
    protected int methodSectionOffset = 0;
    protected int classIndexSectionOffset = 0;
    protected int stringDataSectionOffset = 0;
    protected int classDataSectionOffset = 0;
    protected int typeListSectionOffset = 0;
    protected int encodedArraySectionOffset = 0;
    protected int annotationSectionOffset = 0;
    protected int annotationSetSectionOffset = 0;
    protected int annotationSetRefSectionOffset = 0;
    protected int annotationDirectorySectionOffset = 0;
    protected int debugSectionOffset = 0;
    protected int codeSectionOffset = 0;
    protected int mapSectionOffset = 0;
    protected int numEncodedArrayItems = 0;
    protected int numAnnotationSetRefItems = 0;
    protected int numAnnotationDirectoryItems = 0;
    protected int numDebugInfoItems = 0;
    protected int numCodeItemItems = 0;
    protected int numClassDataItems = 0;
    protected final StringSection<StringKey, StringRef> stringSection;
    protected final TypeSection<StringKey, TypeKey, TypeRef> typeSection;
    protected final ProtoSection<StringKey, TypeKey, ProtoKey, TypeListKey> protoSection;
    protected final FieldSection<StringKey, TypeKey, FieldRefKey, FieldKey> fieldSection;
    protected final MethodSection<StringKey, TypeKey, ProtoKey, MethodRefKey, MethodKey> methodSection;
    protected final ClassSection<StringKey, TypeKey, TypeListKey, ClassKey, FieldKey, MethodKey, AnnotationSetKey, EncodedValue> classSection;
    protected final TypeListSection<TypeKey, TypeListKey> typeListSection;
    protected final AnnotationSection<StringKey, TypeKey, AnnotationKey, AnnotationElement, EncodedValue> annotationSection;
    protected final AnnotationSetSection<AnnotationKey, AnnotationSetKey> annotationSetSection;
    private static Comparator<Map.Entry> toStringKeyComparator = new Comparator<Map.Entry>(){

        @Override
        public int compare(Map.Entry o1, Map.Entry o2) {
            return o1.getKey().toString().compareTo(o2.getKey().toString());
        }
    };

    protected DexWriter(int api, StringSection<StringKey, StringRef> stringSection, TypeSection<StringKey, TypeKey, TypeRef> typeSection, ProtoSection<StringKey, TypeKey, ProtoKey, TypeListKey> protoSection, FieldSection<StringKey, TypeKey, FieldRefKey, FieldKey> fieldSection, MethodSection<StringKey, TypeKey, ProtoKey, MethodRefKey, MethodKey> methodSection, ClassSection<StringKey, TypeKey, TypeListKey, ClassKey, FieldKey, MethodKey, AnnotationSetKey, EncodedValue> classSection, TypeListSection<TypeKey, TypeListKey> typeListSection, AnnotationSection<StringKey, TypeKey, AnnotationKey, AnnotationElement, EncodedValue> annotationSection, AnnotationSetSection<AnnotationKey, AnnotationSetKey> annotationSetSection) {
        this.api = api;
        this.stringSection = stringSection;
        this.typeSection = typeSection;
        this.protoSection = protoSection;
        this.fieldSection = fieldSection;
        this.methodSection = methodSection;
        this.classSection = classSection;
        this.typeListSection = typeListSection;
        this.annotationSection = annotationSection;
        this.annotationSetSection = annotationSetSection;
    }

    protected abstract void writeEncodedValue(@Nonnull InternalEncodedValueWriter var1, @Nonnull EncodedValue var2) throws IOException;

    private static <T extends Comparable<? super T>> Comparator<Map.Entry<? extends T, ?>> comparableKeyComparator() {
        return new Comparator<Map.Entry<? extends T, ?>>(){

            @Override
            public int compare(Map.Entry<? extends T, ?> o1, Map.Entry<? extends T, ?> o2) {
                return ((Comparable)o1.getKey()).compareTo(o2.getKey());
            }
        };
    }

    private int getDataSectionOffset() {
        return 112 + this.stringSection.getItems().size() * 4 + this.typeSection.getItems().size() * 4 + this.protoSection.getItems().size() * 12 + this.fieldSection.getItems().size() * 8 + this.methodSection.getItems().size() * 8 + this.classSection.getItems().size() * 32;
    }

    @Nonnull
    public List<String> getMethodReferences() {
        ArrayList methodReferences = Lists.newArrayList();
        for (Map.Entry methodReference : this.methodSection.getItems()) {
            methodReferences.add(ReferenceUtil.getMethodDescriptor((MethodReference)methodReference.getKey()));
        }
        return methodReferences;
    }

    @Nonnull
    public List<String> getFieldReferences() {
        ArrayList fieldReferences = Lists.newArrayList();
        for (Map.Entry fieldReference : this.fieldSection.getItems()) {
            fieldReferences.add(ReferenceUtil.getFieldDescriptor((FieldReference)fieldReference.getKey()));
        }
        return fieldReferences;
    }

    @Nonnull
    public List<String> getTypeReferences() {
        ArrayList classReferences = Lists.newArrayList();
        for (Map.Entry typeReference : this.typeSection.getItems()) {
            classReferences.add(((Object)((CharSequence)typeReference.getKey())).toString());
        }
        return classReferences;
    }

    public void writeTo(@Nonnull DexDataStore dest) throws IOException {
        this.writeTo(dest, MemoryDeferredOutputStream.getFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(@Nonnull DexDataStore dest, @Nonnull DeferredOutputStreamFactory tempFactory) throws IOException {
        try {
            int dataSectionOffset = this.getDataSectionOffset();
            DexDataWriter headerWriter = DexWriter.outputAt(dest, 0);
            DexDataWriter indexWriter = DexWriter.outputAt(dest, 112);
            DexDataWriter offsetWriter = DexWriter.outputAt(dest, dataSectionOffset);
            try {
                this.writeStrings(indexWriter, offsetWriter);
                this.writeTypes(indexWriter);
                this.writeTypeLists(offsetWriter);
                this.writeProtos(indexWriter);
                this.writeFields(indexWriter);
                this.writeMethods(indexWriter);
                this.writeEncodedArrays(offsetWriter);
                this.writeAnnotations(offsetWriter);
                this.writeAnnotationSets(offsetWriter);
                this.writeAnnotationSetRefs(offsetWriter);
                this.writeAnnotationDirectories(offsetWriter);
                this.writeDebugAndCodeItems(offsetWriter, tempFactory.makeDeferredOutputStream());
                this.writeClasses(indexWriter, offsetWriter);
                this.writeMapItem(offsetWriter);
                this.writeHeader(headerWriter, dataSectionOffset, offsetWriter.getPosition());
            }
            finally {
                headerWriter.close();
                indexWriter.close();
                offsetWriter.close();
            }
            this.updateSignature(dest);
            this.updateChecksum(dest);
        }
        finally {
            dest.close();
        }
    }

    private void updateSignature(@Nonnull DexDataStore dataStore) throws IOException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        byte[] buffer = new byte[4096];
        InputStream input = dataStore.readAt(32);
        int bytesRead = input.read(buffer);
        while (bytesRead >= 0) {
            md.update(buffer, 0, bytesRead);
            bytesRead = input.read(buffer);
        }
        byte[] signature = md.digest();
        if (signature.length != 20) {
            throw new RuntimeException("unexpected digest write: " + signature.length + " bytes");
        }
        OutputStream output = dataStore.outputAt(12);
        output.write(signature);
        output.close();
    }

    private void updateChecksum(@Nonnull DexDataStore dataStore) throws IOException {
        Adler32 a32 = new Adler32();
        byte[] buffer = new byte[4096];
        InputStream input = dataStore.readAt(12);
        int bytesRead = input.read(buffer);
        while (bytesRead >= 0) {
            a32.update(buffer, 0, bytesRead);
            bytesRead = input.read(buffer);
        }
        OutputStream output = dataStore.outputAt(8);
        DexDataWriter.writeInt(output, (int)a32.getValue());
        output.close();
    }

    private static DexDataWriter outputAt(DexDataStore dataStore, int filePosition) throws IOException {
        return new DexDataWriter(dataStore.outputAt(filePosition), filePosition);
    }

    private void writeStrings(@Nonnull DexDataWriter indexWriter, @Nonnull DexDataWriter offsetWriter) throws IOException {
        this.stringIndexSectionOffset = indexWriter.getPosition();
        this.stringDataSectionOffset = offsetWriter.getPosition();
        int index = 0;
        ArrayList stringEntries = Lists.newArrayList(this.stringSection.getItems());
        Collections.sort(stringEntries, toStringKeyComparator);
        for (Map.Entry entry : stringEntries) {
            entry.setValue(index++);
            indexWriter.writeInt(offsetWriter.getPosition());
            String stringValue = ((Object)((CharSequence)entry.getKey())).toString();
            offsetWriter.writeUleb128(stringValue.length());
            offsetWriter.writeString(stringValue);
            offsetWriter.write(0);
        }
    }

    private void writeTypes(@Nonnull DexDataWriter writer) throws IOException {
        this.typeSectionOffset = writer.getPosition();
        int index = 0;
        ArrayList typeEntries = Lists.newArrayList(this.typeSection.getItems());
        Collections.sort(typeEntries, toStringKeyComparator);
        for (Map.Entry entry : typeEntries) {
            entry.setValue(index++);
            writer.writeInt(this.stringSection.getItemIndex(this.typeSection.getString(entry.getKey())));
        }
    }

    private void writeProtos(@Nonnull DexDataWriter writer) throws IOException {
        this.protoSectionOffset = writer.getPosition();
        int index = 0;
        ArrayList protoEntries = Lists.newArrayList(this.protoSection.getItems());
        Collections.sort(protoEntries, DexWriter.comparableKeyComparator());
        for (Map.Entry entry : protoEntries) {
            entry.setValue(index++);
            Comparable key = (Comparable)entry.getKey();
            writer.writeInt(this.stringSection.getItemIndex(this.protoSection.getShorty(key)));
            writer.writeInt(this.typeSection.getItemIndex(this.protoSection.getReturnType(key)));
            writer.writeInt(this.typeListSection.getNullableItemOffset(this.protoSection.getParameters(key)));
        }
    }

    private void writeFields(@Nonnull DexDataWriter writer) throws IOException {
        this.fieldSectionOffset = writer.getPosition();
        int index = 0;
        ArrayList fieldEntries = Lists.newArrayList(this.fieldSection.getItems());
        Collections.sort(fieldEntries, DexWriter.comparableKeyComparator());
        for (Map.Entry entry : fieldEntries) {
            entry.setValue(index++);
            FieldReference key = (FieldReference)entry.getKey();
            writer.writeUshort(this.typeSection.getItemIndex(this.fieldSection.getDefiningClass(key)));
            writer.writeUshort(this.typeSection.getItemIndex(this.fieldSection.getFieldType(key)));
            writer.writeInt(this.stringSection.getItemIndex(this.fieldSection.getName(key)));
        }
    }

    private void writeMethods(@Nonnull DexDataWriter writer) throws IOException {
        this.methodSectionOffset = writer.getPosition();
        int index = 0;
        ArrayList methodEntries = Lists.newArrayList(this.methodSection.getItems());
        Collections.sort(methodEntries, DexWriter.comparableKeyComparator());
        for (Map.Entry entry : methodEntries) {
            entry.setValue(index++);
            MethodReference key = (MethodReference)entry.getKey();
            writer.writeUshort(this.typeSection.getItemIndex(this.methodSection.getDefiningClass(key)));
            writer.writeUshort(this.protoSection.getItemIndex(this.methodSection.getPrototype(key)));
            writer.writeInt(this.stringSection.getItemIndex(this.methodSection.getName(key)));
        }
    }

    private void writeClasses(@Nonnull DexDataWriter indexWriter, @Nonnull DexDataWriter offsetWriter) throws IOException {
        this.classIndexSectionOffset = indexWriter.getPosition();
        this.classDataSectionOffset = offsetWriter.getPosition();
        ArrayList classEntries = Lists.newArrayList(this.classSection.getItems());
        Collections.sort(classEntries, DexWriter.comparableKeyComparator());
        int index = 0;
        for (Map.Entry key : classEntries) {
            index = this.writeClass(indexWriter, offsetWriter, index, key);
        }
    }

    private int writeClass(@Nonnull DexDataWriter indexWriter, @Nonnull DexDataWriter offsetWriter, int nextIndex, @Nullable Map.Entry<? extends ClassKey, Integer> entry) throws IOException {
        boolean classHasData;
        if (entry == null) {
            return nextIndex;
        }
        if (entry.getValue() != -1) {
            return nextIndex;
        }
        Comparable key = (Comparable)entry.getKey();
        entry.setValue(0);
        Map.Entry<ClassKey, Integer> superEntry = this.classSection.getClassEntryByType(this.classSection.getSuperclass(key));
        nextIndex = this.writeClass(indexWriter, offsetWriter, nextIndex, superEntry);
        for (CharSequence interfaceTypeKey : this.typeListSection.getTypes(this.classSection.getInterfaces(key))) {
            Map.Entry<ClassKey, Integer> interfaceEntry = this.classSection.getClassEntryByType(interfaceTypeKey);
            nextIndex = this.writeClass(indexWriter, offsetWriter, nextIndex, interfaceEntry);
        }
        entry.setValue(nextIndex++);
        indexWriter.writeInt(this.typeSection.getItemIndex(this.classSection.getType(key)));
        indexWriter.writeInt(this.classSection.getAccessFlags(key));
        indexWriter.writeInt(this.typeSection.getNullableItemIndex(this.classSection.getSuperclass(key)));
        indexWriter.writeInt(this.typeListSection.getNullableItemOffset(this.classSection.getInterfaces(key)));
        indexWriter.writeInt(this.stringSection.getNullableItemIndex(this.classSection.getSourceFile(key)));
        indexWriter.writeInt(this.classSection.getAnnotationDirectoryOffset(key));
        Collection<FieldKey> staticFields = this.classSection.getSortedStaticFields(key);
        Collection<FieldKey> instanceFields = this.classSection.getSortedInstanceFields(key);
        Collection<MethodKey> directMethods = this.classSection.getSortedDirectMethods(key);
        Collection<MethodKey> virtualMethods = this.classSection.getSortedVirtualMethods(key);
        boolean bl = classHasData = staticFields.size() > 0 || instanceFields.size() > 0 || directMethods.size() > 0 || virtualMethods.size() > 0;
        if (classHasData) {
            indexWriter.writeInt(offsetWriter.getPosition());
        } else {
            indexWriter.writeInt(0);
        }
        indexWriter.writeInt(this.classSection.getEncodedArrayOffset(key));
        if (classHasData) {
            ++this.numClassDataItems;
            offsetWriter.writeUleb128(staticFields.size());
            offsetWriter.writeUleb128(instanceFields.size());
            offsetWriter.writeUleb128(directMethods.size());
            offsetWriter.writeUleb128(virtualMethods.size());
            this.writeEncodedFields(offsetWriter, staticFields);
            this.writeEncodedFields(offsetWriter, instanceFields);
            this.writeEncodedMethods(offsetWriter, directMethods);
            this.writeEncodedMethods(offsetWriter, virtualMethods);
        }
        return nextIndex;
    }

    private void writeEncodedFields(@Nonnull DexDataWriter writer, @Nonnull Collection<? extends FieldKey> fields) throws IOException {
        int prevIndex = 0;
        for (FieldKey key : fields) {
            int index = this.fieldSection.getFieldIndex(key);
            writer.writeUleb128(index - prevIndex);
            writer.writeUleb128(this.classSection.getFieldAccessFlags(key));
            prevIndex = index;
        }
    }

    private void writeEncodedMethods(@Nonnull DexDataWriter writer, @Nonnull Collection<? extends MethodKey> methods) throws IOException {
        int prevIndex = 0;
        for (MethodKey key : methods) {
            int index = this.methodSection.getMethodIndex(key);
            writer.writeUleb128(index - prevIndex);
            writer.writeUleb128(this.classSection.getMethodAccessFlags(key));
            writer.writeUleb128(this.classSection.getCodeItemOffset(key));
            prevIndex = index;
        }
    }

    private void writeTypeLists(@Nonnull DexDataWriter writer) throws IOException {
        writer.align();
        this.typeListSectionOffset = writer.getPosition();
        for (Map.Entry entry : this.typeListSection.getItems()) {
            writer.align();
            entry.setValue(writer.getPosition());
            Collection<TypeKey> types = this.typeListSection.getTypes(entry.getKey());
            writer.writeInt(types.size());
            for (CharSequence typeKey : types) {
                writer.writeUshort(this.typeSection.getItemIndex(typeKey));
            }
        }
    }

    private void writeEncodedArrays(@Nonnull DexDataWriter writer) throws IOException {
        InternalEncodedValueWriter encodedValueWriter = new InternalEncodedValueWriter(writer);
        this.encodedArraySectionOffset = writer.getPosition();
        HashMap internedItems = Maps.newHashMap();
        EncodedArrayKey key = new EncodedArrayKey();
        for (Comparable classKey : this.classSection.getSortedClasses()) {
            Collection<EncodedValue> elements = this.classSection.getStaticInitializers(classKey);
            if (elements == null || elements.size() <= 0) continue;
            key.elements = elements;
            Integer prev = (Integer)internedItems.get(key);
            if (prev != null) {
                this.classSection.setEncodedArrayOffset(classKey, prev);
                continue;
            }
            int offset = writer.getPosition();
            internedItems.put(key, offset);
            this.classSection.setEncodedArrayOffset(classKey, offset);
            key = new EncodedArrayKey();
            ++this.numEncodedArrayItems;
            writer.writeUleb128(elements.size());
            for (EncodedValue value : elements) {
                this.writeEncodedValue(encodedValueWriter, value);
            }
        }
    }

    private void writeAnnotations(@Nonnull DexDataWriter writer) throws IOException {
        InternalEncodedValueWriter encodedValueWriter = new InternalEncodedValueWriter(writer);
        this.annotationSectionOffset = writer.getPosition();
        for (Map.Entry entry : this.annotationSection.getItems()) {
            entry.setValue(writer.getPosition());
            Annotation key = (Annotation)entry.getKey();
            writer.writeUbyte(this.annotationSection.getVisibility(key));
            writer.writeUleb128(this.typeSection.getItemIndex(this.annotationSection.getType(key)));
            ImmutableList elements = Ordering.from(BaseAnnotationElement.BY_NAME).immutableSortedCopy(this.annotationSection.getElements(key));
            writer.writeUleb128(elements.size());
            for (AnnotationElement element : elements) {
                writer.writeUleb128(this.stringSection.getItemIndex(this.annotationSection.getElementName(element)));
                this.writeEncodedValue(encodedValueWriter, this.annotationSection.getElementValue(element));
            }
        }
    }

    private void writeAnnotationSets(@Nonnull DexDataWriter writer) throws IOException {
        writer.align();
        this.annotationSetSectionOffset = writer.getPosition();
        if (this.shouldCreateEmptyAnnotationSet()) {
            writer.writeInt(0);
        }
        for (Map.Entry entry : this.annotationSetSection.getItems()) {
            ImmutableList annotations = Ordering.from(BaseAnnotation.BY_TYPE).immutableSortedCopy(this.annotationSetSection.getAnnotations(entry.getKey()));
            writer.align();
            entry.setValue(writer.getPosition());
            writer.writeInt(annotations.size());
            for (Annotation annotationKey : annotations) {
                writer.writeInt(this.annotationSection.getItemOffset(annotationKey));
            }
        }
    }

    private void writeAnnotationSetRefs(@Nonnull DexDataWriter writer) throws IOException {
        writer.align();
        this.annotationSetRefSectionOffset = writer.getPosition();
        HashMap internedItems = Maps.newHashMap();
        for (Comparable classKey : this.classSection.getSortedClasses()) {
            for (MethodKey methodKey : this.classSection.getSortedMethods(classKey)) {
                List<AnnotationSetKey> parameterAnnotations = this.classSection.getParameterAnnotations(methodKey);
                if (parameterAnnotations == null) continue;
                Integer prev = (Integer)internedItems.get(parameterAnnotations);
                if (prev != null) {
                    this.classSection.setAnnotationSetRefListOffset(methodKey, prev);
                    continue;
                }
                writer.align();
                int position = writer.getPosition();
                this.classSection.setAnnotationSetRefListOffset(methodKey, position);
                internedItems.put(parameterAnnotations, position);
                ++this.numAnnotationSetRefItems;
                writer.writeInt(parameterAnnotations.size());
                for (AnnotationSetKey annotationSetKey : parameterAnnotations) {
                    if (this.annotationSetSection.getAnnotations(annotationSetKey).size() > 0) {
                        writer.writeInt(this.annotationSetSection.getItemOffset(annotationSetKey));
                        continue;
                    }
                    if (this.shouldCreateEmptyAnnotationSet()) {
                        writer.writeInt(this.annotationSetSectionOffset);
                        continue;
                    }
                    writer.writeInt(0);
                }
            }
        }
    }

    private void writeAnnotationDirectories(@Nonnull DexDataWriter writer) throws IOException {
        writer.align();
        this.annotationDirectorySectionOffset = writer.getPosition();
        HashMap internedItems = Maps.newHashMap();
        ByteBuffer tempBuffer = ByteBuffer.allocate(65536);
        tempBuffer.order(ByteOrder.LITTLE_ENDIAN);
        for (Comparable key : this.classSection.getSortedClasses()) {
            Collection<FieldKey> fields = this.classSection.getSortedFields(key);
            Collection<MethodKey> methods = this.classSection.getSortedMethods(key);
            int maxSize = fields.size() * 8 + methods.size() * 16;
            if (maxSize > tempBuffer.capacity()) {
                tempBuffer = ByteBuffer.allocate(maxSize);
                tempBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            tempBuffer.clear();
            int fieldAnnotations = 0;
            int methodAnnotations = 0;
            int parameterAnnotations = 0;
            for (FieldKey field : fields) {
                AnnotationSetKey fieldAnnotationsKey = this.classSection.getFieldAnnotations(field);
                if (fieldAnnotationsKey == null) continue;
                ++fieldAnnotations;
                tempBuffer.putInt(this.fieldSection.getFieldIndex(field));
                tempBuffer.putInt(this.annotationSetSection.getItemOffset(fieldAnnotationsKey));
            }
            for (Object method : methods) {
                AnnotationSetKey methodAnnotationsKey = this.classSection.getMethodAnnotations(method);
                if (methodAnnotationsKey == null) continue;
                ++methodAnnotations;
                tempBuffer.putInt(this.methodSection.getMethodIndex(method));
                tempBuffer.putInt(this.annotationSetSection.getItemOffset(methodAnnotationsKey));
            }
            for (Object method : methods) {
                int offset = this.classSection.getAnnotationSetRefListOffset(method);
                if (offset == 0) continue;
                ++parameterAnnotations;
                tempBuffer.putInt(this.methodSection.getMethodIndex(method));
                tempBuffer.putInt(offset);
            }
            AnnotationSetKey classAnnotationKey = this.classSection.getClassAnnotations(key);
            if (fieldAnnotations == 0 && methodAnnotations == 0 && parameterAnnotations == 0) {
                if (classAnnotationKey == null) continue;
                Integer directoryOffset = (Integer)internedItems.get(classAnnotationKey);
                if (directoryOffset != null) {
                    this.classSection.setAnnotationDirectoryOffset(key, directoryOffset);
                    continue;
                }
                internedItems.put(classAnnotationKey, writer.getPosition());
            }
            ++this.numAnnotationDirectoryItems;
            this.classSection.setAnnotationDirectoryOffset(key, writer.getPosition());
            writer.writeInt(this.annotationSetSection.getNullableItemOffset(classAnnotationKey));
            writer.writeInt(fieldAnnotations);
            writer.writeInt(methodAnnotations);
            writer.writeInt(parameterAnnotations);
            writer.write(tempBuffer.array(), 0, tempBuffer.position());
        }
    }

    private void writeDebugAndCodeItems(@Nonnull DexDataWriter offsetWriter, @Nonnull DeferredOutputStream temp) throws IOException {
        ByteArrayOutputStream ehBuf = new ByteArrayOutputStream();
        this.debugSectionOffset = offsetWriter.getPosition();
        DebugWriter<StringKey, TypeKey> debugWriter = new DebugWriter<StringKey, TypeKey>(this.stringSection, this.typeSection, offsetWriter);
        DexDataWriter codeWriter = new DexDataWriter(temp, 0);
        ArrayList codeOffsets = Lists.newArrayList();
        for (Comparable classKey : this.classSection.getSortedClasses()) {
            Collection<MethodKey> directMethods = this.classSection.getSortedDirectMethods(classKey);
            Collection<MethodKey> virtualMethods = this.classSection.getSortedVirtualMethods(classKey);
            Iterable methods = Iterables.concat(directMethods, virtualMethods);
            for (Object methodKey : methods) {
                int debugItemOffset;
                int codeItemOffset;
                List<TryBlock<ExceptionHandler>> tryBlocks = this.classSection.getTryBlocks(methodKey);
                Iterable instructions = this.classSection.getInstructions(methodKey);
                Iterable<DebugItem> debugItems = this.classSection.getDebugItems(methodKey);
                if (instructions != null && this.stringSection.hasJumboIndexes()) {
                    boolean needsFix = false;
                    for (Instruction instruction : instructions) {
                        if (instruction.getOpcode() != Opcode.CONST_STRING || this.stringSection.getItemIndex((StringReference)((ReferenceInstruction)instruction).getReference()) < 65536) continue;
                        needsFix = true;
                        break;
                    }
                    if (needsFix) {
                        MutableMethodImplementation mutableMethodImplementation = this.classSection.makeMutableMethodImplementation(methodKey);
                        this.fixInstructions(mutableMethodImplementation);
                        instructions = mutableMethodImplementation.getInstructions();
                        tryBlocks = mutableMethodImplementation.getTryBlocks();
                        debugItems = mutableMethodImplementation.getDebugItems();
                    }
                }
                if ((codeItemOffset = this.writeCodeItem(codeWriter, ehBuf, methodKey, tryBlocks, instructions, debugItemOffset = this.writeDebugItem(offsetWriter, debugWriter, this.classSection.getParameterNames(methodKey), debugItems))) == -1) continue;
                codeOffsets.add(new CodeItemOffset(methodKey, codeItemOffset));
            }
        }
        offsetWriter.align();
        this.codeSectionOffset = offsetWriter.getPosition();
        codeWriter.close();
        temp.writeTo(offsetWriter);
        temp.close();
        for (CodeItemOffset codeOffset : codeOffsets) {
            this.classSection.setCodeItemOffset(codeOffset.method, this.codeSectionOffset + codeOffset.codeOffset);
        }
    }

    private void fixInstructions(@Nonnull MutableMethodImplementation methodImplementation) {
        Iterable instructions = methodImplementation.getInstructions();
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = (Instruction)instructions.get(i);
            if (instruction.getOpcode() != Opcode.CONST_STRING || this.stringSection.getItemIndex((StringReference)((ReferenceInstruction)instruction).getReference()) < 65536) continue;
            methodImplementation.replaceInstruction(i, new BuilderInstruction31c(Opcode.CONST_STRING_JUMBO, ((OneRegisterInstruction)instruction).getRegisterA(), ((ReferenceInstruction)instruction).getReference()));
        }
    }

    private int writeDebugItem(@Nonnull DexDataWriter writer, @Nonnull DebugWriter<StringKey, TypeKey> debugWriter, @Nullable Iterable<? extends StringKey> parameterNames, @Nullable Iterable<? extends DebugItem> debugItems) throws IOException {
        int parameterCount = 0;
        int lastNamedParameterIndex = -1;
        if (parameterNames != null) {
            parameterCount = Iterables.size(parameterNames);
            int index = 0;
            for (CharSequence parameterName : parameterNames) {
                if (parameterName != null) {
                    lastNamedParameterIndex = index;
                }
                ++index;
            }
        }
        if (lastNamedParameterIndex == -1 && (debugItems == null || Iterables.isEmpty(debugItems))) {
            return 0;
        }
        ++this.numDebugInfoItems;
        int debugItemOffset = writer.getPosition();
        int startingLineNumber = 0;
        if (debugItems != null) {
            for (DebugItem debugItem : debugItems) {
                if (!(debugItem instanceof LineNumber)) continue;
                startingLineNumber = ((LineNumber)debugItem).getLineNumber();
                break;
            }
        }
        writer.writeUleb128(startingLineNumber);
        writer.writeUleb128(parameterCount);
        if (parameterNames != null) {
            int index = 0;
            for (CharSequence parameterName : parameterNames) {
                if (index == parameterCount) break;
                ++index;
                writer.writeUleb128(this.stringSection.getNullableItemIndex(parameterName) + 1);
            }
        }
        if (debugItems != null) {
            debugWriter.reset(startingLineNumber);
            for (DebugItem debugItem : debugItems) {
                this.classSection.writeDebugItem(debugWriter, debugItem);
            }
        }
        writer.write(0);
        return debugItemOffset;
    }

    private int writeCodeItem(@Nonnull DexDataWriter writer, @Nonnull ByteArrayOutputStream ehBuf, @Nonnull MethodKey methodKey, @Nonnull List<? extends TryBlock<? extends ExceptionHandler>> tryBlocks, @Nullable Iterable<? extends Instruction> instructions, int debugItemOffset) throws IOException {
        if (instructions == null && debugItemOffset == 0) {
            return -1;
        }
        ++this.numCodeItemItems;
        writer.align();
        int codeItemOffset = writer.getPosition();
        writer.writeUshort(this.classSection.getRegisterCount(methodKey));
        boolean isStatic = AccessFlags.STATIC.isSet(this.classSection.getMethodAccessFlags(methodKey));
        Collection<TypeKey> parameters = this.typeListSection.getTypes(this.protoSection.getParameters(this.methodSection.getPrototype(methodKey)));
        writer.writeUshort(MethodUtil.getParameterRegisterCount(parameters, isStatic));
        if (instructions != null) {
            tryBlocks = TryListBuilder.massageTryBlocks(tryBlocks);
            int outParamCount = 0;
            int codeUnitCount = 0;
            for (Instruction instruction : instructions) {
                ReferenceInstruction referenceInstruction;
                MethodReference methodRef;
                int paramCount;
                codeUnitCount += instruction.getCodeUnits();
                if (instruction.getOpcode().referenceType != 3 || (paramCount = MethodUtil.getParameterRegisterCount(methodRef = (MethodReference)(referenceInstruction = (ReferenceInstruction)instruction).getReference(), InstructionUtil.isInvokeStatic(instruction.getOpcode()))) <= outParamCount) continue;
                outParamCount = paramCount;
            }
            writer.writeUshort(outParamCount);
            writer.writeUshort(tryBlocks.size());
            writer.writeInt(debugItemOffset);
            InstructionWriter<StringRef, TypeRef, FieldRefKey, MethodRefKey> instructionWriter = InstructionWriter.makeInstructionWriter(writer, this.stringSection, this.typeSection, this.fieldSection, this.methodSection);
            writer.writeInt(codeUnitCount);
            block33: for (Instruction instruction : instructions) {
                switch (instruction.getOpcode().format) {
                    case Format10t: {
                        instructionWriter.write((Instruction10t)instruction);
                        continue block33;
                    }
                    case Format10x: {
                        instructionWriter.write((Instruction10x)instruction);
                        continue block33;
                    }
                    case Format11n: {
                        instructionWriter.write((Instruction11n)instruction);
                        continue block33;
                    }
                    case Format11x: {
                        instructionWriter.write((Instruction11x)instruction);
                        continue block33;
                    }
                    case Format12x: {
                        instructionWriter.write((Instruction12x)instruction);
                        continue block33;
                    }
                    case Format20bc: {
                        instructionWriter.write((Instruction20bc)instruction);
                        continue block33;
                    }
                    case Format20t: {
                        instructionWriter.write((Instruction20t)instruction);
                        continue block33;
                    }
                    case Format21c: {
                        instructionWriter.write((Instruction21c)instruction);
                        continue block33;
                    }
                    case Format21ih: {
                        instructionWriter.write((Instruction21ih)instruction);
                        continue block33;
                    }
                    case Format21lh: {
                        instructionWriter.write((Instruction21lh)instruction);
                        continue block33;
                    }
                    case Format21s: {
                        instructionWriter.write((Instruction21s)instruction);
                        continue block33;
                    }
                    case Format21t: {
                        instructionWriter.write((Instruction21t)instruction);
                        continue block33;
                    }
                    case Format22b: {
                        instructionWriter.write((Instruction22b)instruction);
                        continue block33;
                    }
                    case Format22c: {
                        instructionWriter.write((Instruction22c)instruction);
                        continue block33;
                    }
                    case Format22s: {
                        instructionWriter.write((Instruction22s)instruction);
                        continue block33;
                    }
                    case Format22t: {
                        instructionWriter.write((Instruction22t)instruction);
                        continue block33;
                    }
                    case Format22x: {
                        instructionWriter.write((Instruction22x)instruction);
                        continue block33;
                    }
                    case Format23x: {
                        instructionWriter.write((Instruction23x)instruction);
                        continue block33;
                    }
                    case Format25x: {
                        instructionWriter.write((Instruction25x)instruction);
                        continue block33;
                    }
                    case Format30t: {
                        instructionWriter.write((Instruction30t)instruction);
                        continue block33;
                    }
                    case Format31c: {
                        instructionWriter.write((Instruction31c)instruction);
                        continue block33;
                    }
                    case Format31i: {
                        instructionWriter.write((Instruction31i)instruction);
                        continue block33;
                    }
                    case Format31t: {
                        instructionWriter.write((Instruction31t)instruction);
                        continue block33;
                    }
                    case Format32x: {
                        instructionWriter.write((Instruction32x)instruction);
                        continue block33;
                    }
                    case Format35c: {
                        instructionWriter.write((Instruction35c)instruction);
                        continue block33;
                    }
                    case Format3rc: {
                        instructionWriter.write((Instruction3rc)instruction);
                        continue block33;
                    }
                    case Format51l: {
                        instructionWriter.write((Instruction51l)instruction);
                        continue block33;
                    }
                    case ArrayPayload: {
                        instructionWriter.write((ArrayPayload)instruction);
                        continue block33;
                    }
                    case PackedSwitchPayload: {
                        instructionWriter.write((PackedSwitchPayload)instruction);
                        continue block33;
                    }
                    case SparseSwitchPayload: {
                        instructionWriter.write((SparseSwitchPayload)instruction);
                        continue block33;
                    }
                }
                throw new ExceptionWithContext("Unsupported instruction format: %s", new Object[]{instruction.getOpcode().format});
            }
            if (tryBlocks.size() > 0) {
                writer.align();
                HashMap hashMap = Maps.newHashMap();
                for (TryBlock<ExceptionHandler> tryBlock : tryBlocks) {
                    hashMap.put(tryBlock.getExceptionHandlers(), 0);
                }
                DexDataWriter.writeUleb128(ehBuf, hashMap.size());
                for (TryBlock<ExceptionHandler> tryBlock : tryBlocks) {
                    int startAddress = tryBlock.getStartCodeAddress();
                    int endAddress = startAddress + tryBlock.getCodeUnitCount();
                    int tbCodeUnitCount = endAddress - startAddress;
                    writer.writeInt(startAddress);
                    writer.writeUshort(tbCodeUnitCount);
                    if (tryBlock.getExceptionHandlers().size() == 0) {
                        throw new ExceptionWithContext("No exception handlers for the try block!", new Object[0]);
                    }
                    Integer offset = (Integer)hashMap.get(tryBlock.getExceptionHandlers());
                    if (offset != 0) {
                        writer.writeUshort(offset);
                        continue;
                    }
                    offset = ehBuf.size();
                    writer.writeUshort(offset);
                    hashMap.put(tryBlock.getExceptionHandlers(), offset);
                    int ehSize = tryBlock.getExceptionHandlers().size();
                    ExceptionHandler ehLast = tryBlock.getExceptionHandlers().get(ehSize - 1);
                    if (ehLast.getExceptionType() == null) {
                        ehSize = ehSize * -1 + 1;
                    }
                    DexDataWriter.writeSleb128(ehBuf, ehSize);
                    for (ExceptionHandler eh : tryBlock.getExceptionHandlers()) {
                        TypeKey exceptionTypeKey = this.classSection.getExceptionType(eh);
                        int codeAddress = eh.getHandlerCodeAddress();
                        if (exceptionTypeKey != null) {
                            DexDataWriter.writeUleb128(ehBuf, this.typeSection.getItemIndex(exceptionTypeKey));
                            DexDataWriter.writeUleb128(ehBuf, codeAddress);
                            continue;
                        }
                        DexDataWriter.writeUleb128(ehBuf, codeAddress);
                    }
                }
                if (ehBuf.size() > 0) {
                    ehBuf.writeTo(writer);
                    ehBuf.reset();
                }
            }
        } else {
            writer.writeUshort(0);
            writer.writeUshort(0);
            writer.writeInt(debugItemOffset);
            writer.writeInt(0);
        }
        return codeItemOffset;
    }

    private int calcNumItems() {
        int numItems = 0;
        ++numItems;
        if (this.stringSection.getItems().size() > 0) {
            numItems += 2;
        }
        if (this.typeSection.getItems().size() > 0) {
            ++numItems;
        }
        if (this.protoSection.getItems().size() > 0) {
            ++numItems;
        }
        if (this.fieldSection.getItems().size() > 0) {
            ++numItems;
        }
        if (this.methodSection.getItems().size() > 0) {
            ++numItems;
        }
        if (this.typeListSection.getItems().size() > 0) {
            ++numItems;
        }
        if (this.numEncodedArrayItems > 0) {
            ++numItems;
        }
        if (this.annotationSection.getItems().size() > 0) {
            ++numItems;
        }
        if (this.annotationSetSection.getItems().size() > 0 || this.shouldCreateEmptyAnnotationSet()) {
            ++numItems;
        }
        if (this.numAnnotationSetRefItems > 0) {
            ++numItems;
        }
        if (this.numAnnotationDirectoryItems > 0) {
            ++numItems;
        }
        if (this.numDebugInfoItems > 0) {
            ++numItems;
        }
        if (this.numCodeItemItems > 0) {
            ++numItems;
        }
        if (this.classSection.getItems().size() > 0) {
            ++numItems;
        }
        if (this.numClassDataItems > 0) {
            ++numItems;
        }
        return ++numItems;
    }

    private void writeMapItem(@Nonnull DexDataWriter writer) throws IOException {
        writer.align();
        this.mapSectionOffset = writer.getPosition();
        int numItems = this.calcNumItems();
        writer.writeInt(numItems);
        this.writeMapItem(writer, 0, 1, 0);
        this.writeMapItem(writer, 1, this.stringSection.getItems().size(), this.stringIndexSectionOffset);
        this.writeMapItem(writer, 2, this.typeSection.getItems().size(), this.typeSectionOffset);
        this.writeMapItem(writer, 3, this.protoSection.getItems().size(), this.protoSectionOffset);
        this.writeMapItem(writer, 4, this.fieldSection.getItems().size(), this.fieldSectionOffset);
        this.writeMapItem(writer, 5, this.methodSection.getItems().size(), this.methodSectionOffset);
        this.writeMapItem(writer, 6, this.classSection.getItems().size(), this.classIndexSectionOffset);
        this.writeMapItem(writer, 8194, this.stringSection.getItems().size(), this.stringDataSectionOffset);
        this.writeMapItem(writer, 4097, this.typeListSection.getItems().size(), this.typeListSectionOffset);
        this.writeMapItem(writer, 8197, this.numEncodedArrayItems, this.encodedArraySectionOffset);
        this.writeMapItem(writer, 8196, this.annotationSection.getItems().size(), this.annotationSectionOffset);
        this.writeMapItem(writer, 4099, this.annotationSetSection.getItems().size() + (this.shouldCreateEmptyAnnotationSet() ? 1 : 0), this.annotationSetSectionOffset);
        this.writeMapItem(writer, 4098, this.numAnnotationSetRefItems, this.annotationSetRefSectionOffset);
        this.writeMapItem(writer, 8198, this.numAnnotationDirectoryItems, this.annotationDirectorySectionOffset);
        this.writeMapItem(writer, 8195, this.numDebugInfoItems, this.debugSectionOffset);
        this.writeMapItem(writer, 8193, this.numCodeItemItems, this.codeSectionOffset);
        this.writeMapItem(writer, 8192, this.numClassDataItems, this.classDataSectionOffset);
        this.writeMapItem(writer, 4096, 1, this.mapSectionOffset);
    }

    private void writeMapItem(@Nonnull DexDataWriter writer, int type, int size, int offset) throws IOException {
        if (size > 0) {
            writer.writeUshort(type);
            writer.writeUshort(0);
            writer.writeInt(size);
            writer.writeInt(offset);
        }
    }

    private void writeHeader(@Nonnull DexDataWriter writer, int dataOffset, int fileSize) throws IOException {
        writer.write(HeaderItem.MAGIC_VALUES[0]);
        writer.writeInt(0);
        writer.write(new byte[20]);
        writer.writeInt(fileSize);
        writer.writeInt(112);
        writer.writeInt(305419896);
        writer.writeInt(0);
        writer.writeInt(0);
        writer.writeInt(this.mapSectionOffset);
        this.writeSectionInfo(writer, this.stringSection.getItems().size(), this.stringIndexSectionOffset);
        this.writeSectionInfo(writer, this.typeSection.getItems().size(), this.typeSectionOffset);
        this.writeSectionInfo(writer, this.protoSection.getItems().size(), this.protoSectionOffset);
        this.writeSectionInfo(writer, this.fieldSection.getItems().size(), this.fieldSectionOffset);
        this.writeSectionInfo(writer, this.methodSection.getItems().size(), this.methodSectionOffset);
        this.writeSectionInfo(writer, this.classSection.getItems().size(), this.classIndexSectionOffset);
        writer.writeInt(fileSize - dataOffset);
        writer.writeInt(dataOffset);
    }

    private void writeSectionInfo(DexDataWriter writer, int numItems, int offset) throws IOException {
        writer.writeInt(numItems);
        if (numItems > 0) {
            writer.writeInt(offset);
        } else {
            writer.writeInt(0);
        }
    }

    private boolean shouldCreateEmptyAnnotationSet() {
        return this.api < 17;
    }

    private static class CodeItemOffset<MethodKey> {
        @Nonnull
        MethodKey method;
        int codeOffset;

        private CodeItemOffset(@Nonnull MethodKey method, int codeOffset) {
            this.codeOffset = codeOffset;
            this.method = method;
        }
    }

    private static class EncodedArrayKey<EncodedValue> {
        @Nonnull
        Collection<? extends EncodedValue> elements;

        public int hashCode() {
            return CollectionUtils.listHashCode(this.elements);
        }

        public boolean equals(Object o) {
            if (o instanceof EncodedArrayKey) {
                EncodedArrayKey other = (EncodedArrayKey)o;
                if (this.elements.size() != other.elements.size()) {
                    return false;
                }
                return Iterables.elementsEqual(this.elements, other.elements);
            }
            return false;
        }
    }

    protected class InternalEncodedValueWriter
    extends EncodedValueWriter<StringKey, TypeKey, FieldRefKey, MethodRefKey, AnnotationElement, EncodedValue> {
        private InternalEncodedValueWriter(DexDataWriter writer) {
            super(writer, DexWriter.this.stringSection, DexWriter.this.typeSection, DexWriter.this.fieldSection, DexWriter.this.methodSection, DexWriter.this.annotationSection);
        }

        @Override
        protected void writeEncodedValue(@Nonnull EncodedValue encodedValue) throws IOException {
            DexWriter.this.writeEncodedValue(this, encodedValue);
        }
    }
}

