/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.PublicMethodBasedOptionDescription;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitOptionsTopHitProvider
extends OptionsTopHitProvider {
    public String getId() {
        return "vcs";
    }

    @NotNull
    public Collection<BooleanOptionDescription> getOptions(@Nullable Project project) {
        if (project != null) {
            for (VcsDescriptor descriptor : ProjectLevelVcsManager.getInstance((Project)project).getAllVcss()) {
                if (!"Git".equals(descriptor.getDisplayName())) continue;
                final GitVcsSettings settings = GitVcsSettings.getInstance(project);
                ArrayList<BooleanOptionDescription> options = new ArrayList<BooleanOptionDescription>();
                options.add(GitOptionsTopHitProvider.option(project, "Git: Commit automatically on cherry-pick", "isAutoCommitOnCherryPick", "setAutoCommitOnCherryPick"));
                options.add(GitOptionsTopHitProvider.option(project, "Git: Auto-update if push of the current branch was rejected", "autoUpdateIfPushRejected", "setAutoUpdateIfPushRejected"));
                GitRepositoryManager manager = GitRepositoryManager.getInstance(project);
                if (manager != null && manager.moreThanOneRoot()) {
                    options.add(new BooleanOptionDescription("Git: Control repositories synchronously", "vcs.Git"){

                        public boolean isOptionEnabled() {
                            return settings.getSyncSetting() == DvcsSyncSettings.Value.SYNC;
                        }

                        public void setOptionState(boolean enabled) {
                            settings.setSyncSetting(enabled ? DvcsSyncSettings.Value.SYNC : DvcsSyncSettings.Value.DONT_SYNC);
                        }
                    });
                }
                options.add(GitOptionsTopHitProvider.option(project, "Git: Warn if CRLF line separators are about to be committed", "warnAboutCrlf", "setWarnAboutCrlf"));
                options.add(GitOptionsTopHitProvider.option(project, "Git: Warn when committing in detached HEAD or during rebase", "warnAboutDetachedHead", "setWarnAboutDetachedHead"));
                options.add(GitOptionsTopHitProvider.option(project, "Git: Allow force push", "isForcePushAllowed", "setForcePushAllowed"));
                Collection<BooleanOptionDescription> collection = Collections.unmodifiableCollection(options);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitOptionsTopHitProvider", "getOptions"));
                }
                return collection;
            }
        }
        List<BooleanOptionDescription> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitOptionsTopHitProvider", "getOptions"));
        }
        return list;
    }

    private static BooleanOptionDescription option(final Project project, String option, String getter, String setter) {
        return new PublicMethodBasedOptionDescription(option, "vcs.Git", getter, setter){

            public Object getInstance() {
                return GitVcsSettings.getInstance(project);
            }
        };
    }
}

