/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.BaseDiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitDiffFromHistoryHandler
extends BaseDiffFromHistoryHandler<GitFileRevision> {
    private static final Logger LOG = Logger.getInstance(GitDiffFromHistoryHandler.class);
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;

    public GitDiffFromHistoryHandler(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitDiffFromHistoryHandler", "<init>"));
        }
        super(project);
        this.myGit = (Git)ServiceManager.getService((Project)project, Git.class);
        this.myRepositoryManager = GitUtil.getRepositoryManager(project);
    }

    public void showDiffForOne(@NotNull AnActionEvent e, @NotNull Project project, @NotNull FilePath filePath, @NotNull VcsFileRevision previousRevision, @NotNull VcsFileRevision revision) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForOne"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForOne"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForOne"));
        }
        if (previousRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousRevision", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForOne"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForOne"));
        }
        GitFileRevision rev = (GitFileRevision)revision;
        Collection<String> parents = rev.getParents();
        if (parents.size() < 2) {
            super.showDiffForOne(e, project, filePath, previousRevision, revision);
        } else {
            this.showDiffForMergeCommit(e, filePath, rev, parents);
        }
    }

    @NotNull
    protected List<Change> getChangesBetweenRevisions(@NotNull FilePath path, @NotNull GitFileRevision rev1, @Nullable GitFileRevision rev2) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitDiffFromHistoryHandler", "getChangesBetweenRevisions"));
        }
        if (rev1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev1", "git4idea/history/GitDiffFromHistoryHandler", "getChangesBetweenRevisions"));
        }
        GitRepository repository = this.getRepository(path);
        String hash1 = rev1.getHash();
        String hash2 = rev2 != null ? rev2.getHash() : null;
        ArrayList arrayList = ContainerUtil.newArrayList(GitChangeUtils.getDiff(repository.getProject(), repository.getRoot(), hash1, hash2, Collections.singletonList(path)));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "getChangesBetweenRevisions"));
        }
        return arrayList;
    }

    @NotNull
    protected List<Change> getAffectedChanges(@NotNull FilePath path, @NotNull GitFileRevision rev) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitDiffFromHistoryHandler", "getAffectedChanges"));
        }
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "git4idea/history/GitDiffFromHistoryHandler", "getAffectedChanges"));
        }
        GitRepository repository = this.getRepository(path);
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)GitChangeUtils.getRevisionChanges(repository.getProject(), repository.getRoot(), rev.getHash(), false, true, true).getChanges());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "getAffectedChanges"));
        }
        return arrayList;
    }

    @NotNull
    protected String getPresentableName(@NotNull GitFileRevision revision) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "git4idea/history/GitDiffFromHistoryHandler", "getPresentableName"));
        }
        String string = DvcsUtil.getShortHash((String)revision.getHash());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    private GitRepository getRepository(@NotNull FilePath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitDiffFromHistoryHandler", "getRepository"));
        }
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForFile(path);
        LOG.assertTrue(repository != null, (Object)("Repository is null for " + path));
        GitRepository gitRepository = repository;
        if (gitRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "getRepository"));
        }
        return gitRepository;
    }

    private void showDiffForMergeCommit(final @NotNull AnActionEvent event, final @NotNull FilePath filePath, final @NotNull GitFileRevision rev, @NotNull Collection<String> parents) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForMergeCommit"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForMergeCommit"));
        }
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForMergeCommit"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "git4idea/history/GitDiffFromHistoryHandler", "showDiffForMergeCommit"));
        }
        VcsHistorySession session = (VcsHistorySession)event.getData(VcsDataKeys.HISTORY_SESSION);
        List revisions = session != null ? session.getRevisionList() : null;
        this.checkIfFileWasTouchedAndFindParentsInBackground(filePath, rev, parents, revisions, new Consumer<MergeCommitPreCheckInfo>(){

            public void consume(MergeCommitPreCheckInfo info) {
                if (!info.wasFileTouched()) {
                    String message = String.format("There were no changes in %s in this merge commit, besides those which were made in both branches", filePath.getName());
                    VcsBalloonProblemNotifier.showOverVersionControlView((Project)GitDiffFromHistoryHandler.this.myProject, (String)message, (MessageType)MessageType.INFO);
                }
                GitDiffFromHistoryHandler.this.showPopup(event, rev, filePath, info.getParents());
            }
        });
    }

    private void checkIfFileWasTouchedAndFindParentsInBackground(final @NotNull FilePath filePath, final @NotNull GitFileRevision rev, final @NotNull Collection<String> parentHashes, final @Nullable List<VcsFileRevision> revisions, final @NotNull Consumer<MergeCommitPreCheckInfo> resultHandler) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/history/GitDiffFromHistoryHandler", "checkIfFileWasTouchedAndFindParentsInBackground"));
        }
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "git4idea/history/GitDiffFromHistoryHandler", "checkIfFileWasTouchedAndFindParentsInBackground"));
        }
        if (parentHashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentHashes", "git4idea/history/GitDiffFromHistoryHandler", "checkIfFileWasTouchedAndFindParentsInBackground"));
        }
        if (resultHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultHandler", "git4idea/history/GitDiffFromHistoryHandler", "checkIfFileWasTouchedAndFindParentsInBackground"));
        }
        new Task.Backgroundable(this.myProject, "Loading changes...", true){
            private MergeCommitPreCheckInfo myInfo;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/history/GitDiffFromHistoryHandler$2", "run"));
                }
                try {
                    GitRepository repository = GitDiffFromHistoryHandler.this.getRepository(filePath);
                    boolean fileTouched = GitDiffFromHistoryHandler.this.wasFileTouched(repository, rev);
                    Collection parents = GitDiffFromHistoryHandler.this.findParentRevisions(repository, rev, parentHashes, revisions);
                    this.myInfo = new MergeCommitPreCheckInfo(fileTouched, parents);
                }
                catch (VcsException e) {
                    String logMessage = "Error happened while executing git show " + rev + ":" + filePath;
                    GitDiffFromHistoryHandler.this.showError(e, logMessage);
                }
            }

            public void onSuccess() {
                if (this.myInfo != null) {
                    resultHandler.consume((Object)this.myInfo);
                }
            }
        }.queue();
    }

    @NotNull
    private Collection<GitFileRevision> findParentRevisions(@NotNull GitRepository repository, @NotNull GitFileRevision currentRevision, @NotNull Collection<String> parentHashes, @Nullable List<VcsFileRevision> revisions) throws VcsException {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/history/GitDiffFromHistoryHandler", "findParentRevisions"));
        }
        if (currentRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRevision", "git4idea/history/GitDiffFromHistoryHandler", "findParentRevisions"));
        }
        if (parentHashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentHashes", "git4idea/history/GitDiffFromHistoryHandler", "findParentRevisions"));
        }
        ArrayList<GitFileRevision> parents = new ArrayList<GitFileRevision>(parentHashes.size());
        for (String parentHash : parentHashes) {
            parents.add(this.createParentRevision(repository, currentRevision, parentHash, revisions));
        }
        ArrayList<GitFileRevision> arrayList = parents;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "findParentRevisions"));
        }
        return arrayList;
    }

    @NotNull
    private GitFileRevision createParentRevision(@NotNull GitRepository repository, @NotNull GitFileRevision currentRevision, @NotNull String parentHash, @Nullable List<VcsFileRevision> revisions) throws VcsException {
        FilePath currentRevisionPath;
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/history/GitDiffFromHistoryHandler", "createParentRevision"));
        }
        if (currentRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRevision", "git4idea/history/GitDiffFromHistoryHandler", "createParentRevision"));
        }
        if (parentHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentHash", "git4idea/history/GitDiffFromHistoryHandler", "createParentRevision"));
        }
        if (revisions != null) {
            for (VcsFileRevision revision : revisions) {
                if (!((GitFileRevision)revision).getHash().equals(parentHash)) continue;
                GitFileRevision gitFileRevision = (GitFileRevision)revision;
                if (gitFileRevision == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "createParentRevision"));
                }
                return gitFileRevision;
            }
        }
        if ((currentRevisionPath = currentRevision.getPath()).isDirectory()) {
            GitFileRevision gitFileRevision = this.makeRevisionFromHash(currentRevisionPath, parentHash);
            if (gitFileRevision == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "createParentRevision"));
            }
            return gitFileRevision;
        }
        Collection<Change> changes = GitChangeUtils.getDiff(this.myProject, repository.getRoot(), parentHash, currentRevision.getHash(), null);
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (afterRevision == null || !afterRevision.getFile().equals(currentRevisionPath)) continue;
            FilePath path = beforeRevision != null ? beforeRevision.getFile() : afterRevision.getFile();
            GitFileRevision gitFileRevision = this.makeRevisionFromHash(path, parentHash);
            if (gitFileRevision == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "createParentRevision"));
            }
            return gitFileRevision;
        }
        LOG.error(String.format("Could not find parent revision. Will use the path from parent revision. Current revision: %s, parent hash: %s", currentRevision, parentHash));
        GitFileRevision gitFileRevision = this.makeRevisionFromHash(currentRevisionPath, parentHash);
        if (gitFileRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "createParentRevision"));
        }
        return gitFileRevision;
    }

    private void showPopup(@NotNull AnActionEvent event, @NotNull GitFileRevision rev, @NotNull FilePath filePath, @NotNull Collection<GitFileRevision> parents) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/history/GitDiffFromHistoryHandler", "showPopup"));
        }
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "git4idea/history/GitDiffFromHistoryHandler", "showPopup"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/history/GitDiffFromHistoryHandler", "showPopup"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "git4idea/history/GitDiffFromHistoryHandler", "showPopup"));
        }
        ActionGroup parentActions = this.createActionGroup(rev, filePath, parents);
        DataContext dataContext = SimpleDataContext.getProjectContext((Project)this.myProject);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Choose parent to compare", parentActions, dataContext, JBPopupFactory.ActionSelectionAid.NUMBERING, true);
        GitDiffFromHistoryHandler.showPopupInBestPosition(popup, event, dataContext);
    }

    private static void showPopupInBestPosition(@NotNull ListPopup popup, @NotNull AnActionEvent event, @NotNull DataContext dataContext) {
        if (popup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "git4idea/history/GitDiffFromHistoryHandler", "showPopupInBestPosition"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/history/GitDiffFromHistoryHandler", "showPopupInBestPosition"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "git4idea/history/GitDiffFromHistoryHandler", "showPopupInBestPosition"));
        }
        if (event.getInputEvent() instanceof MouseEvent) {
            if (!event.getPlace().equals("UpdatePopup")) {
                popup.show(new RelativePoint((MouseEvent)event.getInputEvent()));
            } else {
                popup.showInBestPositionFor(dataContext);
            }
        } else {
            popup.showInBestPositionFor(dataContext);
        }
    }

    @NotNull
    private ActionGroup createActionGroup(@NotNull GitFileRevision rev, @NotNull FilePath filePath, @NotNull Collection<GitFileRevision> parents) {
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "git4idea/history/GitDiffFromHistoryHandler", "createActionGroup"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/history/GitDiffFromHistoryHandler", "createActionGroup"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "git4idea/history/GitDiffFromHistoryHandler", "createActionGroup"));
        }
        ArrayList<AnAction> actions = new ArrayList<AnAction>(2);
        for (GitFileRevision parent : parents) {
            actions.add(this.createParentAction(rev, filePath, parent));
        }
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup((AnAction[])ArrayUtil.toObjectArray(actions, AnAction.class));
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "createActionGroup"));
        }
        return defaultActionGroup;
    }

    @NotNull
    private AnAction createParentAction(@NotNull GitFileRevision rev, @NotNull FilePath filePath, @NotNull GitFileRevision parent) {
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "git4idea/history/GitDiffFromHistoryHandler", "createParentAction"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/history/GitDiffFromHistoryHandler", "createParentAction"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "git4idea/history/GitDiffFromHistoryHandler", "createParentAction"));
        }
        ShowDiffWithParentAction showDiffWithParentAction = new ShowDiffWithParentAction(filePath, rev, parent);
        if (showDiffWithParentAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "createParentAction"));
        }
        return showDiffWithParentAction;
    }

    @NotNull
    private GitFileRevision makeRevisionFromHash(@NotNull FilePath filePath, @NotNull String hash) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/history/GitDiffFromHistoryHandler", "makeRevisionFromHash"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/history/GitDiffFromHistoryHandler", "makeRevisionFromHash"));
        }
        GitFileRevision gitFileRevision = new GitFileRevision(this.myProject, filePath, new GitRevisionNumber(hash));
        if (gitFileRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "makeRevisionFromHash"));
        }
        return gitFileRevision;
    }

    private boolean wasFileTouched(@NotNull GitRepository repository, @NotNull GitFileRevision rev) throws VcsException {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/history/GitDiffFromHistoryHandler", "wasFileTouched"));
        }
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "git4idea/history/GitDiffFromHistoryHandler", "wasFileTouched"));
        }
        GitCommandResult result = this.myGit.show(repository, rev.getHash());
        if (result.success()) {
            return GitDiffFromHistoryHandler.isFilePresentInOutput(repository, rev.getPath(), result.getOutput());
        }
        throw new VcsException(result.getErrorOutputAsJoinedString());
    }

    private static boolean isFilePresentInOutput(@NotNull GitRepository repository, @NotNull FilePath path, @NotNull List<String> output) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/history/GitDiffFromHistoryHandler", "isFilePresentInOutput"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitDiffFromHistoryHandler", "isFilePresentInOutput"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "git4idea/history/GitDiffFromHistoryHandler", "isFilePresentInOutput"));
        }
        String relativePath = GitDiffFromHistoryHandler.getRelativePath(repository, path);
        for (String line : output) {
            if (!line.startsWith("---") && !line.startsWith("+++") || !line.contains(relativePath)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String getRelativePath(@NotNull GitRepository repository, @NotNull FilePath path) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/history/GitDiffFromHistoryHandler", "getRelativePath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitDiffFromHistoryHandler", "getRelativePath"));
        }
        return FileUtil.getRelativePath((String)repository.getRoot().getPath(), (String)path.getPath(), (char)'/');
    }

    @NotNull
    private static String getRevisionDescription(@NotNull GitFileRevision parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "git4idea/history/GitDiffFromHistoryHandler", "getRevisionDescription"));
        }
        String hash = DvcsUtil.getShortHash((String)parent.getHash());
        String message = parent.getCommitMessage();
        if (message != null) {
            int index = StringUtil.indexOfAny((String)message, (String)"\n\r");
            if (index != -1) {
                message = message.substring(0, index) + "...";
            }
            if (message.length() > 40) {
                message = message.substring(0, 35) + "...";
            }
            String string = hash + " - " + message;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "getRevisionDescription"));
            }
            return string;
        }
        String string = hash;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitDiffFromHistoryHandler", "getRevisionDescription"));
        }
        return string;
    }

    private class ShowDiffWithParentAction
    extends DumbAwareAction {
        @NotNull
        private final FilePath myFilePath;
        @NotNull
        private final GitFileRevision myRevision;
        @NotNull
        private final GitFileRevision myParentRevision;

        public ShowDiffWithParentAction(@NotNull FilePath filePath, @NotNull GitFileRevision rev, GitFileRevision parent) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/history/GitDiffFromHistoryHandler$ShowDiffWithParentAction", "<init>"));
            }
            if (rev == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "git4idea/history/GitDiffFromHistoryHandler$ShowDiffWithParentAction", "<init>"));
            }
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "git4idea/history/GitDiffFromHistoryHandler$ShowDiffWithParentAction", "<init>"));
            }
            super(GitDiffFromHistoryHandler.getRevisionDescription(parent), parent.getCommitMessage(), null);
            this.myFilePath = filePath;
            this.myRevision = rev;
            this.myParentRevision = parent;
        }

        public void actionPerformed(AnActionEvent e) {
            GitDiffFromHistoryHandler.this.doShowDiff(this.myFilePath, (VcsFileRevision)this.myParentRevision, (VcsFileRevision)this.myRevision);
        }
    }

    private static class MergeCommitPreCheckInfo {
        private final boolean myWasFileTouched;
        private final Collection<GitFileRevision> myParents;

        private MergeCommitPreCheckInfo(boolean touched, Collection<GitFileRevision> parents) {
            this.myWasFileTouched = touched;
            this.myParents = parents;
        }

        public boolean wasFileTouched() {
            return this.myWasFileTouched;
        }

        public Collection<GitFileRevision> getParents() {
            return this.myParents;
        }
    }
}

