/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast.test.env;

import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.runner.JavaMainMethodProvider;
import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.CoreJavaFileManager;
import com.intellij.core.JavaCoreApplicationEnvironment;
import com.intellij.core.JavaCoreProjectEnvironment;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.psi.FileContextProvider;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.JavaClassSupersImpl;
import com.intellij.psi.impl.PsiElementFinderImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.meta.MetaDataContributor;
import com.intellij.psi.util.JavaClassSupers;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.test.env.AbstractCoreEnvironment;

public class TestCoreEnvironment
extends AbstractCoreEnvironment {
    private static final Object APPLICATION_LOCK = new Object();
    private static volatile JavaCoreApplicationEnvironment sEnvironment = null;
    private final Disposable mDisposable;
    private volatile JavaCoreProjectEnvironment mProjectEnvironment = null;

    public TestCoreEnvironment(Disposable disposable) {
        this.mDisposable = disposable;
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.mDisposable);
    }

    @Override
    public MockProject getProject() {
        JavaCoreProjectEnvironment projectEnvironment = this.getProjectEnvironment();
        if (projectEnvironment == null) {
            return null;
        }
        return projectEnvironment.getProject();
    }

    @Override
    public void addJavaSourceRoot(@NotNull File root) {
        VirtualFileSystem vfs = StandardFileSystems.local();
        try {
            this.addDirectoryToClassPath(vfs, root);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addDirectoryToClassPath(VirtualFileSystem vfs, File root) throws IOException {
        VirtualFile virtualFile = vfs.findFileByPath(root.getCanonicalPath());
        assert (virtualFile != null);
        this.getProjectEnvironment().addSourcesToClasspath(virtualFile);
    }

    @Override
    public void addJar(@NotNull File root) {
        this.getProjectEnvironment().addJarToClassPath(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaCoreProjectEnvironment getProjectEnvironment() {
        if (this.mProjectEnvironment != null) {
            return this.mProjectEnvironment;
        }
        Object object = APPLICATION_LOCK;
        synchronized (object) {
            if (this.mProjectEnvironment != null) {
                return this.mProjectEnvironment;
            }
            JavaCoreApplicationEnvironment coreEnvironment = TestCoreEnvironment.getCoreEnvironment();
            this.mProjectEnvironment = new TestJavaCoreProjectEnvironment(coreEnvironment);
            Disposer.register((Disposable)this.mDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    TestCoreEnvironment.this.mProjectEnvironment = null;
                }
            });
            return this.mProjectEnvironment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JavaCoreApplicationEnvironment getCoreEnvironment() {
        if (sEnvironment != null) {
            return sEnvironment;
        }
        Object object = APPLICATION_LOCK;
        synchronized (object) {
            if (sEnvironment != null) {
                return sEnvironment;
            }
            Disposable parentDisposable = Disposer.newDisposable();
            Extensions.cleanRootArea((Disposable)parentDisposable);
            TestCoreEnvironment.registerAppExtensionPoints();
            JavaCoreApplicationEnvironment coreEnvironment = new JavaCoreApplicationEnvironment(parentDisposable);
            coreEnvironment.registerApplicationService(JavaClassSupers.class, (Object)new JavaClassSupersImpl());
            sEnvironment = coreEnvironment;
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void dispose() {
                    Object object = APPLICATION_LOCK;
                    synchronized (object) {
                        JavaCoreApplicationEnvironment environment = sEnvironment;
                        sEnvironment = null;
                        Disposer.dispose((Disposable)environment.getParentDisposable());
                        ZipHandler.clearFileAccessorCache();
                    }
                }
            });
            return sEnvironment;
        }
    }

    private static void registerAppExtensionPoints() {
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)Extensions.getRootArea(), (String)"com.intellij.filetype.stubBuilder", FileTypeExtensionPoint.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)Extensions.getRootArea(), (ExtensionPointName)FileContextProvider.EP_NAME, FileContextProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)Extensions.getRootArea(), (ExtensionPointName)MetaDataContributor.EP_NAME, MetaDataContributor.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)Extensions.getRootArea(), (ExtensionPointName)PsiAugmentProvider.EP_NAME, PsiAugmentProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)Extensions.getRootArea(), (ExtensionPointName)JavaMainMethodProvider.EP_NAME, JavaMainMethodProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)Extensions.getRootArea(), (ExtensionPointName)ContainerProvider.EP_NAME, ContainerProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)Extensions.getRootArea(), (ExtensionPointName)ClsCustomNavigationPolicy.EP_NAME, ClsCustomNavigationPolicy.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)Extensions.getRootArea(), (ExtensionPointName)ClassFileDecompilers.EP_NAME, ClassFileDecompilers.Decompiler.class);
    }

    private class TestJavaCoreProjectEnvironment
    extends JavaCoreProjectEnvironment {
        TestJavaCoreProjectEnvironment(JavaCoreApplicationEnvironment coreEnvironment) {
            super(TestCoreEnvironment.this.mDisposable, (CoreApplicationEnvironment)coreEnvironment);
            this.registerProjectExtensions();
        }

        protected void preregisterServices() {
            this.registerProjectExtensionPoints();
        }

        private void registerProjectExtensionPoints() {
            ExtensionsArea area = Extensions.getArea((AreaInstance)this.myProject);
            CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)area, (ExtensionPointName)PsiTreeChangePreprocessor.EP_NAME, PsiTreeChangePreprocessor.class);
            CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)area, (ExtensionPointName)PsiElementFinder.EP_NAME, PsiElementFinder.class);
        }

        private void registerProjectExtensions() {
            ExtensionsArea area = Extensions.getArea((AreaInstance)this.myProject);
            this.myProject.registerService(CoreJavaFileManager.class, (Object)((CoreJavaFileManager)ServiceManager.getService((Project)this.myProject, JavaFileManager.class)));
            area.getExtensionPoint(PsiElementFinder.EP_NAME).registerExtension((Object)new PsiElementFinderImpl((Project)this.myProject, (JavaFileManager)ServiceManager.getService((Project)this.myProject, JavaFileManager.class)));
        }
    }
}

