/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.Range;

public class AnimatedTimeRange
implements Animatable {
    private final Range mRange;
    private boolean mShift;
    private long mOffset;

    public AnimatedTimeRange(Range range, long offset) {
        this.mRange = range;
        this.mOffset = offset;
    }

    public void setShift(boolean shift) {
        this.mShift = shift;
    }

    @Override
    public void animate(float frameLength) {
        long now = System.currentTimeMillis() - this.mOffset;
        double min = this.mRange.getMin();
        double max = this.mRange.getMax();
        this.mRange.setMax(now);
        if (this.mShift) {
            this.mRange.setMin(min + ((double)now - max));
        }
    }
}

