/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.LegendRenderData;
import com.android.tools.adtui.model.ReportingSeries;
import com.intellij.ui.components.JBLabel;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;

public class LegendComponent
extends AnimatedComponent {
    private static final int LINE_THICKNESS = 4;
    private static final int ICON_WIDTH = 16;
    private static final int ICON_PADDING = 2;
    private static final int LABEL_PADDING = 8;
    private int mFrequencyMillis;
    private List<JLabel> mLabelsToDraw;
    private long mLastUpdate;
    private List<LegendRenderData> mLegendRenderData;
    private Orientation mOrientation;

    public LegendComponent(Orientation orientation, int frequencyMillis) {
        this.mFrequencyMillis = frequencyMillis;
        this.mOrientation = orientation;
        this.mLastUpdate = 0L;
    }

    public void setLegendData(List<LegendRenderData> data) {
        this.mLegendRenderData = new ArrayList<LegendRenderData>(data);
        this.mLabelsToDraw = new ArrayList<JLabel>(this.mLegendRenderData.size());
        for (LegendRenderData initialData : this.mLegendRenderData) {
            JBLabel label = new JBLabel(initialData.getLabel());
            label.setFont((Font)AdtUiUtils.DEFAULT_FONT);
            this.mLabelsToDraw.add((JLabel)label);
        }
    }

    @Override
    protected void updateData() {
        long now = System.currentTimeMillis();
        if (now - this.mLastUpdate > (long)this.mFrequencyMillis) {
            this.mLastUpdate = now;
            for (int i = 0; i < this.mLegendRenderData.size(); ++i) {
                ReportingSeries.ReportingData report;
                LegendRenderData data = this.mLegendRenderData.get(i);
                ReportingSeries series = data.getSeries();
                JLabel label = this.mLabelsToDraw.get(i);
                Dimension preferredSize = label.getPreferredSize();
                label.setBounds(0, 0, preferredSize.width, preferredSize.height);
                if (series == null || (report = series.getLatestReportingData()) == null) continue;
                label.setText(String.format("%s: %s", series.getLabel(), report.formattedYData));
            }
            Dimension newSize = this.getLegendPreferredSize();
            if (newSize != this.getPreferredSize()) {
                this.setPreferredSize(newSize);
                this.revalidate();
            }
        }
    }

    @Override
    protected void draw(Graphics2D g2d) {
        for (int i = 0; i < this.mLegendRenderData.size(); ++i) {
            LegendRenderData data = this.mLegendRenderData.get(i);
            JLabel label = this.mLabelsToDraw.get(i);
            Dimension preferredSize = label.getPreferredSize();
            int xOffset = 0;
            if (data.getIcon() == LegendRenderData.IconType.BOX) {
                g2d.setColor(data.getColor());
                g2d.fillRect(xOffset, 0, 16, 16);
                xOffset = 18;
            } else if (data.getIcon() == LegendRenderData.IconType.LINE) {
                g2d.setColor(data.getColor());
                Stroke defaultStroke = g2d.getStroke();
                g2d.setStroke(new BasicStroke(4.0f));
                g2d.drawLine(xOffset, preferredSize.height / 2, xOffset + 16, preferredSize.height / 2);
                g2d.setStroke(defaultStroke);
                xOffset = 18;
            }
            g2d.translate(xOffset, 0);
            label.paint(g2d);
            if (this.mOrientation == Orientation.HORIZONTAL) {
                g2d.translate(preferredSize.width + 8, 0);
                continue;
            }
            if (this.mOrientation != Orientation.VERTICAL) continue;
            g2d.translate(-xOffset, 0);
            g2d.translate(0, preferredSize.height + 8);
        }
    }

    private Dimension getLegendPreferredSize() {
        int totalWidth = 0;
        int totalHeight = 0;
        int iconPaddedSize = 26;
        for (JLabel label : this.mLabelsToDraw) {
            Dimension size = label.getPreferredSize();
            if (this.mOrientation == Orientation.HORIZONTAL) {
                totalWidth += iconPaddedSize + size.width;
                if (totalHeight >= size.height) continue;
                totalHeight = size.height;
                continue;
            }
            if (this.mOrientation != Orientation.VERTICAL) continue;
            totalHeight += iconPaddedSize;
            if (totalWidth >= size.width + iconPaddedSize) continue;
            totalWidth = size.width + iconPaddedSize;
        }
        return new Dimension(totalWidth, totalHeight);
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

