/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.CircularArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class TimelineData {
    public static final Logger LOG = Logger.getLogger(TimelineData.class.getName());
    private final SampleTransform mTransform;
    private long mStart;
    public final List<Stream> mStreams;
    private final List<SampleInfo> mSampleInfos;
    private final int mCapacity;

    public TimelineData(int streams, int capacity) {
        this(streams, capacity, new DirectTransform());
    }

    public TimelineData(int streams, int capacity, @NotNull SampleTransform transform) {
        if (transform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transform", "com/android/tools/adtui/TimelineData", "<init>"));
        }
        this.mCapacity = capacity;
        this.mSampleInfos = new CircularArrayList<SampleInfo>(capacity);
        this.mTransform = transform;
        this.mTransform.init(streams);
        this.mStreams = new ArrayList<Stream>();
        this.addDefaultStreams(streams);
        this.clear();
    }

    private void addDefaultStreams(int streams) {
        for (int i = 0; i < streams; ++i) {
            this.addStream("Stream " + i);
        }
    }

    public synchronized long getStartTime() {
        return this.mStart;
    }

    public int getStreamCount() {
        return this.mStreams.size();
    }

    public Stream getStream(int index) {
        return this.mStreams.get(index);
    }

    public SampleInfo getSampleInfo(int index) {
        return this.mSampleInfos.get(index);
    }

    public synchronized void add(long timeMills, int type, float ... values) {
        float timeFromStart = (float)(timeMills - this.mStart) / 1000.0f;
        for (Sample sample : this.mTransform.transform(this, timeFromStart, type, values)) {
            this.add(sample);
        }
    }

    public synchronized void addStream(@NotNull String id) {
        Stream stream2;
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/adtui/TimelineData", "addStream"));
        }
        for (Stream stream2 : this.mStreams) {
            assert (!id.equals(stream2.getId())) : String.format("Attempt to add duplicate stream of id %1$s", id);
        }
        int startSize = this.mSampleInfos.size();
        stream2 = new Stream(id, this.mCapacity, startSize);
        this.mStreams.add(stream2);
        this.mTransform.add(this.mStreams.size() - 1);
    }

    public synchronized void addStreams(@NotNull List<String> ids) {
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/android/tools/adtui/TimelineData", "addStreams"));
        }
        for (String id : ids) {
            this.addStream(id);
        }
    }

    public synchronized void removeStream(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/adtui/TimelineData", "removeStream"));
        }
        int removeIndex = this.getStreamIndex(id);
        if (removeIndex >= 0) {
            this.mStreams.remove(removeIndex);
            this.mTransform.remove(removeIndex);
        }
    }

    private int getStreamIndex(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/adtui/TimelineData", "getStreamIndex"));
        }
        int indexToReturn = -1;
        for (int i = 0; i < this.mStreams.size(); ++i) {
            if (!id.equals(this.mStreams.get(i).getId())) continue;
            indexToReturn = i;
            break;
        }
        if (indexToReturn == -1) {
            LOG.warning(String.format("Attempt to remove non-existing stream with id %1$s", id));
        }
        return indexToReturn;
    }

    public synchronized void removeStreams(@NotNull List<String> ids) {
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/android/tools/adtui/TimelineData", "removeStreams"));
        }
        for (String id : ids) {
            this.removeStream(id);
        }
    }

    private void add(Sample sample) {
        float[] values = sample.values;
        assert (values.length == this.mStreams.size());
        for (int i = 0; i < this.mStreams.size(); ++i) {
            this.mStreams.get(i).add(values[i]);
        }
        this.mSampleInfos.add(new SampleInfo(sample.time, sample.type));
    }

    public synchronized void clear() {
        this.mSampleInfos.clear();
        this.mTransform.reset();
        for (Stream stream : this.mStreams) {
            stream.reset();
        }
        this.mStart = System.currentTimeMillis();
    }

    public int size() {
        return this.mSampleInfos.size();
    }

    @Deprecated
    public Sample get(int index) {
        SampleInfo info = this.mSampleInfos.get(index);
        float[] values = new float[this.mStreams.size()];
        for (int i = 0; i < this.mStreams.size(); ++i) {
            values[i] = this.mStreams.get(i).get(index);
        }
        return new Sample(info.time, info.type, values);
    }

    public synchronized float getEndTime() {
        return this.size() > 0 ? (float)(System.currentTimeMillis() - this.mStart) / 1000.0f : 0.0f;
    }

    public static final class AreaTransform
    extends SampleTransform {
        private float[] mAreaSums;
        private float[] mLastValues;

        @Override
        void init(int streams) {
            this.mAreaSums = new float[streams];
            this.mLastValues = new float[streams];
        }

        @Override
        public void reset() {
            for (int i = 0; i < this.mAreaSums.length; ++i) {
                this.mAreaSums[i] = 0.0f;
                this.mLastValues[i] = 0.0f;
            }
        }

        @Override
        void add(int streamIndex) {
            if (streamIndex < this.mAreaSums.length) {
                return;
            }
            this.mAreaSums = Arrays.copyOf(this.mAreaSums, streamIndex + 1);
            this.mLastValues = Arrays.copyOf(this.mLastValues, streamIndex + 1);
        }

        @Override
        void remove(int streamIndex) {
            this.mAreaSums = AreaTransform.removeAndShrinkArray(this.mAreaSums, streamIndex);
            this.mLastValues = AreaTransform.removeAndShrinkArray(this.mLastValues, streamIndex);
        }

        private static float[] removeAndShrinkArray(float[] src, int removeIndex) {
            float[] array = Arrays.copyOf(src, src.length - 1);
            System.arraycopy(src, removeIndex + 1, array, removeIndex, array.length - removeIndex);
            return array;
        }

        @Override
        public List<Sample> transform(TimelineData data, float time, int type, float ... areaSums) {
            assert (this.mAreaSums.length == areaSums.length);
            float[] area = new float[this.mAreaSums.length];
            for (int i = 0; i < areaSums.length; ++i) {
                area[i] = areaSums[i] - this.mAreaSums[i];
                this.mAreaSums[i] = areaSums[i];
            }
            float lastSampleTime = data.size() > 0 ? data.getSampleInfo((int)(data.size() - 1)).time : 0.0f;
            List<Sample> samples = this.convertAreasToSamples(time, type, area, lastSampleTime);
            float[] lastValues = samples.get((int)(samples.size() - 1)).values;
            System.arraycopy(lastValues, 0, this.mLastValues, 0, lastValues.length);
            return samples;
        }

        private List<Sample> convertAreasToSamples(float time, int type, float[] area, float lastTime) {
            float maxInterval = time - lastTime;
            int streamSize = area.length;
            float[] nonZeroIntervalsForStreams = new float[streamSize];
            float[] endValuesForStreams = new float[streamSize];
            for (int i = 0; i < streamSize; ++i) {
                if (Math.abs(this.mLastValues[i]) * maxInterval / 2.0f < Math.abs(area[i])) {
                    nonZeroIntervalsForStreams[i] = maxInterval;
                    endValuesForStreams[i] = area[i] * 2.0f / maxInterval - this.mLastValues[i];
                    continue;
                }
                if (area[i] == 0.0f) {
                    nonZeroIntervalsForStreams[i] = 0.0f;
                    endValuesForStreams[i] = 0.0f;
                    continue;
                }
                nonZeroIntervalsForStreams[i] = area[i] * 2.0f / this.mLastValues[i];
                endValuesForStreams[i] = 0.0f;
            }
            float[] ascendingIntervals = Arrays.copyOf(nonZeroIntervalsForStreams, streamSize);
            Arrays.sort(ascendingIntervals);
            ArrayList<Sample> sampleList = new ArrayList<Sample>();
            for (float interval : ascendingIntervals) {
                float[] sampleValues = new float[streamSize];
                for (int j = 0; j < streamSize; ++j) {
                    sampleValues[j] = nonZeroIntervalsForStreams[j] < interval || nonZeroIntervalsForStreams[j] == 0.0f ? 0.0f : this.mLastValues[j] - (this.mLastValues[j] - endValuesForStreams[j]) * interval / nonZeroIntervalsForStreams[j];
                }
                sampleList.add(new Sample(interval + lastTime, type, sampleValues));
                if (interval == maxInterval) break;
            }
            if (ascendingIntervals[streamSize - 1] < maxInterval) {
                sampleList.add(new Sample(time, type, new float[streamSize]));
            }
            return sampleList;
        }
    }

    public static final class DirectTransform
    extends SampleTransform {
        @Override
        public List<Sample> transform(TimelineData data, float time, int type, float ... values) {
            Sample sample = new Sample(time, type, values);
            return Collections.singletonList(sample);
        }
    }

    public static abstract class SampleTransform {
        void init(int streams) {
        }

        void reset() {
        }

        abstract List<Sample> transform(TimelineData var1, float var2, int var3, float ... var4);

        void add(int streamIndex) {
        }

        void remove(int streamIndex) {
        }
    }

    @Deprecated
    public static class Sample {
        public final float time;
        public final float[] values;
        public final int type;

        public Sample(float time, int type, @NotNull float[] values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/android/tools/adtui/TimelineData$Sample", "<init>"));
            }
            this.time = time;
            this.values = values;
            this.type = type;
        }
    }

    public static class SampleInfo {
        public final float time;
        public final int type;

        public SampleInfo(float time, int type) {
            this.time = time;
            this.type = type;
        }
    }

    public static class Stream {
        public final String mId;
        public final float[] mCircularValues;
        private int mStartIndex;
        private int mValueSize;

        public Stream(@NotNull String id, int maxValueSize, int startSize) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/adtui/TimelineData$Stream", "<init>"));
            }
            this.mId = id;
            this.mCircularValues = new float[maxValueSize];
            this.mStartIndex = 0;
            this.mValueSize = startSize;
        }

        public int getValueSize() {
            return this.mValueSize;
        }

        public void add(float value) {
            if (this.mValueSize == this.mCircularValues.length) {
                this.mCircularValues[this.mStartIndex] = value;
                this.mStartIndex = (this.mStartIndex + 1) % this.mValueSize;
            } else {
                this.mCircularValues[this.mValueSize] = value;
                ++this.mValueSize;
            }
        }

        public String getId() {
            return this.mId;
        }

        public float get(int index) {
            assert (index >= 0 && index < this.mValueSize) : String.format("Index %1$d out of value length bound %2$d", index, this.mValueSize);
            return this.mCircularValues[(this.mStartIndex + index) % this.mValueSize];
        }

        public void reset() {
            this.mStartIndex = 0;
            this.mValueSize = 0;
        }
    }
}

