/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAttributeContainer
implements AttributeContainerInternal {
    private final AttributeContainerInternal parent;
    private Map<Attribute<?>, Object> attributes;

    public DefaultAttributeContainer() {
        this.parent = null;
    }

    public DefaultAttributeContainer(AttributeContainerInternal parent) {
        this.parent = parent;
    }

    public String toString() {
        return this.asImmutable().toString();
    }

    private void ensureAttributes() {
        if (this.attributes == null) {
            this.attributes = Maps.newHashMap();
        }
    }

    @Override
    public Set<Attribute<?>> keySet() {
        if (this.attributes == null) {
            if (this.parent == null) {
                return Collections.emptySet();
            }
            return this.parent.keySet();
        }
        return this.attributes.keySet();
    }

    @Override
    public <T> AttributeContainer attribute(Attribute<T> key, T value) {
        DefaultAttributeContainer.assertAttributeConstraints(value, key);
        this.ensureAttributes();
        this.checkInsertionAllowed(key);
        this.attributes.put(key, value);
        return this;
    }

    private <T> void checkInsertionAllowed(Attribute<T> key) {
        for (Attribute<?> attribute : this.attributes.keySet()) {
            String name = key.getName();
            if (!attribute.getName().equals(name) || attribute.getType() == key.getType()) continue;
            throw new IllegalArgumentException("Cannot have two attributes with the same name but different types. This container already has an attribute named '" + name + "' of type '" + attribute.getType().getName() + "' and you are trying to store another one of type '" + key.getType().getName() + "'");
        }
    }

    private static void assertAttributeConstraints(Object value, Attribute<?> attribute) {
        if (value == null) {
            throw new IllegalArgumentException("Setting null as an attribute value is not allowed");
        }
        if (!attribute.getType().isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Unexpected type for attribute '" + attribute.getName() + "'. Expected " + attribute.getType().getName() + " but was:" + value.getClass().getName());
        }
    }

    @Override
    public <T> T getAttribute(Attribute<T> key) {
        T value;
        if (this.attributes != null && (value = key.getType().cast(this.attributes.get(key))) != null) {
            return value;
        }
        if (this.parent != null) {
            return this.parent.getAttribute(key);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return !(this.attributes != null && !this.attributes.isEmpty() || this.parent != null && !this.parent.isEmpty());
    }

    @Override
    public boolean contains(Attribute<?> key) {
        return this.attributes != null && this.attributes.containsKey(key) || this.parent != null && this.parent.contains(key);
    }

    @Override
    public AttributeContainerInternal asImmutable() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        if (this.parent == null) {
            return new ImmutableAttributes(this.attributes);
        }
        return this.copy().asImmutable();
    }

    @Override
    public AttributeContainerInternal copy() {
        if (this.isEmpty()) {
            return new DefaultAttributeContainer();
        }
        AttributeContainerInternal copy = this.parent != null ? this.parent.copy() : new DefaultAttributeContainer();
        if (this.attributes != null) {
            for (Map.Entry<Attribute<?>, Object> entry : this.attributes.entrySet()) {
                Attribute attribute = (Attribute)Cast.uncheckedCast(entry.getKey());
                copy.attribute(attribute, entry.getValue());
            }
        }
        return copy;
    }

    @Override
    public AttributeContainer getAttributes() {
        return this;
    }
}

