/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.hash.HashCode;
import groovy.lang.Script;
import org.codehaus.groovy.ast.ClassNode;
import org.gradle.api.Action;
import org.gradle.api.internal.hash.FileHasher;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.CompileOperation;
import org.gradle.groovy.scripts.internal.CompiledScript;
import org.gradle.groovy.scripts.internal.ScriptCacheKey;
import org.gradle.groovy.scripts.internal.ScriptClassCompiler;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossBuildInMemoryCachingScriptClassCache {
    private final Cache<ScriptCacheKey, CachedCompiledScript> cachedCompiledScripts = CacheBuilder.newBuilder().maximumSize(100L).recordStats().build();
    private final FileHasher hasher;

    public CrossBuildInMemoryCachingScriptClassCache(FileHasher hasher) {
        this.hasher = hasher;
    }

    public <T extends Script, M> CompiledScript<T, M> getOrCompile(ScriptSource source, ClassLoader classLoader, ClassLoaderId classLoaderId, CompileOperation<M> operation, Class<T> scriptBaseClass, Action<? super ClassNode> verifier, ScriptClassCompiler delegate) {
        ScriptCacheKey key = new ScriptCacheKey(source.getClassName(), classLoader, operation.getId());
        CachedCompiledScript cached = (CachedCompiledScript)this.cachedCompiledScripts.getIfPresent((Object)key);
        HashCode hash = this.hasher.hash(source.getResource());
        if (cached != null && hash.equals((Object)cached.hash)) {
            return (CompiledScript)Cast.uncheckedCast((Object)cached.compiledScript);
        }
        CompiledScript<T, M> compiledScript = delegate.compile(source, classLoader, classLoaderId, operation, scriptBaseClass, verifier);
        this.cachedCompiledScripts.put((Object)key, (Object)new CachedCompiledScript(hash, compiledScript));
        return compiledScript;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedCompiledScript {
        private final HashCode hash;
        private final CompiledScript<?, ?> compiledScript;

        private CachedCompiledScript(HashCode hash, CompiledScript<?, ?> compiledScript) {
            this.hash = hash;
            this.compiledScript = compiledScript;
        }
    }
}

