/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2MetadataCompilerArguments;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.CoroutineSupport;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.TargetPlatformKind;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002R(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR(\u0010\u001c\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u0007\"\u0004\b\u001e\u0010\tR$\u0010 \u001a\u00020\u001f2\u0006\u0010\u0003\u001a\u00020\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0017\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\"\"\u0004\b+\u0010$\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/config/KotlinFacetSettings;", "", "()V", "value", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "apiLevel", "getApiLevel", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "setApiLevel", "(Lorg/jetbrains/kotlin/config/LanguageVersion;)V", "compilerArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "getCompilerArguments", "()Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "setCompilerArguments", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;)V", "compilerSettings", "Lorg/jetbrains/kotlin/config/CompilerSettings;", "getCompilerSettings", "()Lorg/jetbrains/kotlin/config/CompilerSettings;", "setCompilerSettings", "(Lorg/jetbrains/kotlin/config/CompilerSettings;)V", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "coroutineSupport", "getCoroutineSupport", "()Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "setCoroutineSupport", "(Lorg/jetbrains/kotlin/config/LanguageFeature$State;)V", "languageLevel", "getLanguageLevel", "setLanguageLevel", "", "skipMetadataVersionCheck", "getSkipMetadataVersionCheck", "()Z", "setSkipMetadataVersionCheck", "(Z)V", "targetPlatformKind", "Lorg/jetbrains/kotlin/config/TargetPlatformKind;", "getTargetPlatformKind", "()Lorg/jetbrains/kotlin/config/TargetPlatformKind;", "useProjectSettings", "getUseProjectSettings", "setUseProjectSettings", "Companion", "idea-jps-common"})
public final class KotlinFacetSettings {
    private boolean useProjectSettings = true;
    @Nullable
    private CommonCompilerArguments compilerArguments;
    @Nullable
    private CompilerSettings compilerSettings;
    private static final int CURRENT_VERSION = 2;
    private static final int DEFAULT_VERSION = 0;
    public static final Companion Companion = new Companion(null);

    public final boolean getUseProjectSettings() {
        return this.useProjectSettings;
    }

    public final void setUseProjectSettings(boolean bl) {
        this.useProjectSettings = bl;
    }

    @Nullable
    public final CommonCompilerArguments getCompilerArguments() {
        return this.compilerArguments;
    }

    public final void setCompilerArguments(@Nullable CommonCompilerArguments commonCompilerArguments) {
        this.compilerArguments = commonCompilerArguments;
    }

    @Nullable
    public final CompilerSettings getCompilerSettings() {
        return this.compilerSettings;
    }

    public final void setCompilerSettings(@Nullable CompilerSettings compilerSettings) {
        this.compilerSettings = compilerSettings;
    }

    @Nullable
    public final LanguageVersion getLanguageLevel() {
        LanguageVersion languageVersion;
        Object object = this.compilerArguments;
        if (object != null && (object = ((CommonCompilerArguments)object).languageVersion) != null) {
            Object object2;
            Object it = object2 = object;
            languageVersion = LanguageVersion.Companion.fromFullVersionString((String)it);
        } else {
            languageVersion = null;
        }
        return languageVersion;
    }

    public final void setLanguageLevel(@Nullable LanguageVersion value) {
        if (this.compilerArguments == null) {
            Intrinsics.throwNpe();
        }
        LanguageVersion languageVersion = value;
        this.compilerArguments.languageVersion = languageVersion != null ? languageVersion.getVersionString() : null;
    }

    @Nullable
    public final LanguageVersion getApiLevel() {
        LanguageVersion languageVersion;
        Object object = this.compilerArguments;
        if (object != null && (object = ((CommonCompilerArguments)object).apiVersion) != null) {
            Object object2;
            Object it = object2 = object;
            languageVersion = LanguageVersion.Companion.fromFullVersionString((String)it);
        } else {
            languageVersion = null;
        }
        return languageVersion;
    }

    public final void setApiLevel(@Nullable LanguageVersion value) {
        if (this.compilerArguments == null) {
            Intrinsics.throwNpe();
        }
        LanguageVersion languageVersion = value;
        this.compilerArguments.apiVersion = languageVersion != null ? languageVersion.getVersionString() : null;
    }

    @Nullable
    public final TargetPlatformKind<?> getTargetPlatformKind() {
        TargetPlatformKind targetPlatformKind;
        CommonCompilerArguments commonCompilerArguments = this.compilerArguments;
        if (commonCompilerArguments != null) {
            CommonCompilerArguments commonCompilerArguments2 = commonCompilerArguments;
            CommonCompilerArguments it = commonCompilerArguments2;
            CommonCompilerArguments commonCompilerArguments3 = it;
            if (commonCompilerArguments3 instanceof K2JVMCompilerArguments) {
                Object v2;
                block6: {
                    String string = ((K2JVMCompilerArguments)it).jvmTarget;
                    if (string == null) {
                        string = JvmTarget.DEFAULT.getDescription();
                    }
                    String jvmTarget = string;
                    Iterable $receiver$iv = TargetPlatformKind.Jvm.Companion.getJVM_PLATFORMS();
                    for (Object element$iv : $receiver$iv) {
                        TargetPlatformKind.Jvm it2 = (TargetPlatformKind.Jvm)element$iv;
                        if (!(((JvmTarget)it2.getVersion()).getDescription().compareTo(jvmTarget) >= 0)) continue;
                        v2 = element$iv;
                        break block6;
                    }
                    v2 = null;
                }
                targetPlatformKind = v2;
            } else {
                targetPlatformKind = commonCompilerArguments3 instanceof K2JSCompilerArguments ? (TargetPlatformKind)TargetPlatformKind.JavaScript.INSTANCE : (commonCompilerArguments3 instanceof K2MetadataCompilerArguments ? (TargetPlatformKind)TargetPlatformKind.Common.INSTANCE : null);
            }
        } else {
            targetPlatformKind = null;
        }
        return targetPlatformKind;
    }

    @NotNull
    public final LanguageFeature.State getCoroutineSupport() {
        LanguageVersion languageVersion = this.getLanguageLevel();
        if (languageVersion == null) {
            return LanguageFeature.Coroutines.getDefaultState();
        }
        LanguageVersion languageVersion2 = languageVersion;
        LanguageVersion languageVersion3 = LanguageFeature.Coroutines.getSinceVersion();
        if (languageVersion3 == null) {
            Intrinsics.throwNpe();
        }
        if (languageVersion2.compareTo((Enum)languageVersion3) < 0) {
            return LanguageFeature.State.DISABLED;
        }
        return CoroutineSupport.byCompilerArguments(this.compilerArguments);
    }

    public final void setCoroutineSupport(@NotNull LanguageFeature.State value) {
        CommonCompilerArguments commonCompilerArguments;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        CommonCompilerArguments commonCompilerArguments2 = this.compilerArguments;
        if (commonCompilerArguments2 == null) {
            Intrinsics.throwNpe();
        }
        CommonCompilerArguments $receiver = commonCompilerArguments = commonCompilerArguments2;
        $receiver.coroutinesEnable = Intrinsics.areEqual((Object)value, (Object)LanguageFeature.State.ENABLED);
        $receiver.coroutinesWarn = Intrinsics.areEqual((Object)value, (Object)LanguageFeature.State.ENABLED_WITH_WARNING);
        $receiver.coroutinesError = Intrinsics.areEqual((Object)value, (Object)LanguageFeature.State.ENABLED_WITH_ERROR) || Intrinsics.areEqual((Object)value, (Object)LanguageFeature.State.DISABLED);
    }

    public final boolean getSkipMetadataVersionCheck() {
        CommonCompilerArguments commonCompilerArguments = this.compilerArguments;
        return Intrinsics.areEqual((Object)(commonCompilerArguments != null ? Boolean.valueOf(commonCompilerArguments.skipMetadataVersionCheck) : null), (Object)true);
    }

    public final void setSkipMetadataVersionCheck(boolean value) {
        if (this.compilerArguments == null) {
            Intrinsics.throwNpe();
        }
        this.compilerArguments.skipMetadataVersionCheck = value;
    }

    static {
        CURRENT_VERSION = 2;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/config/KotlinFacetSettings$Companion;", "", "()V", "CURRENT_VERSION", "", "getCURRENT_VERSION", "()I", "DEFAULT_VERSION", "getDEFAULT_VERSION", "idea-jps-common"})
    public static final class Companion {
        public final int getCURRENT_VERSION() {
            return CURRENT_VERSION;
        }

        public final int getDEFAULT_VERSION() {
            return DEFAULT_VERSION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

