/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.build.GeneratedFilesKt;
import org.jetbrains.kotlin.build.GeneratedJvmClass;
import org.jetbrains.kotlin.build.JvmBuildMetaInfo;
import org.jetbrains.kotlin.build.JvmBuildMetaInfoKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollectorImpl;
import org.jetbrains.kotlin.compilerRunner.SimpleOutputItem;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.incremental.CacheVersion;
import org.jetbrains.kotlin.incremental.CompilationResult;
import org.jetbrains.kotlin.incremental.IncrementalCacheImpl;
import org.jetbrains.kotlin.incremental.IncrementalCompilationComponentsImpl;
import org.jetbrains.kotlin.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.jps.JpsKotlinCompilerSettings;
import org.jetbrains.kotlin.jps.build.FSOperationsHelper;
import org.jetbrains.kotlin.jps.build.HasKotlinMarker;
import org.jetbrains.kotlin.jps.build.JpsJsModuleUtils;
import org.jetbrains.kotlin.jps.build.JpsUtils;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinBuilder$MessageCollectorAdapter$WhenMappings;
import org.jetbrains.kotlin.jps.build.KotlinBuilder$WhenMappings;
import org.jetbrains.kotlin.jps.build.KotlinBuilderKt;
import org.jetbrains.kotlin.jps.build.KotlinBuilderModuleScriptGenerator;
import org.jetbrains.kotlin.jps.build.KotlinJpsCompilerArgumentsProvider;
import org.jetbrains.kotlin.jps.build.KotlinSourceFileCollector;
import org.jetbrains.kotlin.jps.build.RebuildAfterCacheVersionChangeMarker;
import org.jetbrains.kotlin.jps.build.TeamcityStatisticsLogger;
import org.jetbrains.kotlin.jps.build.TestingContext;
import org.jetbrains.kotlin.jps.build.TestingContextKt;
import org.jetbrains.kotlin.jps.incremental.CacheVersionProvider;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCacheImpl;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCacheImplKt;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorage;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorageProvider;
import org.jetbrains.kotlin.jps.incremental.KotlinDataContainerTarget;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.ModulesUtilKt;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.progress.CompilationCanceledException;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.utils.JsLibraryUtils;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.PathUtil;
import org.jetbrains.org.objectweb.asm.ClassReader;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 S2\u00020\u0001:\u0002STB\u0005\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J4\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010 \u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010!\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J*\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J`\u0010+\u001a\u0004\u0018\u00010$2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010'\u001a\u00020(2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020-0/H\u0002J\u0010\u00100\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u00101\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*H\u0002J4\u00102\u001a\u00020(2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u000205042\u0006\u00106\u001a\u0002072\u0006\u0010\f\u001a\u00020\r2\u0006\u00108\u001a\u000209H\u0002JD\u0010:\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u00108\u001a\u0002092\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0088\u0001\u0010;\u001a\u0004\u0018\u00010$2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010'\u001a\u00020(2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020-0/2\u0016\u00103\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030<042\u0006\u00108\u001a\u0002092\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010=\u001a\u0012\u0012\u0004\u0012\u00020?0>j\b\u0012\u0004\u0012\u00020?`@H\u0016J$\u0010A\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120C0B2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010D\u001a\u00020EH\u0002J\b\u0010F\u001a\u00020?H\u0016J$\u0010G\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010H\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120C0BH\u0002J \u0010I\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&H\u0002Jp\u0010J\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010K\u001a\u00020L2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00120\u001a2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020-0/2\u0012\u0010M\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120N0B2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020O04H\u0002J8\u0010P\u001a\u00020Q2\u0006\u0010K\u001a\u00020L2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020O042\u0012\u0010H\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120C0BH\u0002JH\u0010R\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00106\u001a\u0002072\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00120\u001a2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020-0/H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder;", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder;", "()V", "statisticsLogger", "Lorg/jetbrains/kotlin/jps/build/TeamcityStatisticsLogger;", "applyActionsOnCacheVersionChange", "", "actions", "", "Lorg/jetbrains/kotlin/incremental/CacheVersion$Action;", "cacheVersionsProvider", "Lorg/jetbrains/kotlin/jps/incremental/CacheVersionProvider;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "dataManager", "Lorg/jetbrains/jps/incremental/storage/BuildDataManager;", "targets", "", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "fsOperations", "Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper;", "build", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$ExitCode;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "dirtyFilesHolder", "Lorg/jetbrains/jps/builders/DirtyFilesHolder;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "outputConsumer", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$OutputConsumer;", "buildFinished", "buildStarted", "checkCachesVersions", "chunkBuildFinished", "chunkBuildStarted", "compileToJs", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;", "commonArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "environment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "project", "Lorg/jetbrains/jps/model/JpsProject;", "compileToJvm", "allCompiledFiles", "Ljava/io/File;", "filesToCompile", "Lcom/intellij/util/containers/MultiMap;", "compilerArgumentsForChunk", "copyJsLibraryFilesIfNeeded", "createCompileEnvironment", "incrementalCaches", "", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCache;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "messageCollector", "Lorg/jetbrains/kotlin/jps/build/KotlinBuilder$MessageCollectorAdapter;", "doBuild", "doCompileModuleChunk", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl;", "getCompilableFileExtensions", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getGeneratedFiles", "", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "outputItemCollector", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollectorImpl;", "getPresentableName", "registerOutputItems", "generatedFiles", "saveVersions", "updateJavaMappings", "compilationErrors", "", "generatedClasses", "Lorg/jetbrains/kotlin/build/GeneratedJvmClass;", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCacheImpl;", "updateKotlinIncrementalCache", "Lorg/jetbrains/kotlin/incremental/CompilationResult;", "updateLookupStorage", "Companion", "MessageCollectorAdapter", "jps-plugin"})
public final class KotlinBuilder
extends ModuleLevelBuilder {
    private final TeamcityStatisticsLogger statisticsLogger = new TeamcityStatisticsLogger();
    @JvmField
    @NotNull
    public static final String KOTLIN_BUILDER_NAME = "Kotlin Builder";
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String JVM_BUILD_META_INFO_FILE_NAME = "jvm-build-meta-info.txt";
    @NotNull
    public static final String SKIP_CACHE_VERSION_CHECK_PROPERTY = "kotlin.jps.skip.cache.version.check";
    public static final Companion Companion;

    @NotNull
    public String getPresentableName() {
        return KOTLIN_BUILDER_NAME;
    }

    @NotNull
    public ArrayList<String> getCompilableFileExtensions() {
        return CollectionsKt.arrayListOf((Object[])new String[]{"kt"});
    }

    public void buildStarted(@NotNull CompileContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Companion.getLOG().debug("==========================================");
        Companion.getLOG().info("is Kotlin incremental compilation enabled: " + IncrementalCompilation.isEnabled());
        Companion.getLOG().info("is Kotlin experimental incremental compilation enabled: " + IncrementalCompilation.isExperimental());
        Companion.getLOG().info("is Kotlin compiler daemon enabled: " + DaemonParamsKt.isDaemonEnabled());
        String historyLabel = context.getBuilderParameter("history label");
        if (historyLabel != null) {
            Companion.getLOG().info("Label in local history: " + historyLabel);
        }
    }

    public void buildFinished(@Nullable CompileContext context) {
        this.statisticsLogger.reportTotal();
    }

    public void chunkBuildStarted(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        boolean bl;
        block5: {
            BuildDataManager dataManager;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
            super.chunkBuildStarted(context, chunk);
            Object object = TestingContextKt.getTestingContext(context);
            if (object != null && (object = ((TestingContext)object).getBuildLogger()) != null) {
                object.buildStarted(context, chunk);
            }
            if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) {
                return;
            }
            Set targets = chunk.getTargets();
            BuildDataManager buildDataManager = dataManager = context.getProjectDescriptor().dataManager;
            Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
            HasKotlinMarker hasKotlin = new HasKotlinMarker(buildDataManager);
            Iterable $receiver$iv = targets;
            for (Object element$iv : $receiver$iv) {
                ModuleBuildTarget it;
                ModuleBuildTarget moduleBuildTarget = it = (ModuleBuildTarget)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"it");
                if (!Intrinsics.areEqual((Object)hasKotlin.get(moduleBuildTarget), (Object)true)) continue;
                bl = false;
                break block5;
            }
            bl = true;
        }
        if (bl) {
            return;
        }
        if (System.getProperty(SKIP_CACHE_VERSION_CHECK_PROPERTY) == null) {
            this.checkCachesVersions(context, chunk);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCachesVersions(CompileContext context, ModuleChunk chunk) {
        void $receiver$iv$iv;
        Iterable<CacheVersion> allVersions;
        Iterable<CacheVersion> $receiver$iv;
        Set targets = chunk.getTargets();
        BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        BuildDataPaths buildDataPaths = dataManager.getDataPaths();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataPaths, (String)"dataManager.dataPaths");
        CacheVersionProvider cacheVersionsProvider = new CacheVersionProvider(buildDataPaths);
        Set set = targets;
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"targets");
        Iterable<CacheVersion> iterable = $receiver$iv = (allVersions = cacheVersionsProvider.allVersions(set));
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CacheVersion cacheVersion = (CacheVersion)item$iv$iv;
            Collection collection = destination$iv$iv;
            CacheVersion.Action action = it.checkVersion();
            collection.add(action);
        }
        Set actions = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        if (!JpsUtils.isJsKotlinModule(chunk.representativeTarget())) {
            CommonCompilerArguments args = this.compilerArgumentsForChunk(chunk);
            JvmBuildMetaInfo currentBuildMetaInfo = JvmBuildMetaInfoKt.JvmBuildMetaInfo(args);
            Iterator<Object> iterator2 = chunk.getTargets().iterator();
            while (iterator2.hasNext()) {
                JvmBuildMetaInfo $i$a$1$map;
                ModuleBuildTarget target;
                ModuleBuildTarget moduleBuildTarget = target = (ModuleBuildTarget)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
                BuildDataManager buildDataManager = dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
                File file = KotlinBuilderKt.jvmBuildMetaInfoFile(moduleBuildTarget, buildDataManager);
                if (!file.exists()) continue;
                try {
                    if (JvmBuildMetaInfo.Companion.deserializeFromString(FilesKt.readText$default((File)file, null, (int)1, null)) == null) {
                        continue;
                    }
                }
                catch (Exception e) {
                    Companion.getLOG().error("Could not deserialize jvm build meta info", (Throwable)e);
                    continue;
                }
                JvmBuildMetaInfo lastBuildMetaInfo = $i$a$1$map;
                LanguageVersion lastBuildLangVersion = LanguageVersion.Companion.fromVersionString(lastBuildMetaInfo.getLanguageVersionString());
                if (!(Intrinsics.areEqual((Object)lastBuildLangVersion, (Object)LanguageVersion.KOTLIN_1_0) ^ true) || !lastBuildMetaInfo.isEAP() || currentBuildMetaInfo.isEAP()) continue;
                Companion.getLOG().info("Last build was compiled with EAP-plugin. Performing non-incremental rebuild (kotlin only)");
                actions.add(CacheVersion.Action.REBUILD_ALL_KOTLIN);
            }
        }
        Logger logger = Companion.getLOG();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
        FSOperationsHelper fsOperations = new FSOperationsHelper(context, chunk, logger);
        BuildDataManager buildDataManager = dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
        Set set2 = targets;
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"targets");
        this.applyActionsOnCacheVersionChange(actions, cacheVersionsProvider, context, buildDataManager, set2, fsOperations);
    }

    public void chunkBuildFinished(@Nullable CompileContext context, @Nullable ModuleChunk chunk) {
        super.chunkBuildFinished(context, chunk);
        Companion.getLOG().debug("------------------------------------------");
    }

    @NotNull
    public ModuleLevelBuilder.ExitCode build(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        Intrinsics.checkParameterIsNotNull(dirtyFilesHolder, (String)"dirtyFilesHolder");
        Intrinsics.checkParameterIsNotNull((Object)outputConsumer, (String)"outputConsumer");
        MessageCollectorAdapter messageCollector = new MessageCollectorAdapter(context);
        Logger logger = Companion.getLOG();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
        FSOperationsHelper fsOperations = new FSOperationsHelper(context, chunk, logger);
        try {
            ModuleLevelBuilder.ExitCode proposedExitCode = this.doBuild(chunk, context, dirtyFilesHolder, messageCollector, outputConsumer, fsOperations);
            ModuleLevelBuilder.ExitCode actualExitCode = Intrinsics.areEqual((Object)proposedExitCode, (Object)ModuleLevelBuilder.ExitCode.OK) && fsOperations.getHasMarkedDirty$jps_plugin() ? ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED : proposedExitCode;
            Companion.getLOG().debug("Build result: " + actualExitCode);
            Object object = TestingContextKt.getTestingContext(context);
            if (object != null && (object = ((TestingContext)object).getBuildLogger()) != null) {
                object.buildFinished(actualExitCode);
            }
            return actualExitCode;
        }
        catch (StopBuildException e) {
            Companion.getLOG().info("Caught exception: " + (Object)((Object)e));
            throw (Throwable)e;
        }
        catch (Throwable e) {
            Companion.getLOG().info("Caught exception: " + e);
            String string = OutputMessageUtil.renderException(e);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"OutputMessageUtil.renderException(e)");
            messageCollector.report(CompilerMessageSeverity.EXCEPTION, string, CompilerMessageLocation.NO_LOCATION);
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ModuleLevelBuilder.ExitCode doBuild(ModuleChunk chunk, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, MessageCollectorAdapter messageCollector, ModuleLevelBuilder.OutputConsumer outputConsumer, FSOperationsHelper fsOperations) {
        block22: {
            block21: {
                if (!((Boolean)JavaBuilder.IS_ENABLED.get((UserDataHolder)context, (Object)true)).booleanValue() && !JpsUtils.isJsKotlinModule(chunk.representativeTarget())) {
                    messageCollector.report(CompilerMessageSeverity.INFO, "Kotlin JPS plugin is disabled", CompilerMessageLocation.NO_LOCATION);
                    return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                }
                projectDescriptor = context.getProjectDescriptor();
                dataManager = projectDescriptor.dataManager;
                targets = chunk.getTargets();
                v0 = dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"dataManager");
                hasKotlin = new HasKotlinMarker(v0);
                v1 = dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"dataManager");
                rebuildAfterCacheVersionChanged = new RebuildAfterCacheVersionChangeMarker(v1);
                if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) ** GOTO lbl-1000
                $receiver$iv = targets;
                for (T element$iv : $receiver$iv) {
                    v2 = it = (ModuleBuildTarget)element$iv /* !! */ ;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                    if (!Intrinsics.areEqual((Object)rebuildAfterCacheVersionChanged.get(v2), (Object)true)) continue;
                    v3 = true;
                    break block21;
                }
                v3 = false;
            }
            if (v3) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else {
                v4 = isChunkRebuilding = false;
            }
            if (!KotlinBuilderKt.access$hasKotlinDirtyOrRemovedFiles(dirtyFilesHolder, chunk)) {
                if (isChunkRebuilding) {
                    $receiver$iv = targets;
                    for (T element$iv : $receiver$iv) {
                        v5 = it = (ModuleBuildTarget)element$iv /* !! */ ;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
                        hasKotlin.set(v5, false);
                    }
                }
                $receiver$iv = targets;
                for (T element$iv : $receiver$iv) {
                    v6 = it = (ModuleBuildTarget)element$iv /* !! */ ;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it");
                    rebuildAfterCacheVersionChanged.clean(v6);
                }
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            messageCollector.report(CompilerMessageSeverity.INFO, "Kotlin JPS plugin version 1.1.2", CompilerMessageLocation.NO_LOCATION);
            $receiver$iv = targets;
            element$iv /* !! */  = $receiver$iv;
            destination$iv$iv = new ArrayList<E>();
            for (T element$iv$iv : $receiver$iv$iv) {
                it = (ModuleBuildTarget)element$iv$iv;
                if (!(it.getOutputDir() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            targetsWithoutOutputDir = (List)destination$iv$iv;
            $receiver$iv = targetsWithoutOutputDir;
            if ($receiver$iv.isEmpty() == false) {
                messageCollector.report(CompilerMessageSeverity.ERROR, "Output directory not specified for " + CollectionsKt.joinToString$default((Iterable)targetsWithoutOutputDir, null, null, null, (int)0, null, null, (int)63, null), CompilerMessageLocation.NO_LOCATION);
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            v7 = project = projectDescriptor.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"project");
            lookupTracker = KotlinBuilderKt.access$getLookupTracker(v7);
            incrementalCaches = KotlinBuilderKt.access$getIncrementalCaches(chunk, context);
            environment = this.createCompileEnvironment(incrementalCaches, lookupTracker, context, messageCollector);
            if (!environment.success()) {
                environment.reportErrorsTo(messageCollector);
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            commonArguments = this.compilerArgumentsForChunk(chunk);
            commonArguments.verbose = true;
            allCompiledFiles = KotlinBuilderKt.access$getAllCompiledFilesContainer(context);
            filesToCompile = KotlinSourceFileCollector.getDirtySourceFiles(dirtyFilesHolder);
            KotlinBuilder.Companion.getLOG().debug("Compiling files: " + filesToCompile.values());
            start = System.nanoTime();
            v8 = filesToCompile;
            Intrinsics.checkExpressionValueIsNotNull(v8, (String)"filesToCompile");
            v9 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"project");
            outputItemCollector = this.doCompileModuleChunk(allCompiledFiles, chunk, commonArguments, context, dirtyFilesHolder, environment, v8, incrementalCaches, messageCollector, v9);
            this.statisticsLogger.registerStatistic(chunk, System.nanoTime() - start);
            if (outputItemCollector == null) {
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            v10 = compilationErrors = (Boolean)Utils.ERRORS_DETECTED_KEY.get((UserDataHolder)context, (Object)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"compilationErrors");
            if (v10.booleanValue()) {
                KotlinBuilder.Companion.getLOG().info("Compiled with errors");
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            KotlinBuilder.Companion.getLOG().info("Compiled successfully");
            generatedFiles = this.getGeneratedFiles(chunk, environment.getOutputItemsCollector());
            this.registerOutputItems(outputConsumer, generatedFiles);
            this.saveVersions(context, chunk, commonArguments);
            $receiver$iv = targets;
            for (T element$iv : $receiver$iv) {
                v11 = it = (ModuleBuildTarget)element$iv /* !! */ ;
                Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"it");
                if (!(hasKotlin.get(v11) == null)) continue;
                v12 = true;
                break block22;
            }
            v12 = false;
        }
        if (v12) {
            fsOperations.markChunk(false, true, CollectionsKt.toSet((Iterable)filesToCompile.values()));
        }
        var27_26 = targets.iterator();
        while (var27_26.hasNext()) {
            v13 = target = (ModuleBuildTarget)var27_26.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"target");
            hasKotlin.set(v13, true);
            v14 = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"target");
            rebuildAfterCacheVersionChanged.clean(v14);
        }
        if (JpsUtils.isJsKotlinModule(chunk.representativeTarget())) {
            v15 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"project");
            this.copyJsLibraryFilesIfNeeded(chunk, v15);
            return ModuleLevelBuilder.ExitCode.OK;
        }
        $receiver$iv = generatedFiles;
        element$iv /* !! */  = $receiver$iv;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof GeneratedJvmClass)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        generatedClasses = (List)destination$iv$iv;
        v16 = compilationErrors;
        Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"compilationErrors");
        v17 = v16;
        v18 = filesToCompile;
        Intrinsics.checkExpressionValueIsNotNull(v18, (String)"filesToCompile");
        this.updateJavaMappings(chunk, v17, context, dirtyFilesHolder, v18, generatedClasses, incrementalCaches);
        if (!IncrementalCompilation.isEnabled()) {
            return ModuleLevelBuilder.ExitCode.OK;
        }
        context.checkCanceled();
        v19 = compilationErrors;
        Intrinsics.checkExpressionValueIsNotNull((Object)v19, (String)"compilationErrors");
        changesInfo = this.updateKotlinIncrementalCache(v19, incrementalCaches, generatedFiles);
        v20 = dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)v20, (String)"dataManager");
        v21 = filesToCompile;
        Intrinsics.checkExpressionValueIsNotNull(v21, (String)"filesToCompile");
        this.updateLookupStorage(chunk, lookupTracker, v20, dirtyFilesHolder, v21);
        if (isChunkRebuilding) {
            return ModuleLevelBuilder.ExitCode.OK;
        }
        v22 = CollectionsKt.toSet((Iterable)filesToCompile.values());
        v23 = dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)v23, (String)"dataManager");
        KotlinBuilderKt.access$processChanges(v22, allCompiledFiles, v23, incrementalCaches.values(), changesInfo, fsOperations);
        $receiver$iv = incrementalCaches.values();
        for (T element$iv : $receiver$iv) {
            it = (JpsIncrementalCacheImpl)element$iv;
            it.cleanDirtyInlineFunctions();
        }
        return ModuleLevelBuilder.ExitCode.OK;
    }

    /*
     * WARNING - void declaration
     */
    private final void applyActionsOnCacheVersionChange(Set<? extends CacheVersion.Action> actions, CacheVersionProvider cacheVersionsProvider, CompileContext context, BuildDataManager dataManager, Set<ModuleBuildTarget> targets, FSOperationsHelper fsOperations) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        BuildTargetIndex buildTargetIndex = context.getProjectDescriptor().getBuildTargetIndex();
        Iterable iterable = $receiver$iv = (Iterable)buildTargetIndex.getAllTargets();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof ModuleBuildTarget)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set allTargets = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        HasKotlinMarker hasKotlin = new HasKotlinMarker(dataManager);
        RebuildAfterCacheVersionChangeMarker rebuildAfterCacheVersionChanged = new RebuildAfterCacheVersionChangeMarker(dataManager);
        List sortedActions = CollectionsKt.sorted((Iterable)actions);
        Object object = TestingContextKt.getTestingContext(context);
        if (object != null && (object = ((TestingContext)object).getBuildLogger()) != null) {
            object.actionsOnCacheVersionChanged(sortedActions);
        }
        block8: for (CacheVersion.Action status : sortedActions) {
            switch (KotlinBuilder$WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1: {
                    void $receiver$iv$iv2;
                    Companion.getLOG().info("Kotlin global lookup map format changed, so rebuild all kotlin");
                    JpsProject project = context.getProjectDescriptor().getProject();
                    Iterable $receiver$iv2 = project.getModules();
                    Iterator iterator2 = $receiver$iv2;
                    Collection destination$iv$iv2 = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv2) {
                        JpsModule it = (JpsModule)element$iv$iv;
                        Iterable list$iv$iv = it.getSourceRoots();
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    List sourceRoots = (List)destination$iv$iv2;
                    iterator2 = sourceRoots.iterator();
                    while (iterator2.hasNext()) {
                        JpsModuleSourceRoot sourceRoot = (JpsModuleSourceRoot)iterator2.next();
                        Sequence ktFiles2 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)sourceRoot.getFile(), null, (int)1, null)), (Function1)applyActionsOnCacheVersionChange.ktFiles.1.INSTANCE);
                        FSOperationsHelper.markFiles$default(fsOperations, SequencesKt.asIterable((Sequence)ktFiles2), null, 2, null);
                    }
                    for (ModuleBuildTarget target : allTargets) {
                        JpsIncrementalCacheImplKt.getKotlinCache(dataManager, target).clean();
                        rebuildAfterCacheVersionChanged.set(target, true);
                    }
                    ((JpsLookupStorage)dataManager.getStorage((BuildTarget)KotlinDataContainerTarget.INSTANCE, (StorageProvider)JpsLookupStorageProvider.INSTANCE)).clean();
                    return;
                }
                case 2: {
                    Companion.getLOG().info("Clearing caches for " + CollectionsKt.joinToString$default((Iterable)targets, null, null, null, (int)0, null, (Function1)applyActionsOnCacheVersionChange.1.INSTANCE, (int)31, null));
                    for (ModuleBuildTarget target : targets) {
                        JpsIncrementalCacheImplKt.getKotlinCache(dataManager, target).clean();
                        hasKotlin.clean(target);
                        rebuildAfterCacheVersionChanged.set(target, true);
                    }
                    FSOperationsHelper.markChunk$default(fsOperations, false, true, null, 4, null);
                    return;
                }
                case 3: {
                    Companion.getLOG().info("Clearing caches for all targets");
                    for (ModuleBuildTarget target : allTargets) {
                        JpsIncrementalCacheImplKt.getKotlinCache(dataManager, target).clean();
                    }
                    continue block8;
                }
                case 4: {
                    Companion.getLOG().info("Clearing experimental caches for all targets");
                    for (ModuleBuildTarget target : allTargets) {
                        JpsIncrementalCacheImplKt.getKotlinCache(dataManager, target).cleanExperimental();
                    }
                    continue block8;
                }
                case 5: {
                    Companion.getLOG().info("Clearing lookup cache");
                    ((JpsLookupStorage)dataManager.getStorage((BuildTarget)KotlinDataContainerTarget.INSTANCE, (StorageProvider)JpsLookupStorageProvider.INSTANCE)).clean();
                    cacheVersionsProvider.dataContainerVersion().clean();
                    break;
                }
                default: {
                    boolean bl = Intrinsics.areEqual((Object)((Object)status), (Object)((Object)CacheVersion.Action.DO_NOTHING));
                    if (!_Assertions.ENABLED || bl) continue block8;
                    String string = "Unknown version status " + (Object)((Object)status);
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
            }
        }
    }

    private final void saveVersions(CompileContext context, ModuleChunk chunk, CommonCompilerArguments commonArguments) {
        BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        Set targets = chunk.getTargets();
        BuildDataPaths buildDataPaths = dataManager.getDataPaths();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataPaths, (String)"dataManager.dataPaths");
        CacheVersionProvider cacheVersionsProvider = new CacheVersionProvider(buildDataPaths);
        Set set = targets;
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"targets");
        Iterable<CacheVersion> $receiver$iv = cacheVersionsProvider.allVersions(set);
        Iterator<CacheVersion> iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            CacheVersion element$iv;
            CacheVersion it = element$iv = iterator2.next();
            it.saveIfNeeded();
        }
        if (!JpsUtils.isJsKotlinModule(chunk.representativeTarget())) {
            JvmBuildMetaInfo jvmBuildMetaInfo = JvmBuildMetaInfoKt.JvmBuildMetaInfo(commonArguments);
            String serializedMetaInfo = JvmBuildMetaInfo.Companion.serializeToString(jvmBuildMetaInfo);
            Iterator iterator3 = chunk.getTargets().iterator();
            while (iterator3.hasNext()) {
                ModuleBuildTarget target;
                ModuleBuildTarget moduleBuildTarget = target = (ModuleBuildTarget)iterator3.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
                BuildDataManager buildDataManager = dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
                FilesKt.writeText$default((File)KotlinBuilderKt.jvmBuildMetaInfoFile(moduleBuildTarget, buildDataManager), (String)serializedMetaInfo, null, (int)2, null);
            }
        }
    }

    private final CommonCompilerArguments compilerArgumentsForChunk(ModuleChunk chunk) {
        JpsModule jpsModule = chunk.representativeTarget().getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"chunk.representativeTarget().module");
        return JpsKotlinCompilerSettings.Companion.getCommonCompilerArguments(jpsModule);
    }

    /*
     * WARNING - void declaration
     */
    private final OutputItemsCollector doCompileModuleChunk(Set<File> allCompiledFiles, ModuleChunk chunk, CommonCompilerArguments commonArguments, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, JpsCompilerEnvironment environment, MultiMap<ModuleBuildTarget, File> filesToCompile, Map<ModuleBuildTarget, ? extends IncrementalCacheImpl<?>> incrementalCaches, MessageCollectorAdapter messageCollector, JpsProject project) {
        if (JpsUtils.isJsKotlinModule(chunk.representativeTarget())) {
            Companion.getLOG().debug("Compiling to JS " + filesToCompile.values().size() + " files in " + CollectionsKt.joinToString$default((Iterable)filesToCompile.keySet(), null, null, null, (int)0, null, (Function1)doCompileModuleChunk.1.INSTANCE, (int)31, null));
            return this.compileToJs(chunk, commonArguments, environment, project);
        }
        if (IncrementalCompilation.isEnabled()) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                IncrementalCacheImpl<?> cache;
                Collection<File> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                if (incrementalCaches.get(target) == null) {
                    Intrinsics.throwNpe();
                }
                Iterable iterable = dirtyFilesHolder.getRemovedFiles((BuildTarget)target);
                Collection collection2 = filesToCompile.get((Object)target);
                void var16_16 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void p1;
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    File file = new File((String)p1);
                    collection.add(file);
                }
                collection = (List)destination$iv$iv;
                List removedAndDirtyFiles = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
                cache.markOutputClassesDirty(removedAndDirtyFiles);
            }
        }
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        doCompileModuleChunk.2 concatenate$ = doCompileModuleChunk.2.INSTANCE;
        for (KotlinJpsCompilerArgumentsProvider argumentProvider : ServiceLoader.load(KotlinJpsCompilerArgumentsProvider.class)) {
            String[] stringArray = commonArguments.pluginOptions;
            ModuleBuildTarget moduleBuildTarget = representativeTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"representativeTarget");
            commonArguments.pluginOptions = concatenate$.invoke(stringArray, argumentProvider.getExtraArguments(moduleBuildTarget, context));
            String[] stringArray2 = commonArguments.pluginClasspaths;
            ModuleBuildTarget moduleBuildTarget2 = representativeTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget2, (String)"representativeTarget");
            commonArguments.pluginClasspaths = concatenate$.invoke(stringArray2, argumentProvider.getClasspath(moduleBuildTarget2, context));
            messageCollector.report(CompilerMessageSeverity.INFO, "Plugin loaded: " + argumentProvider.getClass().getSimpleName(), CompilerMessageLocation.NO_LOCATION);
        }
        return this.compileToJvm(allCompiledFiles, chunk, commonArguments, context, dirtyFilesHolder, environment, filesToCompile);
    }

    /*
     * WARNING - void declaration
     */
    private final JpsCompilerEnvironment createCompileEnvironment(Map<ModuleBuildTarget, ? extends IncrementalCache> incrementalCaches, LookupTracker lookupTracker, CompileContext context, MessageCollectorAdapter messageCollector) {
        Map map;
        void $receiver$iv$iv;
        void $receiver$iv;
        IncrementalCompilationComponentsImpl incrementalCompilationComponentsImpl;
        Services.Builder builder;
        Services.Builder $receiver = builder = new Services.Builder();
        Map<ModuleBuildTarget, ? extends IncrementalCache> map2 = incrementalCaches;
        IncrementalCompilationComponentsImpl incrementalCompilationComponentsImpl2 = incrementalCompilationComponentsImpl;
        IncrementalCompilationComponentsImpl incrementalCompilationComponentsImpl3 = incrementalCompilationComponentsImpl;
        Class<IncrementalCompilationComponents> clazz = IncrementalCompilationComponents.class;
        Services.Builder builder2 = $receiver;
        void var13_12 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            TargetId targetId = ModulesUtilKt.TargetId((ModuleBuildTarget)it.getKey());
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            TargetId targetId2 = targetId;
            Map map3 = map;
            Object v = it$iv$iv.getValue();
            map3.put(targetId2, v);
        }
        map = destination$iv$iv;
        incrementalCompilationComponentsImpl2(map, lookupTracker);
        builder2.register(clazz, incrementalCompilationComponentsImpl3);
        $receiver.register(CompilationCanceledStatus.class, new CompilationCanceledStatus(incrementalCaches, lookupTracker, context){
            final /* synthetic */ Map $incrementalCaches$inlined;
            final /* synthetic */ LookupTracker $lookupTracker$inlined;
            final /* synthetic */ CompileContext $context$inlined;
            {
                this.$incrementalCaches$inlined = map;
                this.$lookupTracker$inlined = lookupTracker;
                this.$context$inlined = compileContext;
            }

            public void checkCanceled() {
                if (this.$context$inlined.getCancelStatus().isCanceled()) {
                    throw (Throwable)((Object)new CompilationCanceledException());
                }
            }
        });
        Services compilerServices = $receiver.build();
        KotlinPaths kotlinPaths = PathUtil.getKotlinPathsForJpsPluginOrJpsTests();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinPaths, (String)"PathUtil.getKotlinPathsForJpsPluginOrJpsTests()");
        return new JpsCompilerEnvironment(kotlinPaths, compilerServices, createCompileEnvironment.1.INSTANCE, messageCollector, new OutputItemsCollectorImpl());
    }

    /*
     * WARNING - void declaration
     */
    private final List<GeneratedFile<ModuleBuildTarget>> getGeneratedFiles(ModuleChunk chunk, OutputItemsCollectorImpl outputItemCollector) {
        HashMap<File, ModuleBuildTarget> sourceToTarget = new HashMap<File, ModuleBuildTarget>();
        if (chunk.getTargets().size() > 1) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                for (File file : KotlinSourceFileCollector.getAllKotlinSourceFiles(target)) {
                    sourceToTarget.put(file, target);
                }
            }
        }
        ArrayList<GeneratedFile> result = new ArrayList<GeneratedFile>();
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        for (SimpleOutputItem outputItem : outputItemCollector.getOutputs()) {
            File target;
            File file;
            File file2;
            Object it;
            Collection<File> sourceFiles = outputItem.getSourceFiles();
            File outputFile = outputItem.getOutputFile();
            File file3 = (File)CollectionsKt.firstOrNull((Iterable)sourceFiles);
            if (file3 == null || (file3 = (ModuleBuildTarget)sourceToTarget.get(it = (file2 = file3))) == null) {
                void $receiver$iv$iv;
                Iterable $receiver$iv = chunk.getTargets();
                it = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    boolean bl;
                    ModuleBuildTarget it2 = (ModuleBuildTarget)element$iv$iv;
                    if (it2.getOutputDir() != null) {
                        File file4;
                        File it3;
                        File file5 = it3 = file4;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"it");
                        bl = FilesKt.startsWith((File)outputFile, (File)file5);
                    } else {
                        bl = false;
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                file3 = file = (ModuleBuildTarget)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
            }
            if (file3 == null) {
                file = target = representativeTarget;
            }
            if (StringsKt.endsWith$default((String)outputFile.getName(), (String)".class", (boolean)false, (int)2, null)) {
                File file6 = target;
                Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"target");
                Collection<File> collection = sourceFiles;
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"sourceFiles");
                File file7 = outputFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file7, (String)"outputFile");
                result.add(new GeneratedJvmClass<File>(file6, collection, file7));
                continue;
            }
            File file8 = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)file8, (String)"target");
            Collection<File> collection = sourceFiles;
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"sourceFiles");
            File file9 = outputFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file9, (String)"outputFile");
            result.add(new GeneratedFile<File>(file8, collection, file9));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateJavaMappings(ModuleChunk chunk, boolean compilationErrors, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, MultiMap<ModuleBuildTarget, File> filesToCompile, List<GeneratedJvmClass<ModuleBuildTarget>> generatedClasses, Map<ModuleBuildTarget, JpsIncrementalCacheImpl> incrementalCaches) {
        Collection collection;
        Mappings previousMappings = context.getProjectDescriptor().dataManager.getMappings();
        Callbacks.Backend callback = JavaBuilderUtil.getDependenciesRegistrar((CompileContext)context);
        Map targetDirtyFiles2 = org.jetbrains.kotlin.utils.CollectionsKt.keysToMap(chunk.getTargets(), (Function1)new Function1<ModuleBuildTarget, HashSet<File>>(dirtyFilesHolder, filesToCompile){
            final /* synthetic */ DirtyFilesHolder $dirtyFilesHolder;
            final /* synthetic */ MultiMap $filesToCompile;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final HashSet<File> invoke(ModuleBuildTarget it) {
                void var2_2;
                HashSet<E> files = new HashSet<E>();
                Iterable $receiver$iv = this.$dirtyFilesHolder.getRemovedFiles((BuildTarget)it);
                for (T item$iv : $receiver$iv) {
                    void p1;
                    String string = (String)item$iv;
                    Collection collection = files;
                    File file = new File((String)p1);
                    collection.add(file);
                }
                Collection cfr_ignored_0 = (Collection)files;
                files.addAll(this.$filesToCompile.get((Object)it));
                return var2_2;
            }
            {
                this.$dirtyFilesHolder = dirtyFilesHolder;
                this.$filesToCompile = multiMap;
                super(1);
            }
        });
        Function1<GeneratedJvmClass<ModuleBuildTarget>, Set<? extends File>> getOldSourceFiles$ = new Function1<GeneratedJvmClass<ModuleBuildTarget>, Set<? extends File>>(incrementalCaches, previousMappings){
            final /* synthetic */ Map $incrementalCaches;
            final /* synthetic */ Mappings $previousMappings;

            @NotNull
            public final Set<File> invoke(@NotNull GeneratedJvmClass<ModuleBuildTarget> generatedClass) {
                Intrinsics.checkParameterIsNotNull(generatedClass, (String)"generatedClass");
                JpsIncrementalCacheImpl jpsIncrementalCacheImpl = (JpsIncrementalCacheImpl)this.$incrementalCaches.get(generatedClass.getTarget());
                if (jpsIncrementalCacheImpl == null) {
                    return SetsKt.emptySet();
                }
                JpsIncrementalCacheImpl cache = jpsIncrementalCacheImpl;
                JvmClassName className2 = generatedClass.getOutputClass().getClassName();
                if (!cache.isMultifileFacade(className2)) {
                    return SetsKt.emptySet();
                }
                int name = this.$previousMappings.getName(className2.getInternalName());
                Collection collection = this.$previousMappings.getClassSources(name);
                if (collection == null || (collection = CollectionsKt.toSet((Iterable)collection)) == null) {
                    collection = SetsKt.emptySet();
                }
                return collection;
            }
            {
                this.$incrementalCaches = map;
                this.$previousMappings = mappings;
                super(1);
            }
        };
        for (GeneratedJvmClass<ModuleBuildTarget> generatedClass : generatedClasses) {
            Collection<String> collection2;
            void $receiver$iv$iv;
            void $receiver$iv;
            THashSet sourceFiles = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            sourceFiles.addAll((Collection)getOldSourceFiles$.invoke(generatedClass));
            Set set = (Set)targetDirtyFiles2.get(generatedClass.getTarget());
            sourceFiles.removeAll(set != null ? (Collection)set : (Collection)SetsKt.emptySet());
            sourceFiles.addAll(generatedClass.getSourceFiles());
            Iterable iterable = (Iterable)sourceFiles;
            String string = FileUtil.toSystemIndependentName((String)generatedClass.getOutputFile().getCanonicalPath());
            Callbacks.Backend backend = callback;
            void var16_16 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                collection2 = destination$iv$iv;
                String string2 = FileUtil.toSystemIndependentName((String)it.getCanonicalPath());
                collection2.add(string2);
            }
            collection2 = (List)destination$iv$iv;
            backend.associate(string, (Collection)collection2, new ClassReader(generatedClass.getOutputClass().getFileContents()));
        }
        Collection allCompiled = filesToCompile.values();
        if (compilationErrors) {
            collection = CollectionsKt.emptyList();
        } else {
            Collection collection3 = allCompiled;
            collection = collection3;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"allCompiled");
        }
        Collection successfullyCompiled = collection;
        JavaBuilderUtil.registerFilesToCompile((CompileContext)context, (Collection)allCompiled);
        JavaBuilderUtil.registerSuccessfullyCompiled((CompileContext)context, (Collection)successfullyCompiled);
    }

    /*
     * WARNING - void declaration
     */
    private final void registerOutputItems(ModuleLevelBuilder.OutputConsumer outputConsumer, List<? extends GeneratedFile<ModuleBuildTarget>> generatedFiles) {
        for (GeneratedFile<ModuleBuildTarget> generatedFile : generatedFiles) {
            Collection<String> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = generatedFile.getSourceFiles();
            File file = generatedFile.getOutputFile();
            BuildTarget buildTarget = (BuildTarget)generatedFile.getTarget();
            ModuleLevelBuilder.OutputConsumer outputConsumer2 = outputConsumer;
            void var6_6 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                String string = it.getPath();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            outputConsumer2.registerOutputFile(buildTarget, file, (Collection)collection);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CompilationResult updateKotlinIncrementalCache(boolean compilationErrors, Map<ModuleBuildTarget, JpsIncrementalCacheImpl> incrementalCaches, List<? extends GeneratedFile<ModuleBuildTarget>> generatedFiles) {
        void changesInfo;
        boolean bl = IncrementalCompilation.isEnabled();
        if (_Assertions.ENABLED && !bl) {
            String string = "updateKotlinIncrementalCache should not be called when incremental compilation disabled";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = CompilationResult.Companion.getNO_CHANGES();
        for (GeneratedFile<ModuleBuildTarget> generatedFile : generatedFiles) {
            CompilationResult compilationResult;
            JpsIncrementalCacheImpl ic;
            if (incrementalCaches.get(generatedFile.getTarget()) == null) {
                Intrinsics.throwNpe();
            }
            if (generatedFile instanceof GeneratedJvmClass) {
                compilationResult = ic.saveFileToCache((GeneratedJvmClass)generatedFile);
            } else {
                if (!GeneratedFilesKt.isModuleMappingFile(generatedFile.getOutputFile())) continue;
                compilationResult = ic.saveModuleMappingToCache(generatedFile.getSourceFiles(), generatedFile.getOutputFile());
            }
            CompilationResult newChangesInfo = compilationResult;
            changesInfo.element = ((CompilationResult)changesInfo.element).plus(newChangesInfo);
        }
        if (!compilationErrors) {
            Iterable iterable = incrementalCaches.values();
            for (GeneratedFile<Object> element$iv : iterable) {
                JpsIncrementalCacheImpl it = (JpsIncrementalCacheImpl)((Object)element$iv);
                CompilationResult newChangesInfo = it.clearCacheForRemovedClasses();
                changesInfo.element = ((CompilationResult)changesInfo.element).plus(newChangesInfo);
            }
        }
        return (CompilationResult)changesInfo.element;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateLookupStorage(ModuleChunk chunk, LookupTracker lookupTracker, BuildDataManager dataManager, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, MultiMap<ModuleBuildTarget, File> filesToCompile) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        if (!IncrementalCompilation.isExperimental()) {
            return;
        }
        if (!(lookupTracker instanceof LookupTrackerImpl)) {
            throw (Throwable)((Object)new AssertionError((Object)("Lookup tracker is expected to be LookupTrackerImpl, got " + lookupTracker.getClass())));
        }
        JpsLookupStorage lookupStorage = (JpsLookupStorage)dataManager.getStorage((BuildTarget)KotlinDataContainerTarget.INSTANCE, (StorageProvider)JpsLookupStorageProvider.INSTANCE);
        Iterable iterable = $receiver$iv = (Iterable)chunk.getTargets();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ModuleBuildTarget it = (ModuleBuildTarget)element$iv$iv;
            Iterable list$iv$iv = KotlinSourceFileCollector.getRemovedKotlinFiles(dirtyFilesHolder, it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List removedFiles = (List)destination$iv$iv;
        lookupStorage.removeLookupsFrom((Sequence<? extends File>)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)filesToCompile.values()), (Sequence)CollectionsKt.asSequence((Iterable)removedFiles)));
        Set set = ((LookupTrackerImpl)lookupTracker).getLookups().entrySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"lookupTracker.lookups.entrySet()");
        Set set2 = ((LookupTrackerImpl)lookupTracker).getPathInterner().getValues();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"lookupTracker.pathInterner.values");
        lookupStorage.addAll(set, set2);
    }

    /*
     * WARNING - void declaration
     */
    private final OutputItemsCollector compileToJs(ModuleChunk chunk, CommonCompilerArguments commonArguments, JpsCompilerEnvironment environment, JpsProject project) {
        String moduleName;
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        if (chunk.getModules().size() > 1) {
            Collection<String> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = chunk.getModules();
            StringBuilder stringBuilder = new StringBuilder().append("Circular dependencies are not supported. The following JS modules depend on each other: ");
            CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.STRONG_WARNING;
            MessageCollector messageCollector = environment.getMessageCollector();
            void var7_11 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                JpsModule jpsModule = (JpsModule)item$iv$iv;
                collection = destination$iv$iv;
                String string = it.getName();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            messageCollector.report(compilerMessageSeverity, stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).append(". ").append("Kotlin is not compiled for these modules").toString(), CompilerMessageLocation.NO_LOCATION);
            return null;
        }
        List<File> sourceFiles = KotlinSourceFileCollector.getAllKotlinSourceFiles(representativeTarget);
        if (sourceFiles.isEmpty()) {
            return null;
        }
        ModuleBuildTarget moduleBuildTarget = representativeTarget;
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"representativeTarget");
        File outputDir2 = KotlinBuilderModuleScriptGenerator.INSTANCE.getOutputDirSafe(moduleBuildTarget);
        JpsModule representativeModule = representativeTarget.getModule();
        String string = moduleName = representativeModule.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"moduleName");
        File outputFile = JpsJsModuleUtils.getOutputFile(outputDir2, string);
        ModuleBuildTarget moduleBuildTarget2 = representativeTarget;
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget2, (String)"representativeTarget");
        List<String> libraries = JpsJsModuleUtils.INSTANCE.getLibraryFilesAndDependencies(moduleBuildTarget2);
        JpsModule jpsModule = representativeModule;
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"representativeModule");
        CompilerSettings compilerSettings = JpsKotlinCompilerSettings.Companion.getCompilerSettings(jpsModule);
        JpsModule jpsModule2 = representativeModule;
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule2, (String)"representativeModule");
        K2JSCompilerArguments k2JsArguments = JpsKotlinCompilerSettings.Companion.getK2JsCompilerArguments(jpsModule2);
        JpsKotlinCompilerRunner compilerRunner = new JpsKotlinCompilerRunner();
        List<File> list = sourceFiles;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"sourceFiles");
        compilerRunner.runK2JsCompiler(commonArguments, k2JsArguments, compilerSettings, environment, (Collection<? extends File>)list, libraries, outputFile);
        return environment.getOutputItemsCollector();
    }

    private final void copyJsLibraryFilesIfNeeded(ModuleChunk chunk, JpsProject project) {
        ModuleBuildTarget representativeTarget;
        ModuleBuildTarget moduleBuildTarget = representativeTarget = chunk.representativeTarget();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"representativeTarget");
        File outputDir2 = KotlinBuilderModuleScriptGenerator.INSTANCE.getOutputDirSafe(moduleBuildTarget);
        JpsModule jpsModule = representativeTarget.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"representativeTarget.module");
        CompilerSettings compilerSettings = JpsKotlinCompilerSettings.Companion.getCompilerSettings(jpsModule);
        if (compilerSettings.copyJsLibraryFiles) {
            String outputLibraryRuntimeDirectory = new File(outputDir2, compilerSettings.outputDirectoryForJsLibraryFiles).getAbsolutePath();
            ArrayList libraryFilesToCopy = new ArrayList();
            ModuleBuildTarget moduleBuildTarget2 = representativeTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget2, (String)"representativeTarget");
            JpsJsModuleUtils.INSTANCE.getLibraryFiles(moduleBuildTarget2, libraryFilesToCopy);
            List list = libraryFilesToCopy;
            String string = outputLibraryRuntimeDirectory;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"outputLibraryRuntimeDirectory");
            JsLibraryUtils.copyJsFilesFromLibraries(list, string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final OutputItemsCollector compileToJvm(Set<File> allCompiledFiles, ModuleChunk chunk, CommonCompilerArguments commonArguments, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, JpsCompilerEnvironment environment, MultiMap<ModuleBuildTarget, File> filesToCompile) {
        JpsModule module;
        if (chunk.getModules().size() > 1) {
            Collection<String> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = chunk.getModules();
            StringBuilder stringBuilder = new StringBuilder().append("Circular dependencies are only partially supported. The following modules depend on each other: ");
            CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.STRONG_WARNING;
            MessageCollector messageCollector = environment.getMessageCollector();
            void var9_12 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                JpsModule jpsModule = (JpsModule)item$iv$iv;
                collection = destination$iv$iv;
                String string = it.getName();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            messageCollector.report(compilerMessageSeverity, stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).append(". ").append("Kotlin will compile them, but some strange effect may happen").toString(), CompilerMessageLocation.NO_LOCATION);
        }
        Collection collection = filesToCompile.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"filesToCompile.values()");
        allCompiledFiles.addAll(collection);
        Set processedTargetsWithRemoved = KotlinBuilderKt.access$getProcessedTargetsWithRemovedFilesContainer(context);
        int totalRemovedFiles = 0;
        for (ModuleBuildTarget target : chunk.getTargets()) {
            List<File> removedFilesInTarget = KotlinSourceFileCollector.getRemovedKotlinFiles(dirtyFilesHolder, target);
            if (removedFilesInTarget.isEmpty()) continue;
            ModuleBuildTarget moduleBuildTarget = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
            if (!processedTargetsWithRemoved.add(moduleBuildTarget)) continue;
            totalRemovedFiles += removedFilesInTarget.size();
        }
        File moduleFile = KotlinBuilderModuleScriptGenerator.INSTANCE.generateModuleDescription(context, chunk, filesToCompile, totalRemovedFiles != 0);
        if (moduleFile == null) {
            Companion.getLOG().debug("Not compiling, because no files affected: " + CollectionsKt.joinToString$default((Iterable)filesToCompile.keySet(), null, null, null, (int)0, null, (Function1)compileToJvm.2.INSTANCE, (int)31, null));
            return null;
        }
        JpsModule jpsModule = module = chunk.representativeTarget().getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"module");
        K2JVMCompilerArguments k2JvmArguments = JpsKotlinCompilerSettings.Companion.getK2JvmCompilerArguments(jpsModule);
        JpsModule jpsModule2 = module;
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule2, (String)"module");
        CompilerSettings compilerSettings = JpsKotlinCompilerSettings.Companion.getCompilerSettings(jpsModule2);
        Companion.getLOG().debug("Compiling to JVM " + filesToCompile.values().size() + " files" + (totalRemovedFiles == 0 ? "" : " (" + totalRemovedFiles + " removed files)") + " in " + CollectionsKt.joinToString$default((Iterable)filesToCompile.keySet(), null, null, null, (int)0, null, (Function1)compileToJvm.3.INSTANCE, (int)31, null));
        JpsKotlinCompilerRunner compilerRunner = new JpsKotlinCompilerRunner();
        compilerRunner.runK2JvmCompiler(commonArguments, k2JvmArguments, compilerSettings, environment, moduleFile);
        moduleFile.delete();
        return environment.getOutputItemsCollector();
    }

    public KotlinBuilder() {
        super(BuilderCategory.SOURCE_PROCESSOR);
    }

    static {
        Companion = new Companion(null);
        KOTLIN_BUILDER_NAME = KOTLIN_BUILDER_NAME;
        LOG = Logger.getInstance((String)"#org.jetbrains.kotlin.jps.build.KotlinBuilder");
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder$MessageCollectorAdapter;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "(Lorg/jetbrains/jps/incremental/CompileContext;)V", "hasErrors", "", "clear", "", "kind", "Lorg/jetbrains/jps/incremental/messages/BuildMessage$Kind;", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "renderLocationIfNeeded", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocation;", "report", "message", "jps-plugin"})
    public static final class MessageCollectorAdapter
    implements MessageCollector {
        private boolean hasErrors;
        private final CompileContext context;

        @Override
        public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            this.hasErrors |= severity.isError();
            String prefix = "";
            if (Intrinsics.areEqual((Object)((Object)severity), (Object)((Object)CompilerMessageSeverity.EXCEPTION))) {
                prefix = "[Internal Error] ";
            }
            this.context.processMessage((BuildMessage)new CompilerMessage("Kotlin", this.kind(severity), prefix + message + this.renderLocationIfNeeded(location), location.getPath(), -1L, -1L, -1L, (long)location.getLine(), (long)location.getColumn()));
        }

        @Override
        public void clear() {
            this.hasErrors = false;
        }

        @Override
        public boolean hasErrors() {
            return this.hasErrors;
        }

        private final String renderLocationIfNeeded(CompilerMessageLocation location) {
            if (Intrinsics.areEqual((Object)location, (Object)CompilerMessageLocation.NO_LOCATION)) {
                return "";
            }
            String pathname = "" + location.getPath();
            return new File(pathname).exists() ? "" : " (" + location + ")";
        }

        private final BuildMessage.Kind kind(CompilerMessageSeverity severity) {
            BuildMessage.Kind kind;
            switch (KotlinBuilder$MessageCollectorAdapter$WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                case 1: {
                    kind = BuildMessage.Kind.INFO;
                    break;
                }
                case 2: 
                case 3: {
                    kind = BuildMessage.Kind.ERROR;
                    break;
                }
                case 4: 
                case 5: {
                    kind = BuildMessage.Kind.WARNING;
                    break;
                }
                case 6: {
                    kind = BuildMessage.Kind.PROGRESS;
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Unsupported severity: " + (Object)((Object)severity));
                }
            }
            return kind;
        }

        public MessageCollectorAdapter(@NotNull CompileContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder$Companion;", "", "()V", "JVM_BUILD_META_INFO_FILE_NAME", "", "KOTLIN_BUILDER_NAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "SKIP_CACHE_VERSION_CHECK_PROPERTY", "jps-plugin"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

