/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.kotlin.incremental.IncrementalCacheImplKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0002\u0010\u0011J\u0019\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0010H\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/jps/build/MarkerFile;", "", "fileName", "", "paths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "(Ljava/lang/String;Lorg/jetbrains/jps/builders/storage/BuildDataPaths;)V", "markerFile", "Ljava/io/File;", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "getMarkerFile", "(Lorg/jetbrains/jps/incremental/ModuleBuildTarget;)Ljava/io/File;", "clean", "", "target", "get", "", "(Lorg/jetbrains/jps/incremental/ModuleBuildTarget;)Ljava/lang/Boolean;", "set", "value", "jps-plugin"})
public abstract class MarkerFile {
    private final String fileName;
    private final BuildDataPaths paths;

    @Nullable
    public final Boolean get(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        File file = this.getMarkerFile(target);
        if (!file.exists()) {
            return null;
        }
        String string = FilesKt.readText$default((File)file, null, (int)1, null);
        return Boolean.parseBoolean(string);
    }

    public final void set(@NotNull ModuleBuildTarget target, boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        File file = this.getMarkerFile(target);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        FilesKt.writeText$default((File)file, (String)String.valueOf(value), null, (int)2, null);
    }

    public final void clean(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.getMarkerFile(target).delete();
    }

    private final File getMarkerFile(@NotNull ModuleBuildTarget $receiver) {
        File directory = new File(this.paths.getTargetDataRoot((BuildTarget)$receiver), IncrementalCacheImplKt.getKOTLIN_CACHE_DIRECTORY_NAME());
        return new File(directory, this.fileName);
    }

    public MarkerFile(@NotNull String fileName, @NotNull BuildDataPaths paths) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)paths, (String)"paths");
        this.fileName = fileName;
        this.paths = paths;
    }
}

